/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.widgets;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.log.ColumnFilter;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.logviewer.Messages;
import org.netxms.ui.eclipse.logviewer.widgets.ConditionEditor;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectConditionEditor
extends ConditionEditor {
    private static final String[] OPERATIONS;
    private static final String EMPTY_SELECTION_TEXT;
    private WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
    private long objectId = 0L;
    private CLabel objectName;

    static {
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.ObjectConditionEditor_Is;
        Messages.get();
        stringArray[1] = Messages.ObjectConditionEditor_IsNot;
        Messages.get();
        stringArray[2] = Messages.ObjectConditionEditor_Within;
        Messages.get();
        stringArray[3] = Messages.ObjectConditionEditor_NotWithin;
        OPERATIONS = stringArray;
        Messages.get();
        EMPTY_SELECTION_TEXT = Messages.ObjectConditionEditor_None;
    }

    public ObjectConditionEditor(Composite parent, FormToolkit toolkit) {
        super(parent, toolkit);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ObjectConditionEditor.this.labelProvider.dispose();
            }
        });
    }

    @Override
    protected String[] getOperations() {
        return OPERATIONS;
    }

    @Override
    protected void createContent(Composite parent, ColumnFilter initialFilter) {
        Composite group = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 2;
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gd);
        this.objectName = new CLabel(group, 0);
        this.toolkit.adapt((Composite)this.objectName);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        this.objectName.setLayoutData((Object)gd);
        this.objectName.setText(EMPTY_SELECTION_TEXT);
        ImageHyperlink selectionLink = this.toolkit.createImageHyperlink(group, 0);
        selectionLink.setImage(SharedIcons.IMG_FIND);
        selectionLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ObjectConditionEditor.this.selectObject();
            }
        });
        if (initialFilter != null) {
            switch (initialFilter.getOperation()) {
                case 0: {
                    this.setSelectedOperation(initialFilter.isNegated() ? 1 : 0);
                    this.objectId = initialFilter.getNumericValue();
                    break;
                }
                case 6: {
                    this.setSelectedOperation(initialFilter.isNegated() ? 3 : 2);
                    this.objectId = initialFilter.getNumericValue();
                }
            }
            if (this.objectId != 0L) {
                AbstractObject object = ConsoleSharedData.getSession().findObjectById(this.objectId);
                if (object != null) {
                    this.objectName.setText(object.getObjectName());
                    this.objectName.setImage(this.labelProvider.getImage((Object)object));
                } else {
                    this.objectName.setText("[" + this.objectId + "]");
                }
            }
        }
    }

    private void selectObject() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell(), null, null);
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            AbstractObject[] objects = dlg.getSelectedObjects(AbstractObject.class);
            if (objects.length > 0) {
                this.objectId = objects[0].getObjectId();
                this.objectName.setText(objects[0].getObjectName());
                this.objectName.setImage(this.labelProvider.getImage((Object)objects[0]));
            } else {
                this.objectId = 0L;
                this.objectName.setText(EMPTY_SELECTION_TEXT);
                this.objectName.setImage(null);
            }
        }
    }

    @Override
    public ColumnFilter createFilter() {
        int op = this.getSelectedOperation();
        ColumnFilter filter = new ColumnFilter(op == 2 || op == 3 ? 6 : 0, this.objectId);
        filter.setNegated(op == 1 || op == 3);
        return filter;
    }
}

