/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.ChartDciConfig;
import org.netxms.ui.eclipse.charts.api.ChartFactory;
import org.netxms.ui.eclipse.dashboard.widgets.ComparisonChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.internal.BarChartConfig;

public class BarChartElement
extends ComparisonChartElement {
    private BarChartConfig config;

    public BarChartElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = BarChartConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new BarChartConfig();
        }
        this.refreshInterval = this.config.getRefreshRate();
        this.chart = ChartFactory.createBarChart((Composite)this, (int)0);
        this.chart.setTitleVisible(this.config.isShowTitle());
        this.chart.setChartTitle(this.config.getTitle());
        this.chart.setLegendPosition(this.config.getLegendPosition());
        this.chart.setLegendVisible(this.config.isShowLegend());
        this.chart.set3DModeEnabled(this.config.isShowIn3D());
        this.chart.setTransposed(this.config.isTransposed());
        this.chart.setTranslucent(this.config.isTranslucent());
        if (!this.config.isAutoScale()) {
            this.chart.setYAxisRange(this.config.getMinYScaleValue(), this.config.getMaxYScaleValue());
        }
        int index = 0;
        ChartDciConfig[] chartDciConfigArray = this.config.getDciList();
        int n = chartDciConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChartDciConfig dci = chartDciConfigArray[n2];
            this.chart.addParameter(new GraphItem(dci.nodeId, dci.dciId, 0, 0, Long.toString(dci.dciId), dci.getName()), 0.0);
            int color = dci.getColorAsInt();
            if (color != -1) {
                this.chart.setPaletteEntry(index, new ChartColor(color));
            }
            ++index;
            ++n2;
        }
        this.chart.initializationComplete();
        this.startRefreshTimer();
    }

    @Override
    protected ChartDciConfig[] getDciList() {
        return this.config.getDciList();
    }
}

