/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.dialogs;

import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.DateTimeSelector;

public class MaintanenceScheduleDialog
extends Dialog {
    private Date startDate;
    private Date endDate;
    private DateTimeSelector startDateSelector;
    private DateTimeSelector endDateSelector;
    private Label labelStartDate;
    private Label labelEndDate;

    public MaintanenceScheduleDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Schedule Maintenance");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.labelStartDate = new Label(dialogArea, 0);
        this.labelStartDate.setText("Start date");
        this.startDateSelector = new DateTimeSelector(dialogArea, 0);
        this.startDateSelector.setValue(new Date());
        this.startDateSelector.setToolTipText("Start date");
        this.labelEndDate = new Label(dialogArea, 0);
        this.labelEndDate.setText("End date");
        this.endDateSelector = new DateTimeSelector(dialogArea, 0);
        this.endDateSelector.setValue(new Date());
        this.startDateSelector.setToolTipText("End date");
        return dialogArea;
    }

    protected void okPressed() {
        this.startDate = this.startDateSelector.getValue();
        this.endDate = this.endDateSelector.getValue();
        if (this.startDate.after(this.endDate)) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Start time must be gather end time.");
            return;
        }
        super.okPressed();
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }
}

