/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.AbstractTraceWidget;

public abstract class AbstractTraceView
extends ViewPart {
    protected NXCSession session = ConsoleSharedData.getSession();
    private AbstractTraceWidget traceWidget;
    private Action actionClear;

    public void createPartControl(Composite parent) {
        this.traceWidget = this.createTraceWidget(parent);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.activateContext();
    }

    protected abstract AbstractTraceWidget createTraceWidget(Composite var1);

    protected AbstractTraceWidget getTraceWidget() {
        return this.traceWidget;
    }

    protected void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.library.context.AbstractTraceView");
        }
    }

    protected void createActions() {
        Messages.get();
        this.actionClear = new Action(Messages.AbstractTraceView_Clear, SharedIcons.CLEAR_LOG){

            public void run() {
                AbstractTraceView.this.traceWidget.clear();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.traceWidget.getActionShowFilter());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.traceWidget.getActionPause());
        manager.add((IAction)this.actionClear);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.traceWidget.getActionCopy());
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.traceWidget.getActionPause());
        manager.add((IAction)this.actionClear);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AbstractTraceView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.traceWidget.getViewer().getControl());
        this.traceWidget.getViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.traceWidget.getViewer());
    }

    protected void fillContextMenu(IMenuManager manager) {
    }

    public void setFocus() {
        this.traceWidget.setFocus();
    }

    protected void subscribe(final String channel) {
        new ConsoleJob(String.format("Subscribing to channel %s", channel), (IWorkbenchPart)this, "org.netxms.ui.eclipse.console", null){

            @Override
            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AbstractTraceView.this.session.subscribe(channel);
            }

            @Override
            protected String getErrorMessage() {
                return String.format("Cannot subscribe to channel %s", channel);
            }
        }.start();
    }

    protected void unsubscribe(final String channel) {
        ConsoleJob job = new ConsoleJob(String.format("Unsubscribing from channel %s", channel), null, "org.netxms.ui.eclipse.console", null){

            @Override
            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AbstractTraceView.this.session.unsubscribe(channel);
            }

            @Override
            protected String getErrorMessage() {
                return String.format("Cannot unsubscribe from channel %s", channel);
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }
}

