/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.views;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.agentmanager.Messages;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class ScreenshotView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.agentmanager.views.ScreenshotView";
    private NXCSession session;
    private long nodeId;
    private Image image;
    private Canvas canvas;
    private byte[] byteImage;
    private Action actionRefresh;
    private Action actionSave;
    private Action actionCopyToClipboard;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
        this.nodeId = Long.parseLong(site.getSecondaryId());
        Messages.get();
        this.setPartName(String.format(Messages.ScreenshotView_PartTitle, this.session.getObjectName(this.nodeId)));
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.canvas = new Canvas(parent, 0);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ScreenshotView.this.image != null) {
                    GC gc = e.gc;
                    gc.drawImage(ScreenshotView.this.image, 10, 10);
                }
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.refresh();
    }

    public void refresh() {
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.ScreenshotView_JobTitle, (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ScreenshotView.this.byteImage = session.takeScreenshot(ScreenshotView.this.nodeId, "Console");
                final ImageData data = new ImageData((InputStream)new ByteArrayInputStream(ScreenshotView.this.byteImage));
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ScreenshotView.this.image = new Image((Device)this.getDisplay(), data);
                        ScreenshotView.this.canvas.redraw();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ScreenshotView_JobError;
            }
        }.start();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                ScreenshotView.this.refresh();
            }
        };
        Messages.get();
        this.actionCopyToClipboard = new Action(Messages.ScreenshotView_CopyToClipboard, SharedIcons.COPY){

            public void run() {
                ImageTransfer imageTransfer = ImageTransfer.getInstance();
                Clipboard clipboard = new Clipboard(ScreenshotView.this.canvas.getDisplay());
                clipboard.setContents(new Object[]{ScreenshotView.this.image.getImageData()}, new Transfer[]{imageTransfer});
            }
        };
        Messages.get();
        this.actionSave = new Action(Messages.ScreenshotView_Save, SharedIcons.SAVE){

            public void run() {
                ScreenshotView.this.saveImage();
            }
        };
    }

    private void saveImage() {
        FileDialog fd = new FileDialog(this.getSite().getShell(), 8192);
        Messages.get();
        fd.setText(Messages.ScreenshotView_SaveScreenshot);
        fd.setFilterExtensions(new String[]{"*.png", "*.*"});
        String[] stringArray = new String[2];
        Messages.get();
        stringArray[0] = Messages.ScreenshotView_PngFiles;
        Messages.get();
        stringArray[1] = Messages.ScreenshotView_AllFiles;
        fd.setFilterNames(stringArray);
        fd.setFileName(String.valueOf(this.session.getObjectName(this.nodeId)) + "-screenshot.png");
        String name = fd.open();
        if (name == null) {
            return;
        }
        File outputFile = new File(name);
        try {
            outputFile.createNewFile();
        }
        catch (IOException e) {
            Shell shell = this.getViewSite().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ScreenshotView_Error, (String)String.format(Messages.ScreenshotView_CannotCreateFile, name, e.getLocalizedMessage()));
        }
        try {
            BufferedImage bi = ImageIO.read(new ByteArrayInputStream(this.byteImage));
            ImageIO.write((RenderedImage)bi, "png", outputFile);
        }
        catch (IOException e) {
            Shell shell = this.getViewSite().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ScreenshotView_Error, (String)String.format(Messages.ScreenshotView_CannotSaveImage, name, e.getLocalizedMessage()));
        }
    }

    public void setFocus() {
        this.canvas.setFocus();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }
}

