/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.Collection;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.datacollection.DataCollectionConfiguration;

public abstract class DataCollectionObject {
    public static final int DCO_TYPE_GENERIC = 0;
    public static final int DCO_TYPE_ITEM = 1;
    public static final int DCO_TYPE_TABLE = 2;
    public static final int INTERNAL = 0;
    public static final int AGENT = 1;
    public static final int SNMP = 2;
    public static final int CHECKPOINT_SNMP = 3;
    public static final int PUSH = 4;
    public static final int WINPERF = 5;
    public static final int ILO = 6;
    public static final int SCRIPT = 7;
    public static final int ACTIVE = 0;
    public static final int DISABLED = 1;
    public static final int NOT_SUPPORTED = 2;
    public static final int DT_INT = 0;
    public static final int DT_UINT = 1;
    public static final int DT_INT64 = 2;
    public static final int DT_UINT64 = 3;
    public static final int DT_STRING = 4;
    public static final int DT_FLOAT = 5;
    public static final int DT_NULL = 6;
    public static final int DCF_ADVANCED_SCHEDULE = 1;
    public static final int DCF_AGGREGATE_ON_CLUSTER = 128;
    public static final int DCF_TRANSFORM_AGGREGATED = 256;
    public static final int DCF_NO_STORAGE = 512;
    public static final int DCF_CACHE_MODE_MASK = 12288;
    public static final int DCF_AGGREGATE_WITH_ERRORS = 16384;
    protected DataCollectionConfiguration owner;
    protected long id;
    protected long templateId;
    protected long resourceId;
    protected long sourceNode;
    protected int pollingInterval;
    protected int retentionTime;
    protected int origin;
    protected int status;
    protected int flags;
    protected String transformationScript;
    protected String name;
    protected String description;
    protected String systemTag;
    protected String perfTabSettings;
    protected int snmpPort;
    protected ArrayList<String> schedules;
    protected Object userData;
    private String comments;

    protected DataCollectionObject(DataCollectionConfiguration owner, NXCPMessage msg) {
        this.owner = owner;
        this.id = msg.getFieldAsInt64(43L);
        this.templateId = msg.getFieldAsInt64(153L);
        this.resourceId = msg.getFieldAsInt64(266L);
        this.sourceNode = msg.getFieldAsInt64(195L);
        this.pollingInterval = msg.getFieldAsInt32(44L);
        this.retentionTime = msg.getFieldAsInt32(45L);
        this.origin = msg.getFieldAsInt32(46L);
        this.status = msg.getFieldAsInt32(48L);
        this.flags = msg.getFieldAsInt32(13L);
        this.transformationScript = msg.getFieldAsString(106L);
        this.name = msg.getFieldAsString(20L);
        this.description = msg.getFieldAsString(27L);
        this.systemTag = msg.getFieldAsString(346L);
        this.perfTabSettings = msg.getFieldAsString(325L);
        this.snmpPort = msg.getFieldAsInt32(80L);
        this.comments = msg.getFieldAsString(82L);
        int count = msg.getFieldAsInt32(182L);
        this.schedules = new ArrayList(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            this.schedules.add(msg.getFieldAsString(varId));
            ++i;
            ++varId;
        }
    }

    protected DataCollectionObject(DataCollectionConfiguration owner, long id) {
        this.owner = owner;
        this.id = id;
        this.templateId = 0L;
        this.resourceId = 0L;
        this.sourceNode = 0L;
        this.pollingInterval = 0;
        this.retentionTime = 0;
        this.origin = 1;
        this.status = 0;
        this.flags = 0;
        this.transformationScript = null;
        this.perfTabSettings = null;
        this.name = "";
        this.description = "";
        this.systemTag = "";
        this.snmpPort = 0;
        this.schedules = new ArrayList(0);
        this.comments = "";
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setFieldInt32(43L, (int)this.id);
        msg.setFieldInt32(44L, this.pollingInterval);
        msg.setFieldInt32(45L, this.retentionTime);
        msg.setFieldInt16(46L, this.origin);
        msg.setFieldInt16(48L, this.status);
        msg.setField(20L, this.name);
        msg.setField(27L, this.description);
        msg.setField(346L, this.systemTag);
        msg.setFieldInt16(13L, this.flags);
        msg.setField(106L, this.transformationScript);
        msg.setFieldInt32(266L, (int)this.resourceId);
        msg.setFieldInt32(195L, (int)this.sourceNode);
        if (this.perfTabSettings != null) {
            msg.setField(325L, this.perfTabSettings);
        }
        msg.setFieldInt16(80L, this.snmpPort);
        msg.setField(82L, this.comments);
        msg.setFieldInt32(182L, this.schedules.size());
        long varId = 0x10000000L;
        int i = 0;
        while (i < this.schedules.size()) {
            msg.setField(varId++, this.schedules.get(i));
            ++i;
        }
    }

    public long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(long templateId) {
        this.templateId = templateId;
    }

    public long getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(long resourceId) {
        this.resourceId = resourceId;
    }

    public long getSourceNode() {
        return this.sourceNode;
    }

    public void setSourceNode(long sourceNode) {
        this.sourceNode = sourceNode;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public int getComparablePollingInterval() {
        if ((this.flags & 1) != 0) {
            return -1;
        }
        if (this.pollingInterval <= 0) {
            return 0;
        }
        return this.pollingInterval;
    }

    public void setPollingInterval(int pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public int getComparableRetentionTime() {
        if ((this.flags & 0x200) != 0) {
            return -1;
        }
        if (this.retentionTime <= 0) {
            return 0;
        }
        return this.retentionTime;
    }

    public void setRetentionTime(int retentionTime) {
        this.retentionTime = retentionTime;
    }

    public int getOrigin() {
        return this.origin;
    }

    public void setOrigin(int origin) {
        this.origin = origin;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean isUseAdvancedSchedule() {
        return (this.flags & 1) != 0;
    }

    public void setUseAdvancedSchedule(boolean useAdvancedSchedule) {
        this.flags = useAdvancedSchedule ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getId() {
        return this.id;
    }

    public ArrayList<String> getSchedules() {
        return this.schedules;
    }

    public void setSchedules(Collection<String> newSchedules) {
        this.schedules.clear();
        for (String s : newSchedules) {
            this.schedules.add(new String(s));
        }
    }

    public DataCollectionConfiguration getOwner() {
        return this.owner;
    }

    public long getNodeId() {
        return this.owner.getNodeId();
    }

    public String getSystemTag() {
        return this.systemTag;
    }

    public void setSystemTag(String systemTag) {
        this.systemTag = systemTag;
    }

    public String getPerfTabSettings() {
        return this.perfTabSettings;
    }

    public void setPerfTabSettings(String perfTabSettings) {
        this.perfTabSettings = perfTabSettings;
    }

    public int getSnmpPort() {
        return this.snmpPort;
    }

    public void setSnmpPort(int snmpPort) {
        this.snmpPort = snmpPort;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getTransformationScript() {
        return this.transformationScript;
    }

    public void setTransformationScript(String transformationScript) {
        this.transformationScript = transformationScript;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public boolean isAggregateOnCluster() {
        return (this.flags & 0x80) != 0;
    }

    public void setAggregateOnCluster(boolean enable) {
        this.flags = enable ? (this.flags |= 0x80) : (this.flags &= 0xFFFFFF7F);
    }

    public boolean isAggregateWithErrors() {
        return (this.flags & 0x4000) != 0;
    }

    public void setAggregateWithErrors(boolean enable) {
        this.flags = enable ? (this.flags |= 0x4000) : (this.flags &= 0xFFFFBFFF);
    }

    public boolean isTransformAggregated() {
        return (this.flags & 0x100) != 0;
    }

    public void setTransformAggregated(boolean enable) {
        this.flags = enable ? (this.flags |= 0x100) : (this.flags &= 0xFFFFFEFF);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public AgentCacheMode getCacheMode() {
        return AgentCacheMode.getByValue((this.flags & 0x3000) >> 12);
    }

    public void setCacheMode(AgentCacheMode mode) {
        this.flags = this.flags & 0xFFFFCFFF | (mode.getValue() & 3) << 12;
    }
}

