/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import java.util.Date;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.ScheduledTask;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.tools.WidgetFactory;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.DateTimeSelector;

public class ScheduleSelector
extends Composite {
    private Button radioOneTimeSchedule;
    private Button radioCronSchedule;
    private Group scheduleGroup;
    private DateTimeSelector execDateSelector;
    private Text textSchedule;

    public ScheduleSelector(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.scheduleGroup = new Group(parent, 0);
        Messages.get();
        this.scheduleGroup.setText(Messages.ScheduleSelector_Schedule);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 4;
        layout.marginHeight = 4;
        layout.horizontalSpacing = 16;
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 2;
        this.scheduleGroup.setLayout((Layout)layout);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleSelector.this.execDateSelector.setEnabled(ScheduleSelector.this.radioOneTimeSchedule.getSelection());
                ScheduleSelector.this.textSchedule.setEnabled(ScheduleSelector.this.radioCronSchedule.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.radioOneTimeSchedule = new Button((Composite)this.scheduleGroup, 16);
        Messages.get();
        this.radioOneTimeSchedule.setText(Messages.ScheduleSelector_OneTimeExecution);
        this.radioOneTimeSchedule.setSelection(true);
        this.radioOneTimeSchedule.addSelectionListener(listener);
        WidgetFactory factory = new WidgetFactory(){

            @Override
            public Control createControl(Composite parent, int style) {
                return new DateTimeSelector(parent, style);
            }
        };
        this.execDateSelector = (DateTimeSelector)WidgetHelper.createLabeledControl((Composite)this.scheduleGroup, 0, factory, "", "WidgetHelper::default_layout_data");
        this.execDateSelector.setValue(new Date());
        this.radioCronSchedule = new Button((Composite)this.scheduleGroup, 16);
        Messages.get();
        this.radioCronSchedule.setText(Messages.ScheduleSelector_CronSchedule);
        this.radioCronSchedule.setSelection(false);
        this.radioCronSchedule.addSelectionListener(listener);
        this.textSchedule = new Text((Composite)this.scheduleGroup, 2048);
        this.textSchedule.setTextLimit(255);
        this.textSchedule.setText("");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textSchedule.setLayoutData((Object)gd);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.radioOneTimeSchedule.setEnabled(enabled);
        this.radioCronSchedule.setEnabled(enabled);
        if (enabled) {
            this.execDateSelector.setEnabled(this.radioOneTimeSchedule.getSelection());
            this.textSchedule.setEnabled(this.radioCronSchedule.getSelection());
        } else {
            this.execDateSelector.setEnabled(enabled);
            this.textSchedule.setEnabled(enabled);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.scheduleGroup.setVisible(visible);
    }

    public ScheduledTask getSchedule() {
        return new ScheduledTask("Upload.File", this.radioCronSchedule.getSelection() ? this.textSchedule.getText() : "", "", this.execDateSelector.getValue(), 0, 0L);
    }

    public void setSchedule(ScheduledTask scheduledTask) {
        if (scheduledTask.getSchedule().isEmpty()) {
            this.radioOneTimeSchedule.setSelection(true);
            this.textSchedule.setEnabled(false);
            this.execDateSelector.setEnabled(true);
            this.execDateSelector.setValue(scheduledTask.getExecutionTime());
        } else {
            this.radioOneTimeSchedule.setSelection(false);
            this.radioCronSchedule.setSelection(true);
            this.textSchedule.setEnabled(true);
            this.execDateSelector.setEnabled(false);
            this.textSchedule.setText(scheduledTask.getSchedule());
        }
    }
}

