/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.TableThreshold;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class TableThresholdLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private NXCSession session = ConsoleSharedData.getSession();
    private WorkbenchLabelProvider eventLabelProvider = new WorkbenchLabelProvider();
    private Image thresholdIcon = Activator.getImageDescriptor("icons/threshold.png").createImage();

    public Image getColumnImage(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.thresholdIcon;
            }
            case 1: {
                EventTemplate event = this.session.findEventTemplateByCode((long)((TableThreshold)element).getActivationEvent());
                return StatusDisplayInfo.getStatusImage((Severity)(event != null ? event.getSeverity() : Severity.UNKNOWN));
            }
            case 2: {
                EventTemplate event = this.session.findEventTemplateByCode((long)((TableThreshold)element).getDeactivationEvent());
                return StatusDisplayInfo.getStatusImage((Severity)(event != null ? event.getSeverity() : Severity.UNKNOWN));
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ((TableThreshold)element).getConditionAsText();
            }
            case 1: {
                EventTemplate event = this.session.findEventTemplateByCode((long)((TableThreshold)element).getActivationEvent());
                return this.eventLabelProvider.getText((Object)event);
            }
            case 2: {
                EventTemplate event = this.session.findEventTemplateByCode((long)((TableThreshold)element).getDeactivationEvent());
                return this.eventLabelProvider.getText((Object)event);
            }
        }
        return null;
    }

    public void dispose() {
        this.thresholdIcon.dispose();
        this.eventLabelProvider.dispose();
        super.dispose();
    }
}

