/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.GraphItemStyle;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.ChartDciConfig;
import org.netxms.ui.eclipse.charts.api.ChartFactory;
import org.netxms.ui.eclipse.charts.api.HistoricalDataChart;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.LineChartConfig;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ViewRefreshController;

public class LineChartElement
extends ElementWidget {
    private HistoricalDataChart chart;
    private LineChartConfig config;
    private ViewRefreshController refreshController;
    private boolean updateInProgress = false;
    private NXCSession session;
    private List<DataCacheElement> dataCache = new ArrayList<DataCacheElement>(16);

    public LineChartElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        this.session = ConsoleSharedData.getSession();
        try {
            this.config = LineChartConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new LineChartConfig();
        }
        this.setLayout((Layout)new FillLayout());
        this.chart = ChartFactory.createLineChart((Composite)this, (int)0);
        this.chart.setZoomEnabled(false);
        this.chart.setTitleVisible(this.config.isShowTitle());
        this.chart.setChartTitle(this.config.getTitle());
        this.chart.setLegendVisible(this.config.isShowLegend());
        this.chart.setLegendPosition(this.config.getLegendPosition());
        this.chart.setExtendedLegend(this.config.isExtendedLegend());
        this.chart.setGridVisible(this.config.isShowGrid());
        this.chart.setLogScaleEnabled(this.config.isLogScaleEnabled());
        this.chart.setStacked(this.config.isStacked());
        this.chart.setLineWidth(this.config.getLineWidth());
        this.chart.setTranslucent(this.config.isTranslucent());
        if (!this.config.isAutoScale()) {
            this.chart.setYAxisRange(this.config.getMinYScaleValue(), this.config.getMaxYScaleValue());
        }
        ArrayList<GraphItemStyle> styles = new ArrayList<GraphItemStyle>(this.config.getDciList().length);
        int index = 0;
        ChartDciConfig[] chartDciConfigArray = this.config.getDciList();
        int n = chartDciConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChartDciConfig dci = chartDciConfigArray[n2];
            this.chart.addParameter(new GraphItem(dci.nodeId, dci.dciId, 0, 0, Long.toString(dci.dciId), dci.getName(), dci.getDisplayFormat()));
            int color = dci.getColorAsInt();
            if (color == -1) {
                color = ChartColor.getDefaultColor((int)index).getRGB();
            }
            styles.add(new GraphItemStyle(dci.area ? 1 : 0, color, 2, dci.invertValues ? 8 : 0));
            ++index;
            ++n2;
        }
        this.chart.setItemStyles(styles);
        this.refreshController = new ViewRefreshController(viewPart, this.config.getRefreshRate(), new Runnable(){

            @Override
            public void run() {
                if (LineChartElement.this.isDisposed()) {
                    return;
                }
                LineChartElement.this.refreshData();
            }
        });
        this.refreshData();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LineChartElement.this.refreshController.dispose();
            }
        });
    }

    private void refreshData() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.LineChartElement_JobTitle, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.dashboard", "org.netxms.ui.eclipse.dashboard"){
            private ChartDciConfig currentDci;

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Date from = new Date(System.currentTimeMillis() - LineChartElement.this.config.getTimeRangeMillis());
                final Date to = new Date(System.currentTimeMillis());
                final ChartDciConfig[] dciList = LineChartElement.this.config.getDciList();
                final DciData[] data = new DciData[dciList.length];
                int i = 0;
                while (i < dciList.length) {
                    this.currentDci = dciList[i];
                    data[i] = this.currentDci.type == 1 ? LineChartElement.this.session.getCollectedData(this.currentDci.nodeId, this.currentDci.dciId, from, to, 0) : LineChartElement.this.session.getCollectedTableData(this.currentDci.nodeId, this.currentDci.dciId, this.currentDci.instance, this.currentDci.column, from, to, 0);
                    ++i;
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!((Widget)LineChartElement.this.chart).isDisposed()) {
                            LineChartElement.this.dataCache.clear();
                            LineChartElement.this.chart.setTimeRange(from, to);
                            int i = 0;
                            while (i < data.length) {
                                LineChartElement.this.chart.updateParameter(i, data[i], false);
                                LineChartElement.this.dataCache.add(new DataCacheElement(dciList[i], data[i]));
                                ++i;
                            }
                            LineChartElement.this.chart.refresh();
                            LineChartElement.this.chart.clearErrors();
                        }
                        LineChartElement.this.updateInProgress = false;
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.LineChartElement_JobError, LineChartElement.this.session.getObjectName(this.currentDci.nodeId), this.currentDci.name);
            }

            protected void jobFailureHandler() {
                LineChartElement.this.updateInProgress = false;
                super.jobFailureHandler();
            }

            protected IStatus createFailureStatus(final Exception e) {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        LineChartElement.this.chart.addError(String.valueOf(this.getErrorMessage()) + " (" + e.getLocalizedMessage() + ")");
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.start();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        if (hHint == -1 && size.y < 210) {
            size.y = 210;
        }
        return size;
    }

    public List<DataCacheElement> getDataCache() {
        return new ArrayList<DataCacheElement>(this.dataCache);
    }

    public class DataCacheElement {
        public DciData data;
        public String name;

        public DataCacheElement(ChartDciConfig config, DciData data) {
            this.name = config.getName();
            this.data = data;
        }
    }
}

