/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.tools;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public class ImageCache
implements DisposeListener {
    private Map<ImageDescriptor, Image> cache = new HashMap<ImageDescriptor, Image>();

    public ImageCache() {
    }

    public ImageCache(Control control) {
        control.addDisposeListener((DisposeListener)this);
    }

    public Image add(ImageDescriptor descriptor) {
        Image image = this.cache.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            this.cache.put(descriptor, image);
        }
        return image;
    }

    public Image get(ImageDescriptor descriptor) {
        return this.cache.get(descriptor);
    }

    public void dispose() {
        for (Image image : this.cache.values()) {
            image.dispose();
        }
        this.cache.clear();
    }

    public void widgetDisposed(DisposeEvent e) {
        this.dispose();
    }
}

