/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementListUnion;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.ElementMapUnion;
import org.simpleframework.xml.ElementUnion;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Text;
import org.simpleframework.xml.Version;
import org.simpleframework.xml.core.AttributeException;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.ElementException;
import org.simpleframework.xml.core.Expression;
import org.simpleframework.xml.core.ExpressionBuilder;
import org.simpleframework.xml.core.Instantiator;
import org.simpleframework.xml.core.InstantiatorBuilder;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.LabelFactory;
import org.simpleframework.xml.core.LabelMap;
import org.simpleframework.xml.core.Model;
import org.simpleframework.xml.core.ModelAssembler;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.Scanner;
import org.simpleframework.xml.core.Structure;
import org.simpleframework.xml.core.TextException;
import org.simpleframework.xml.core.TreeModel;
import org.simpleframework.xml.core.UnionException;
import org.simpleframework.xml.stream.Format;

class StructureBuilder {
    private InstantiatorBuilder resolver;
    private ExpressionBuilder builder;
    private ModelAssembler assembler;
    private Instantiator factory;
    private LabelMap attributes;
    private LabelMap elements;
    private LabelMap texts;
    private Scanner scanner;
    private Format format;
    private Label version;
    private Label text;
    private Model root;
    private Class type;
    private boolean primitive;

    public StructureBuilder(Scanner scanner2, Class type, Format format) throws Exception {
        this.builder = new ExpressionBuilder(type, format);
        this.assembler = new ModelAssembler(this.builder, type, format);
        this.resolver = new InstantiatorBuilder(scanner2, type);
        this.root = new TreeModel(scanner2, type);
        this.attributes = new LabelMap(scanner2);
        this.elements = new LabelMap(scanner2);
        this.texts = new LabelMap(scanner2);
        this.scanner = scanner2;
        this.format = format;
        this.type = type;
    }

    public void assemble(Class type) throws Exception {
        Order order = this.scanner.getOrder();
        if (order != null) {
            this.assembler.assemble(this.root, order);
        }
    }

    public void process(Contact field, Annotation label) throws Exception {
        if (label instanceof Attribute) {
            this.process(field, label, this.attributes);
        }
        if (label instanceof ElementUnion) {
            this.union(field, label, this.elements);
        }
        if (label instanceof ElementListUnion) {
            this.union(field, label, this.elements);
        }
        if (label instanceof ElementMapUnion) {
            this.union(field, label, this.elements);
        }
        if (label instanceof ElementList) {
            this.process(field, label, this.elements);
        }
        if (label instanceof ElementArray) {
            this.process(field, label, this.elements);
        }
        if (label instanceof ElementMap) {
            this.process(field, label, this.elements);
        }
        if (label instanceof Element) {
            this.process(field, label, this.elements);
        }
        if (label instanceof Version) {
            this.version(field, label);
        }
        if (label instanceof Text) {
            this.text(field, label);
        }
    }

    private void union(Contact field, Annotation type, LabelMap map) throws Exception {
        Annotation[] list;
        for (Annotation value : list = this.extract(type)) {
            Label label = LabelFactory.getInstance(field, type, value, this.format);
            String path = label.getPath();
            String name = label.getName();
            if (map.get(path) != null) {
                throw new PersistenceException("Duplicate annotation of name '%s' on %s", name, label);
            }
            this.process(field, label, map);
        }
    }

    private void process(Contact field, Annotation type, LabelMap map) throws Exception {
        Label label = LabelFactory.getInstance(field, type, this.format);
        String path = label.getPath();
        String name = label.getName();
        if (map.get(path) != null) {
            throw new PersistenceException("Duplicate annotation of name '%s' on %s", name, field);
        }
        this.process(field, label, map);
    }

    private void process(Contact field, Label label, LabelMap map) throws Exception {
        Expression expression = label.getExpression();
        String path = label.getPath();
        Model model = this.root;
        if (!expression.isEmpty()) {
            model = this.register(expression);
        }
        this.resolver.register(label);
        model.register(label);
        map.put(path, label);
    }

    private void text(Contact field, Annotation type) throws Exception {
        Label label = LabelFactory.getInstance(field, type, this.format);
        Expression expression = label.getExpression();
        String path = label.getPath();
        Model model = this.root;
        if (!expression.isEmpty()) {
            model = this.register(expression);
        }
        if (this.texts.get(path) != null) {
            throw new TextException("Multiple text annotations in %s", type);
        }
        this.resolver.register(label);
        model.register(label);
        this.texts.put(path, label);
    }

    private void version(Contact field, Annotation type) throws Exception {
        Label label = LabelFactory.getInstance(field, type, this.format);
        if (this.version != null) {
            throw new AttributeException("Multiple version annotations in %s", type);
        }
        this.version = label;
    }

    private Annotation[] extract(Annotation label) throws Exception {
        Class<? extends Annotation> union = label.annotationType();
        Method[] list = union.getDeclaredMethods();
        if (list.length != 1) {
            throw new UnionException("Annotation '%s' is not a valid union for %s", label, this.type);
        }
        Method method = list[0];
        Object value = method.invoke((Object)label, new Object[0]);
        return (Annotation[])value;
    }

    public Structure build(Class type) throws Exception {
        return new Structure(this.factory, this.root, this.version, this.text, this.primitive);
    }

    private boolean isElement(String path) throws Exception {
        Expression target = this.builder.build(path);
        Model model = this.lookup(target);
        if (model != null) {
            String name = target.getLast();
            int index = target.getIndex();
            if (model.isElement(name)) {
                return true;
            }
            if (model.isModel(name)) {
                Model element = model.lookup(name, index);
                return !element.isEmpty();
            }
        }
        return false;
    }

    private boolean isAttribute(String path) throws Exception {
        Expression target = this.builder.build(path);
        Model model = this.lookup(target);
        if (model != null) {
            String name = target.getLast();
            if (!target.isPath()) {
                return model.isAttribute(path);
            }
            return model.isAttribute(name);
        }
        return false;
    }

    private Model lookup(Expression path) throws Exception {
        Expression target = path.getPath(0, 1);
        if (path.isPath()) {
            return this.root.lookup(target);
        }
        return this.root;
    }

    private Model register(Expression path) throws Exception {
        Model model = this.root.lookup(path);
        if (model != null) {
            return model;
        }
        return this.create(path);
    }

    private Model create(Expression path) throws Exception {
        Model model = this.root;
        while (model != null) {
            String prefix = path.getPrefix();
            String name = path.getFirst();
            int index = path.getIndex();
            if (name != null) {
                model = model.register(name, prefix, index);
            }
            if (!path.isPath()) break;
            path = path.getPath(1);
        }
        return model;
    }

    public void commit(Class type) throws Exception {
        if (this.factory == null) {
            this.factory = this.resolver.build();
        }
    }

    public void validate(Class type) throws Exception {
        Order order = this.scanner.getOrder();
        this.validateUnions(type);
        this.validateElements(type, order);
        this.validateAttributes(type, order);
        this.validateModel(type);
        this.validateText(type);
    }

    private void validateModel(Class type) throws Exception {
        if (!this.root.isEmpty()) {
            this.root.validate(type);
        }
    }

    private void validateText(Class type) throws Exception {
        if (this.root.getText() != null) {
            if (!this.elements.isEmpty()) {
                throw new TextException("Elements used with %s in %s", this.text, type);
            }
            if (this.root.isComposite()) {
                throw new TextException("Paths used with %s in %s", this.text, type);
            }
        } else if (this.scanner.isEmpty()) {
            this.primitive = this.isEmpty();
        }
    }

    private void validateUnions(Class type) throws Exception {
        for (Label label : this.elements) {
            Collection<String> options = label.getPaths();
            Contact contact = label.getContact();
            for (String option : options) {
                Annotation union = contact.getAnnotation();
                Label other = (Label)this.elements.get(option);
                if (label.isInline() != other.isInline()) {
                    throw new UnionException("Inline must be consistent in %s for %s", union, contact);
                }
                if (label.isRequired() == other.isRequired()) continue;
                throw new UnionException("Required must be consistent in %s for %s", union, contact);
            }
        }
    }

    private void validateElements(Class type, Order order) throws Exception {
        if (order != null) {
            for (String name : order.elements()) {
                if (this.isElement(name)) continue;
                throw new ElementException("Ordered element '%s' missing for %s", name, type);
            }
        }
    }

    private void validateAttributes(Class type, Order order) throws Exception {
        if (order != null) {
            for (String name : order.attributes()) {
                if (this.isAttribute(name)) continue;
                throw new AttributeException("Ordered attribute '%s' missing in %s", name, type);
            }
        }
    }

    private boolean isEmpty() {
        if (this.text != null) {
            return false;
        }
        return this.root.isEmpty();
    }
}

