/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.UUID;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.PositionTypeEnum;
import net.sf.jasperreports.engine.type.StretchTypeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRBaseElement
implements JRElement,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_POSITION_TYPE = "positionType";
    public static final String PROPERTY_PRINT_IN_FIRST_WHOLE_BAND = "isPrintInFirstWholeBand";
    public static final String PROPERTY_PRINT_REPEATED_VALUES = "isPrintRepeatedValues";
    public static final String PROPERTY_PRINT_WHEN_DETAIL_OVERFLOWS = "isPrintWhenDetailOverflows";
    public static final String PROPERTY_REMOVE_LINE_WHEN_BLANK = "isRemoveLineWhenBlank";
    public static final String PROPERTY_STRETCH_TYPE = "stretchType";
    public static final String PROPERTY_WIDTH = "width";
    public static final String PROPERTY_X = "x";
    protected UUID uuid;
    protected String key;
    protected PositionTypeEnum positionTypeValue;
    protected StretchTypeEnum stretchTypeValue = StretchTypeEnum.NO_STRETCH;
    protected boolean isPrintRepeatedValues = true;
    protected ModeEnum modeValue;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected boolean isRemoveLineWhenBlank;
    protected boolean isPrintInFirstWholeBand;
    protected boolean isPrintWhenDetailOverflows;
    protected Color forecolor;
    protected Color backcolor;
    protected JRExpression printWhenExpression;
    protected JRGroup printWhenGroupChanges;
    protected JRElementGroup elementGroup;
    protected JRDefaultStyleProvider defaultStyleProvider;
    protected JRStyle parentStyle;
    protected String parentStyleNameReference;
    private JRPropertiesMap propertiesMap;
    private JRPropertyExpression[] propertyExpressions;
    private transient JRPropertyChangeSupport eventSupport;
    private int PSEUDO_SERIAL_VERSION_UID = 60002;
    private Byte mode;
    private byte positionType;
    private byte stretchType;

    protected JRBaseElement(JRDefaultStyleProvider defaultStyleProvider) {
        this.defaultStyleProvider = defaultStyleProvider;
    }

    protected JRBaseElement(JRElement element, JRBaseObjectFactory factory) {
        factory.put(element, this);
        this.defaultStyleProvider = factory.getDefaultStyleProvider();
        this.parentStyle = factory.getStyle(element.getStyle());
        this.parentStyleNameReference = element.getStyleNameReference();
        this.uuid = element.getUUID();
        this.key = element.getKey();
        this.positionTypeValue = element.getPositionTypeValue();
        this.stretchTypeValue = element.getStretchTypeValue();
        this.isPrintRepeatedValues = element.isPrintRepeatedValues();
        this.modeValue = element.getOwnModeValue();
        this.x = element.getX();
        this.y = element.getY();
        this.width = element.getWidth();
        this.height = element.getHeight();
        this.isRemoveLineWhenBlank = element.isRemoveLineWhenBlank();
        this.isPrintInFirstWholeBand = element.isPrintInFirstWholeBand();
        this.isPrintWhenDetailOverflows = element.isPrintWhenDetailOverflows();
        this.forecolor = element.getOwnForecolor();
        this.backcolor = element.getOwnBackcolor();
        this.printWhenExpression = factory.getExpression(element.getPrintWhenExpression());
        this.printWhenGroupChanges = factory.getGroup(element.getPrintWhenGroupChanges());
        this.elementGroup = (JRElementGroup)factory.getVisitResult(element.getElementGroup());
        this.propertiesMap = JRPropertiesMap.getPropertiesClone(element);
        this.copyPropertyExpressions(element, factory);
    }

    private void copyPropertyExpressions(JRElement element, JRBaseObjectFactory factory) {
        JRPropertyExpression[] props = element.getPropertyExpressions();
        if (props != null && props.length > 0) {
            this.propertyExpressions = new JRPropertyExpression[props.length];
            for (int i = 0; i < props.length; ++i) {
                this.propertyExpressions[i] = factory.getPropertyExpression(props[i]);
            }
        }
    }

    @Override
    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    protected JRStyle getBaseStyle() {
        if (this.parentStyle != null) {
            return this.parentStyle;
        }
        if (this.defaultStyleProvider != null) {
            return this.defaultStyleProvider.getDefaultStyle();
        }
        return null;
    }

    @Override
    public UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        return this.uuid;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public PositionTypeEnum getPositionTypeValue() {
        return this.positionTypeValue;
    }

    @Override
    public void setPositionType(PositionTypeEnum positionTypeValue) {
        PositionTypeEnum old = this.positionTypeValue;
        this.positionTypeValue = positionTypeValue;
        this.getEventSupport().firePropertyChange(PROPERTY_POSITION_TYPE, old, this.positionTypeValue);
    }

    @Override
    public StretchTypeEnum getStretchTypeValue() {
        return this.stretchTypeValue;
    }

    @Override
    public void setStretchType(StretchTypeEnum stretchTypeValue) {
        StretchTypeEnum old = this.stretchTypeValue;
        this.stretchTypeValue = stretchTypeValue;
        this.getEventSupport().firePropertyChange(PROPERTY_STRETCH_TYPE, old, this.stretchTypeValue);
    }

    @Override
    public boolean isPrintRepeatedValues() {
        return this.isPrintRepeatedValues;
    }

    @Override
    public void setPrintRepeatedValues(boolean isPrintRepeatedValues) {
        boolean old = this.isPrintRepeatedValues;
        this.isPrintRepeatedValues = isPrintRepeatedValues;
        this.getEventSupport().firePropertyChange(PROPERTY_PRINT_REPEATED_VALUES, old, this.isPrintRepeatedValues);
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.OPAQUE);
    }

    @Override
    public ModeEnum getOwnModeValue() {
        return this.modeValue;
    }

    @Override
    public void setMode(ModeEnum modeValue) {
        ModeEnum old = this.modeValue;
        this.modeValue = modeValue;
        this.getEventSupport().firePropertyChange("mode", old, this.modeValue);
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setX(int x) {
        int old = this.x;
        this.x = x;
        this.getEventSupport().firePropertyChange(PROPERTY_X, old, this.x);
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        int old = this.width;
        this.width = width;
        this.getEventSupport().firePropertyChange(PROPERTY_WIDTH, old, this.width);
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isRemoveLineWhenBlank() {
        return this.isRemoveLineWhenBlank;
    }

    @Override
    public void setRemoveLineWhenBlank(boolean isRemoveLine) {
        boolean old = this.isRemoveLineWhenBlank;
        this.isRemoveLineWhenBlank = isRemoveLine;
        this.getEventSupport().firePropertyChange(PROPERTY_REMOVE_LINE_WHEN_BLANK, old, this.isRemoveLineWhenBlank);
    }

    @Override
    public boolean isPrintInFirstWholeBand() {
        return this.isPrintInFirstWholeBand;
    }

    @Override
    public void setPrintInFirstWholeBand(boolean isPrint) {
        boolean old = this.isPrintInFirstWholeBand;
        this.isPrintInFirstWholeBand = isPrint;
        this.getEventSupport().firePropertyChange(PROPERTY_PRINT_IN_FIRST_WHOLE_BAND, old, this.isPrintInFirstWholeBand);
    }

    @Override
    public boolean isPrintWhenDetailOverflows() {
        return this.isPrintWhenDetailOverflows;
    }

    @Override
    public void setPrintWhenDetailOverflows(boolean isPrint) {
        boolean old = this.isPrintWhenDetailOverflows;
        this.isPrintWhenDetailOverflows = isPrint;
        this.getEventSupport().firePropertyChange(PROPERTY_PRINT_WHEN_DETAIL_OVERFLOWS, old, this.isPrintWhenDetailOverflows);
    }

    @Override
    public Color getForecolor() {
        return JRStyleResolver.getForecolor(this);
    }

    @Override
    public Color getOwnForecolor() {
        return this.forecolor;
    }

    @Override
    public void setForecolor(Color forecolor) {
        Color old = this.forecolor;
        this.forecolor = forecolor;
        this.getEventSupport().firePropertyChange("forecolor", old, this.forecolor);
    }

    @Override
    public Color getBackcolor() {
        return JRStyleResolver.getBackcolor(this);
    }

    @Override
    public Color getOwnBackcolor() {
        return this.backcolor;
    }

    @Override
    public void setBackcolor(Color backcolor) {
        Color old = this.backcolor;
        this.backcolor = backcolor;
        this.getEventSupport().firePropertyChange("backcolor", old, this.backcolor);
    }

    @Override
    public JRExpression getPrintWhenExpression() {
        return this.printWhenExpression;
    }

    @Override
    public JRGroup getPrintWhenGroupChanges() {
        return this.printWhenGroupChanges;
    }

    @Override
    public JRElementGroup getElementGroup() {
        return this.elementGroup;
    }

    @Override
    public JRStyle getStyle() {
        return this.parentStyle;
    }

    @Override
    public String getStyleNameReference() {
        return this.parentStyleNameReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseElement jRBaseElement = this;
        synchronized (jRBaseElement) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    @Override
    public Object clone() {
        JRBaseElement clone = null;
        try {
            clone = (JRBaseElement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.printWhenExpression = JRCloneUtils.nullSafeClone(this.printWhenExpression);
        clone.propertiesMap = JRPropertiesMap.getPropertiesClone(this);
        clone.propertyExpressions = (JRPropertyExpression[])JRCloneUtils.cloneArray((JRCloneable[])this.propertyExpressions);
        clone.eventSupport = null;
        return clone;
    }

    @Override
    public Object clone(JRElementGroup parentGroup) {
        JRBaseElement clone = (JRBaseElement)this.clone();
        clone.elementGroup = parentGroup;
        return clone;
    }

    @Override
    public JRElement clone(JRElementGroup parentGroup, int y) {
        JRBaseElement clone = (JRBaseElement)this.clone(parentGroup);
        clone.y = y;
        return clone;
    }

    @Override
    public boolean hasProperties() {
        return this.propertiesMap != null && !this.propertiesMap.isEmpty();
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        if (this.propertiesMap == null) {
            this.propertiesMap = new JRPropertiesMap();
        }
        return this.propertiesMap;
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    @Override
    public JRPropertyExpression[] getPropertyExpressions() {
        return this.propertyExpressions;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.modeValue = ModeEnum.getByValue(this.mode);
            this.positionTypeValue = PositionTypeEnum.getByValue(this.positionType);
            this.stretchTypeValue = StretchTypeEnum.getByValue(this.stretchType);
            this.mode = null;
        }
    }
}

