/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.widgets;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.constants.Severity;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.filemanager.Messages;
import org.netxms.ui.eclipse.jobs.ConsoleJob;

public class BaseFileViewer
extends Composite {
    public static final int INFORMATION = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final long MAX_FILE_SIZE = 0x7D0000L;
    protected IViewPart viewPart;
    protected StyledText text;
    protected Composite messageBar;
    protected CLabel messageBarLabel;
    protected Label messageCloseButton;
    protected Composite searchBar;
    protected Text searchBarText;
    protected Label searchCloseButton;
    protected boolean scrollLock = false;
    protected StringBuilder content = new StringBuilder();
    protected LineStyler lineStyler = null;

    public BaseFileViewer(Composite parent, int style, IViewPart viewPart) {
        super(parent, style);
        this.viewPart = viewPart;
        this.setLayout((Layout)new FormLayout());
        this.messageBar = new Composite((Composite)this, 0);
        this.messageBar.setBackground(SharedColors.getColor((String)"MessageBar.Background", (Display)this.getDisplay()));
        this.messageBar.setForeground(SharedColors.getColor((String)"MessageBar.Text", (Display)this.getDisplay()));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 2;
        this.messageBar.setLayout((Layout)layout);
        this.messageBar.setVisible(false);
        this.messageBarLabel = new CLabel(this.messageBar, 0);
        this.messageBarLabel.setBackground(this.messageBar.getBackground());
        this.messageBarLabel.setForeground(this.messageBar.getForeground());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.messageBarLabel.setLayoutData((Object)gd);
        this.messageCloseButton = new Label(this.messageBar, 0);
        this.messageCloseButton.setBackground(this.messageBar.getBackground());
        this.messageCloseButton.setCursor(this.getDisplay().getSystemCursor(21));
        this.messageCloseButton.setImage(SharedIcons.IMG_CLOSE);
        Messages.get();
        this.messageCloseButton.setToolTipText(Messages.BaseFileViewer_HideMessage);
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        this.messageCloseButton.setLayoutData((Object)gd);
        this.messageCloseButton.addMouseListener(new MouseListener(){
            private boolean doAction = false;

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button == 1) {
                    this.doAction = false;
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    this.doAction = true;
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1 && this.doAction) {
                    BaseFileViewer.this.hideMessage();
                }
            }
        });
        Label separator = new Label(this.messageBar, 258);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        separator.setLayoutData((Object)gd);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.messageBar.setLayoutData((Object)fd);
        this.text = new StyledText((Composite)this, 768);
        this.text.setEditable(false);
        this.text.setFont(JFaceResources.getTextFont());
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.text.setLayoutData((Object)fd);
        this.text.addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                try {
                    event.styles = BaseFileViewer.this.styleLine(event.lineText);
                    if (event.styles != null) {
                        StyleRange[] styleRangeArray = event.styles;
                        int n = event.styles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            StyleRange r = styleRangeArray[n2];
                            r.start += event.lineOffset;
                            ++n2;
                        }
                    }
                }
                catch (Exception exception) {}
            }
        });
        this.searchBar = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 3;
        layout.marginBottom = 3;
        layout.numColumns = 3;
        this.searchBar.setLayout((Layout)layout);
        this.searchBar.setVisible(false);
        separator = new Label(this.searchBar, 258);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 3;
        separator.setLayoutData((Object)gd);
        Label searchBarLabel = new Label(this.searchBar, 16384);
        Messages.get();
        searchBarLabel.setText(Messages.BaseFileViewer_Find);
        searchBarLabel.setBackground(this.searchBar.getBackground());
        searchBarLabel.setForeground(this.searchBar.getForeground());
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.verticalAlignment = 0x1000000;
        gd.horizontalIndent = 5;
        searchBarLabel.setLayoutData((Object)gd);
        Composite searchBarTextContainer = new Composite(this.searchBar, 2048);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        layout.horizontalSpacing = 0;
        searchBarTextContainer.setLayout((Layout)layout);
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        gd.horizontalAlignment = 16384;
        gd.widthHint = 400;
        searchBarTextContainer.setLayoutData((Object)gd);
        this.searchBarText = new Text(searchBarTextContainer, 0);
        Messages.get();
        this.searchBarText.setMessage(Messages.BaseFileViewer_FindInFile);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 0x1000000;
        gd.grabExcessHorizontalSpace = true;
        this.searchBarText.setLayoutData((Object)gd);
        this.searchBarText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseFileViewer.this.doSearch(true);
            }
        });
        this.searchBarText.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                BaseFileViewer.this.doSearch(false);
            }
        });
        searchBarTextContainer.setBackground(this.searchBarText.getBackground());
        ToolBar searchButtons = new ToolBar(searchBarTextContainer, 0x800000);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 16384;
        searchButtons.setLayoutData((Object)gd);
        ToolItem item = new ToolItem(searchButtons, 8);
        item.setImage(SharedIcons.IMG_UP);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseFileViewer.this.doReverseSearch();
            }
        });
        item = new ToolItem(searchButtons, 8);
        item.setImage(SharedIcons.IMG_DOWN);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseFileViewer.this.doSearch(false);
            }
        });
        this.searchCloseButton = new Label(this.searchBar, 0);
        this.searchCloseButton.setBackground(this.searchBar.getBackground());
        this.searchCloseButton.setCursor(this.getDisplay().getSystemCursor(21));
        this.searchCloseButton.setImage(SharedIcons.IMG_CLOSE);
        Messages.get();
        this.searchCloseButton.setToolTipText(Messages.BaseFileViewer_Close);
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        gd.horizontalAlignment = 131072;
        gd.widthHint = 20;
        this.searchCloseButton.setLayoutData((Object)gd);
        this.searchCloseButton.addMouseListener(new MouseListener(){
            private boolean doAction = false;

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button == 1) {
                    this.doAction = false;
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    this.doAction = true;
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1 && this.doAction) {
                    BaseFileViewer.this.hideSearchBar();
                }
            }
        });
        fd = new FormData();
        fd.bottom = new FormAttachment(100, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.searchBar.setLayoutData((Object)fd);
    }

    public void showFile(final File file) {
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.BaseFileViewer_LoadJobName, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.filemanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final String content = BaseFileViewer.loadFile(file);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        BaseFileViewer.this.setContent(content);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.BaseFileViewer_LoadJobError, file.getAbsolutePath());
            }
        };
        job.setUser(false);
        job.start();
    }

    public void showMessage(int severity, String messageText) {
        switch (severity) {
            case 1: {
                this.messageBarLabel.setImage(StatusDisplayInfo.getStatusImage((Severity)Severity.WARNING));
                break;
            }
            case 2: {
                this.messageBarLabel.setImage(StatusDisplayInfo.getStatusImage((Severity)Severity.CRITICAL));
                break;
            }
            default: {
                this.messageBarLabel.setImage(SharedIcons.IMG_INFORMATION);
            }
        }
        this.messageBarLabel.setText(messageText);
        this.messageBar.setVisible(true);
        ((FormData)this.text.getLayoutData()).top = new FormAttachment((Control)this.messageBar, 0, 1024);
        this.layout(true, true);
    }

    public void hideMessage() {
        this.messageBar.setVisible(false);
        ((FormData)this.text.getLayoutData()).top = new FormAttachment(0, 0);
        this.layout(true, true);
    }

    public void showSearchBar() {
        this.searchBarText.setText("");
        this.searchBar.setVisible(true);
        ((FormData)this.text.getLayoutData()).bottom = new FormAttachment((Control)this.searchBar, 0, 128);
        this.layout(true, true);
        this.searchBarText.setFocus();
    }

    public void hideSearchBar() {
        this.searchBar.setVisible(false);
        ((FormData)this.text.getLayoutData()).bottom = new FormAttachment(100, 0);
        this.layout(true, true);
    }

    public void clear() {
        this.content = new StringBuilder();
        this.text.setText("");
    }

    public void selectAll() {
        this.text.selectAll();
    }

    public void copy() {
        this.text.copy();
    }

    public boolean canCopy() {
        return this.text.getSelectionCount() > 0;
    }

    public boolean isScrollLock() {
        return this.scrollLock;
    }

    public void setScrollLock(boolean scrollLock) {
        this.scrollLock = scrollLock;
    }

    public Control getTextControl() {
        return this.text;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.text.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.text.removeSelectionListener(listener);
    }

    protected void setContent(String s) {
        String ps = BaseFileViewer.removeEscapeSequences(s);
        this.text.setText(ps);
        this.content = new StringBuilder();
        this.content.append(ps.toLowerCase());
    }

    protected void append(String s) {
        String ps = BaseFileViewer.removeEscapeSequences(s);
        this.content.append(ps.toLowerCase());
        this.text.append(ps);
        if (!this.scrollLock) {
            this.text.setTopIndex(this.text.getLineCount() - 1);
        }
    }

    protected StyleRange[] styleLine(String line) {
        return this.lineStyler != null ? this.lineStyler.styleLine(line) : null;
    }

    public LineStyler getLineStyler() {
        return this.lineStyler;
    }

    public void setLineStyler(LineStyler lineStyler) {
        this.lineStyler = lineStyler;
    }

    private void doSearch(boolean typing) {
        String searchString = this.searchBarText.getText().toLowerCase();
        if (searchString.length() == 0) {
            return;
        }
        int searchPosition = this.text.getCaretOffset();
        if (typing && this.text.getSelectionCount() > 0) {
            Point p = this.text.getSelectionRange();
            searchPosition = p.x;
        }
        if (this.content.length() - searchPosition < searchString.length()) {
            return;
        }
        int index = this.content.indexOf(searchString, searchPosition);
        if (index > -1) {
            this.text.setSelection(index, index + searchString.length());
            this.searchBarText.setBackground(null);
        } else {
            this.searchBarText.setBackground(SharedColors.getColor((String)"ErrorBackground", (Display)this.text.getDisplay()));
        }
    }

    private void doReverseSearch() {
        String searchString = this.searchBarText.getText().toLowerCase();
        if (searchString.length() == 0) {
            return;
        }
        int searchPosition = this.text.getCaretOffset();
        if (this.text.getSelectionCount() > 0 && this.text.getSelectionText().toLowerCase().equals(searchString)) {
            Point p = this.text.getSelectionRange();
            searchPosition = p.x - 1;
        }
        if (searchPosition < searchString.length()) {
            return;
        }
        int index = this.content.lastIndexOf(searchString, searchPosition);
        if (index > -1) {
            this.text.setSelection(index, index + searchString.length());
            this.searchBarText.setBackground(null);
        } else {
            this.searchBarText.setBackground(SharedColors.getColor((String)"ErrorBackground", (Display)this.text.getDisplay()));
        }
    }

    protected static String removeEscapeSequences(String s) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == '\u001b') {
                if ((ch = s.charAt(++i)) == '[') {
                    while (i < s.length()) {
                        ch = s.charAt(i);
                        if (!(ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z')) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                } else if (ch == '(' || ch == ')') {
                    ++i;
                }
            } else if (ch >= ' ' || ch == '\r' || ch == '\n' || ch == '\t') {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    protected static String loadFile(File file) {
        StringBuilder content;
        block18: {
            content = new StringBuilder();
            FileReader reader = null;
            char[] buffer = new char[32768];
            try {
                try {
                    reader = new FileReader(file);
                    int size = 0;
                    while ((long)size < 0x7D0000L) {
                        int count = reader.read(buffer);
                        if (count != -1) {
                            if (count == buffer.length) {
                                content.append(buffer);
                            } else {
                                content.append(Arrays.copyOf(buffer, count));
                            }
                            size += count;
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return content.toString();
    }

    public static interface LineStyler {
        public StyleRange[] styleLine(String var1);
    }
}

