/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.api;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.AgentFileData;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.Severity;
import org.netxms.client.objecttools.InputField;
import org.netxms.client.objecttools.InputFieldType;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.filemanager.views.AgentFileViewer;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.api.NodeInfo;
import org.netxms.ui.eclipse.objecttools.api.ObjectToolHandler;
import org.netxms.ui.eclipse.objecttools.api.ObjectToolsCache;
import org.netxms.ui.eclipse.objecttools.dialogs.ObjectToolInputDialog;
import org.netxms.ui.eclipse.objecttools.views.AgentActionResults;
import org.netxms.ui.eclipse.objecttools.views.BrowserView;
import org.netxms.ui.eclipse.objecttools.views.LocalCommandResults;
import org.netxms.ui.eclipse.objecttools.views.ServerCommandResults;
import org.netxms.ui.eclipse.objecttools.views.TableToolResults;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public final class ObjectToolExecutor {
    private ObjectToolExecutor() {
    }

    public static boolean isToolAllowed(ObjectTool tool, Set<NodeInfo> nodes) {
        if (tool.getType() != 0) {
            return true;
        }
        ObjectToolHandler handler = ObjectToolsCache.findHandler(tool.getData());
        if (handler != null) {
            for (NodeInfo n : nodes) {
                if (handler.canExecuteOnNode(n.object, tool)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isToolApplicable(ObjectTool tool, Set<NodeInfo> nodes) {
        for (NodeInfo n : nodes) {
            if (tool.isApplicableForNode(n.object)) continue;
            return false;
        }
        return true;
    }

    public static void execute(final Set<NodeInfo> nodes, final ObjectTool tool) {
        HashMap<String, String> inputValues;
        InputField[] fields;
        if ((tool.getFlags() & 8) != 0) {
            String message = tool.getConfirmationText();
            if (nodes.size() == 1) {
                NodeInfo node = nodes.iterator().next();
                message = ObjectToolExecutor.substituteMacros(message, node, new HashMap<String, String>(0));
            } else {
                message = ObjectToolExecutor.substituteMacros(message, new NodeInfo(null, null), new HashMap<String, String>(0));
            }
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            Messages.get();
            if (!MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_ConfirmExec, (String)message)) {
                return;
            }
        }
        if ((fields = tool.getInputFields()).length > 0) {
            Arrays.sort(fields, new Comparator<InputField>(){

                @Override
                public int compare(InputField f1, InputField f2) {
                    return f1.getSequence() - f2.getSequence();
                }
            });
            inputValues = ObjectToolExecutor.readInputFields(fields);
            if (inputValues == null) {
                return;
            }
        } else {
            inputValues = new HashMap(0);
        }
        boolean validationNeeded = false;
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getOptions().validatePassword) {
                validationNeeded = true;
                break;
            }
            ++i;
        }
        if (validationNeeded) {
            final NXCSession session = ConsoleSharedData.getSession();
            Messages.get();
            new ConsoleJob(Messages.ObjectToolExecutor_JobName, null, "org.netxms.ui.eclipse.objecttools", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    int i = 0;
                    while (i < fields.length) {
                        boolean valid;
                        if (fields[i].getType() == InputFieldType.PASSWORD && fields[i].getOptions().validatePassword && !(valid = session.validateUserPassword((String)inputValues.get(fields[i].getName())))) {
                            final String fieldName = fields[i].getDisplayName();
                            this.getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Messages.get();
                                    Messages.get();
                                    MessageDialogHelper.openError(null, (String)Messages.ObjectToolExecutor_ErrorTitle, (String)String.format(Messages.ObjectToolExecutor_ErrorText, fieldName));
                                }
                            });
                            return;
                        }
                        ++i;
                    }
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            for (NodeInfo n : nodes) {
                                ObjectToolExecutor.executeOnNode(n, tool, inputValues);
                            }
                        }
                    });
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.ObjectToolExecutor_PasswordValidationFailed;
                }
            }.start();
        } else {
            for (NodeInfo n : nodes) {
                ObjectToolExecutor.executeOnNode(n, tool, inputValues);
            }
        }
    }

    private static Map<String, String> readInputFields(InputField[] fields) {
        ObjectToolInputDialog dlg = new ObjectToolInputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), fields);
        if (dlg.open() != 0) {
            return null;
        }
        return dlg.getValues();
    }

    private static void executeOnNode(NodeInfo node, ObjectTool tool, Map<String, String> inputValues) {
        switch (tool.getType()) {
            case 1: {
                ObjectToolExecutor.executeAgentAction(node, tool, inputValues);
                break;
            }
            case 7: {
                ObjectToolExecutor.executeFileDownload(node, tool, inputValues);
                break;
            }
            case 0: {
                ObjectToolExecutor.executeInternalTool(node, tool);
                break;
            }
            case 5: {
                ObjectToolExecutor.executeLocalCommand(node, tool, inputValues);
                break;
            }
            case 6: {
                ObjectToolExecutor.executeServerCommand(node, tool, inputValues);
                break;
            }
            case 2: 
            case 3: {
                ObjectToolExecutor.executeTableTool(node, tool);
                break;
            }
            case 4: {
                ObjectToolExecutor.openURL(node, tool, inputValues);
            }
        }
    }

    private static void executeTableTool(NodeInfo node, ObjectTool tool) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page = window.getActivePage();
            TableToolResults view = (TableToolResults)page.showView("org.netxms.ui.eclipse.objecttools.views.TableToolResults", String.valueOf(Long.toString(tool.getId())) + "&" + Long.toString(node.object.getObjectId()), 1);
            view.refreshTable();
        }
        catch (PartInitException e) {
            Shell shell = window.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)String.format(Messages.ObjectToolsDynamicMenu_ErrorOpeningView, e.getLocalizedMessage()));
        }
    }

    private static String[] splitCommandLine(String input) {
        char[] in = input.toCharArray();
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int state = 0;
        char[] cArray = in;
        int n = in.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (state) {
                case 0: {
                    if (Character.isSpaceChar(c)) {
                        args.add(sb.toString());
                        sb = new StringBuilder();
                        state = 3;
                        break;
                    }
                    if (c == '\"') {
                        state = 1;
                        break;
                    }
                    if (c == '\'') {
                        state = 2;
                        break;
                    }
                    sb.append(c);
                    break;
                }
                case 1: {
                    if (c == '\"') {
                        state = 0;
                        break;
                    }
                    sb.append(c);
                    break;
                }
                case 2: {
                    if (c == '\'') {
                        state = 0;
                        break;
                    }
                    sb.append(c);
                    break;
                }
                case 3: {
                    if (Character.isSpaceChar(c)) break;
                    if (c == '\"') {
                        state = 1;
                        break;
                    }
                    if (c == '\'') {
                        state = 2;
                        break;
                    }
                    sb.append(c);
                    state = 0;
                }
            }
            ++n2;
        }
        if (state != 3) {
            args.add(sb.toString());
        }
        return args.toArray(new String[args.size()]);
    }

    private static void executeAgentAction(final NodeInfo node, ObjectTool tool, Map<String, String> inputValues) {
        final NXCSession session = ConsoleSharedData.getSession();
        String[] parts = ObjectToolExecutor.splitCommandLine(ObjectToolExecutor.substituteMacros(tool.getData(), node, inputValues));
        final String action = parts[0];
        final String[] args = Arrays.copyOfRange(parts, 1, parts.length);
        if ((tool.getFlags() & 0x10) == 0) {
            Messages.get();
            new ConsoleJob(String.format(Messages.ObjectToolsDynamicMenu_ExecuteOnNode, node.object.getObjectName()), null, "org.netxms.ui.eclipse.objecttools", null){

                protected String getErrorMessage() {
                    Messages.get();
                    return String.format(Messages.ObjectToolsDynamicMenu_CannotExecuteOnNode, node.object.getObjectName());
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    session.executeAction(node.object.getObjectId(), action, args);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Messages.get();
                            Messages.get();
                            MessageDialogHelper.openInformation(null, (String)Messages.ObjectToolsDynamicMenu_ToolExecution, (String)String.format(Messages.ObjectToolsDynamicMenu_ExecSuccess, action, node.object.getObjectName()));
                        }
                    });
                }
            }.start();
        } else {
            String secondaryId = String.valueOf(Long.toString(node.object.getObjectId())) + "&" + Long.toString(tool.getId());
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            try {
                AgentActionResults view = (AgentActionResults)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.AgentActionResults", secondaryId, 1);
                view.executeAction(action, args);
            }
            catch (Exception e) {
                Shell shell = window.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)String.format(Messages.ObjectToolsDynamicMenu_ErrorOpeningView, e.getLocalizedMessage()));
            }
        }
    }

    private static void executeServerCommand(final NodeInfo node, final ObjectTool tool, final Map<String, String> inputValues) {
        final NXCSession session = ConsoleSharedData.getSession();
        if ((tool.getFlags() & 0x10) == 0) {
            Messages.get();
            new ConsoleJob(Messages.ObjectToolsDynamicMenu_ExecuteServerCmd, null, "org.netxms.ui.eclipse.objecttools", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    session.executeServerCommand(node.object.getObjectId(), tool.getData(), inputValues);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Messages.get();
                            Messages.get();
                            MessageDialogHelper.openInformation(null, (String)Messages.ObjectToolsDynamicMenu_Information, (String)Messages.ObjectToolsDynamicMenu_ServerCommandExecuted);
                        }
                    });
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.ObjectToolsDynamicMenu_ServerCmdExecError;
                }
            }.start();
        } else {
            String secondaryId = String.valueOf(Long.toString(node.object.getObjectId())) + "&" + Long.toString(tool.getId());
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            try {
                ServerCommandResults view = (ServerCommandResults)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.ServerCommandResults", secondaryId, 1);
                view.executeCommand(tool.getData(), inputValues);
            }
            catch (Exception e) {
                Shell shell = window.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)String.format(Messages.ObjectToolsDynamicMenu_ErrorOpeningView, e.getLocalizedMessage()));
            }
        }
    }

    private static void executeLocalCommand(NodeInfo node, ObjectTool tool, Map<String, String> inputValues) {
        block7: {
            String command = ObjectToolExecutor.substituteMacros(tool.getData(), node, inputValues);
            if ((tool.getFlags() & 0x10) == 0) {
                String os = Platform.getOS();
                try {
                    if (os.equals("win32")) {
                        command = "CMD.EXE /C START \"NetXMS\" " + command;
                        Runtime.getRuntime().exec(command);
                        break block7;
                    }
                    Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                String secondaryId = String.valueOf(Long.toString(node.object.getObjectId())) + "&" + Long.toString(tool.getId());
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                try {
                    LocalCommandResults view = (LocalCommandResults)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.LocalCommandResults", secondaryId, 1);
                    view.runCommand(command);
                }
                catch (Exception e) {
                    Shell shell = window.getShell();
                    Messages.get();
                    Messages.get();
                    MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)String.format(Messages.ObjectToolsDynamicMenu_ErrorOpeningView, e.getLocalizedMessage()));
                }
            }
        }
    }

    private static void executeFileDownload(final NodeInfo node, ObjectTool tool, Map<String, String> inputValues) {
        final NXCSession session = ConsoleSharedData.getSession();
        String[] parameters = tool.getData().split("\u007f");
        final String fileName = ObjectToolExecutor.substituteMacros(parameters[0], node, inputValues);
        final int maxFileSize = Integer.parseInt(parameters[1]);
        final boolean follow = parameters[2].equals("true");
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.ObjectToolsDynamicMenu_DownloadFromAgent, null, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ObjectToolsDynamicMenu_DownloadError, fileName, node.object.getObjectName());
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final AgentFileData file = session.downloadFileFromAgent(node.object.getObjectId(), fileName, (long)maxFileSize, follow);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String secondaryId = String.valueOf(Long.toString(node.object.getObjectId())) + "&" + URLEncoder.encode(fileName, "UTF-8");
                            AgentFileViewer.createView((String)secondaryId, (long)node.object.getObjectId(), (AgentFileData)file, (boolean)follow);
                        }
                        catch (Exception e) {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            Shell shell = window.getShell();
                            Messages.get();
                            Messages.get();
                            MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)String.format(Messages.ObjectToolsDynamicMenu_ErrorOpeningView, e.getLocalizedMessage()));
                        }
                    }
                });
            }
        };
        job.start();
    }

    private static void executeInternalTool(NodeInfo node, ObjectTool tool) {
        ObjectToolHandler handler = ObjectToolsCache.findHandler(tool.getData());
        if (handler != null) {
            handler.execute(node.object, tool);
        } else {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)Messages.ObjectToolsDynamicMenu_HandlerNotDefined);
        }
    }

    private static void openURL(NodeInfo node, ObjectTool tool, Map<String, String> inputValues) {
        String url = ObjectToolExecutor.substituteMacros(tool.getData(), node, inputValues);
        String sid = String.valueOf(Long.toString(node.object.getObjectId())) + "&" + Long.toString(tool.getId());
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            BrowserView view = (BrowserView)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.BrowserView", sid, 1);
            view.openUrl(url);
        }
        catch (PartInitException e) {
            Shell shell = window.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)(String.valueOf(Messages.ObjectToolsDynamicMenu_CannotOpenWebBrowser) + e.getLocalizedMessage()));
        }
    }

    private static String substituteMacros(String s, NodeInfo node, Map<String, String> inputValues) {
        StringBuilder sb = new StringBuilder();
        char[] src = s.toCharArray();
        int i = 0;
        while (i < s.length()) {
            block44: {
                block43: {
                    if (src[i] != '%') break block43;
                    if (++i == s.length()) break;
                    switch (src[i]) {
                        case 'a': {
                            String string;
                            if (node.object != null) {
                                string = node.object.getPrimaryIP().getHostAddress();
                            } else {
                                Messages.get();
                                string = Messages.ObjectToolsDynamicMenu_MultipleNodes;
                            }
                            sb.append(string);
                            break;
                        }
                        case 'A': {
                            if (node.alarm != null) {
                                sb.append(node.alarm.getMessage());
                                break;
                            }
                            break block44;
                        }
                        case 'c': {
                            if (node.alarm != null) {
                                sb.append(node.alarm.getSourceEventCode());
                                break;
                            }
                            break block44;
                        }
                        case 'g': {
                            String string;
                            if (node.object != null) {
                                string = node.object.getGuid().toString();
                            } else {
                                Messages.get();
                                string = Messages.ObjectToolsDynamicMenu_MultipleNodes;
                            }
                            sb.append(string);
                            break;
                        }
                        case 'i': {
                            String string;
                            if (node.object != null) {
                                string = String.format("0x%08X", node.object.getObjectId());
                            } else {
                                Messages.get();
                                string = Messages.ObjectToolsDynamicMenu_MultipleNodes;
                            }
                            sb.append(string);
                            break;
                        }
                        case 'I': {
                            String string;
                            if (node.object != null) {
                                string = Long.toString(node.object.getObjectId());
                            } else {
                                Messages.get();
                                string = Messages.ObjectToolsDynamicMenu_MultipleNodes;
                            }
                            sb.append(string);
                            break;
                        }
                        case 'm': {
                            if (node.alarm != null) {
                                sb.append(node.alarm.getMessage());
                                break;
                            }
                            break block44;
                        }
                        case 'n': {
                            String string;
                            if (node.object != null) {
                                string = node.object.getObjectName();
                            } else {
                                Messages.get();
                                string = Messages.ObjectToolsDynamicMenu_MultipleNodes;
                            }
                            sb.append(string);
                            break;
                        }
                        case 'N': {
                            if (node.alarm != null) {
                                sb.append(ConsoleSharedData.getSession().getEventName((long)node.alarm.getSourceEventCode()));
                                break;
                            }
                            break block44;
                        }
                        case 's': {
                            if (node.alarm != null) {
                                sb.append(node.alarm.getCurrentSeverity());
                                break;
                            }
                            break block44;
                        }
                        case 'S': {
                            if (node.alarm != null) {
                                sb.append(StatusDisplayInfo.getStatusText((Severity)node.alarm.getCurrentSeverity()));
                                break;
                            }
                            break block44;
                        }
                        case 'U': {
                            sb.append(ConsoleSharedData.getSession().getUserName());
                            break;
                        }
                        case 'v': {
                            sb.append("2.0.5");
                            break;
                        }
                        case 'y': {
                            if (node.alarm != null) {
                                sb.append(node.alarm.getState());
                                break;
                            }
                            break block44;
                        }
                        case 'Y': {
                            if (node.alarm != null) {
                                sb.append(node.alarm.getId());
                                break;
                            }
                            break block44;
                        }
                        case '%': {
                            sb.append('%');
                            break;
                        }
                        case '{': {
                            String value;
                            StringBuilder attr = new StringBuilder();
                            ++i;
                            while (i < s.length()) {
                                if (src[i] == '}') break;
                                attr.append(src[i]);
                                ++i;
                            }
                            if (node.object != null && attr.length() > 0 && (value = (String)node.object.getCustomAttributes().get(attr.toString())) != null) {
                                sb.append(value);
                                break;
                            }
                            break block44;
                        }
                        case '(': {
                            String value;
                            StringBuilder name = new StringBuilder();
                            ++i;
                            while (i < s.length()) {
                                if (src[i] == ')') break;
                                name.append(src[i]);
                                ++i;
                            }
                            if (name.length() > 0 && (value = inputValues.get(name.toString())) != null) {
                                sb.append(value);
                                break;
                            }
                            break block44;
                        }
                    }
                    break block44;
                }
                sb.append(src[i]);
            }
            ++i;
        }
        return sb.toString();
    }
}

