/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.views;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciDataRow;
import org.netxms.client.objects.Dashboard;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.LineChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardModifyListener;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.IntermediateSelectionProvider;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class DashboardView
extends ViewPart
implements ISaveablePart {
    public static final String ID = "org.netxms.ui.eclipse.dashboard.views.DashboardView";
    private NXCSession session;
    private Dashboard dashboard;
    private boolean readOnly = true;
    private IntermediateSelectionProvider selectionProvider;
    private DashboardControl dbc;
    private Composite parentComposite;
    private DashboardModifyListener dbcModifyListener;
    private Action actionRefresh;
    private Action actionEditMode;
    private Action actionSave;
    private Action actionExportValues;
    private Action actionAddAlarmBrowser;
    private Action actionAddLabel;
    private Action actionAddBarChart;
    private Action actionAddPieChart;
    private Action actionAddTubeChart;
    private Action actionAddLineChart;
    private Action actionAddAvailabilityChart;
    private Action actionAddDashboard;
    private Action actionAddStatusIndicator;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
        this.dashboard = (Dashboard)this.session.findObjectById(Long.parseLong(site.getSecondaryId()));
        if (this.dashboard == null) {
            Messages.get();
            throw new PartInitException(Messages.DashboardView_InitError);
        }
        Messages.get();
        this.setPartName(String.valueOf(Messages.DashboardView_PartNamePrefix) + this.dashboard.getObjectName());
    }

    public void createPartControl(Composite parent) {
        this.selectionProvider = new IntermediateSelectionProvider();
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.DashboardView_GetEffectiveRights, (IWorkbenchPart)this, "org.netxms.ui.eclipse.dashboard", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                DashboardView.this.readOnly = (DashboardView.this.dashboard.getEffectiveRights() & 2) == 0;
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.DashboardView_GetEffectiveRightsError;
            }
        };
        job.start();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
        this.parentComposite = parent;
        this.dbc = new DashboardControl(parent, 0, this.dashboard, (IViewPart)this, this.selectionProvider, false);
        if (!this.readOnly) {
            this.dbcModifyListener = new DashboardModifyListener(){

                @Override
                public void save() {
                    DashboardView.this.actionSave.setEnabled(false);
                    DashboardView.this.firePropertyChange(257);
                }

                @Override
                public void modify() {
                    DashboardView.this.actionSave.setEnabled(true);
                    DashboardView.this.firePropertyChange(257);
                }
            };
            this.dbc.setModifyListener(this.dbcModifyListener);
        }
        this.activateContext();
        this.createActions();
        this.contributeToActionBars();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.dashboard.context.DashboardView");
        }
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                if (DashboardView.this.dbc.isModified()) {
                    Shell shell = DashboardView.this.getSite().getShell();
                    Messages.get();
                    Messages.get();
                    if (!MessageDialogHelper.openConfirm((Shell)shell, (String)Messages.DashboardView_Refresh, (String)Messages.DashboardView_Confirmation)) {
                        return;
                    }
                }
                DashboardView.this.rebuildDashboard(true);
            }
        };
        Messages.get();
        this.actionSave = new Action(Messages.DashboardView_Save, SharedIcons.SAVE){

            public void run() {
                DashboardView.this.dbc.saveDashboard((IViewPart)DashboardView.this);
            }
        };
        this.actionSave.setEnabled(false);
        Messages.get();
        this.actionExportValues = new Action(Messages.DashboardView_ExportLineChartValues, SharedIcons.CSV){

            public void run() {
                DashboardView.this.exportLineChartValues();
            }
        };
        this.actionExportValues.setActionDefinitionId("org.netxms.ui.eclipse.dashboard.commands.export_line_chart_values");
        handlerService.activateHandler(this.actionExportValues.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionExportValues));
        Messages.get();
        this.actionEditMode = new Action(Messages.DashboardView_EditMode, 2){

            public void run() {
                DashboardView.this.dbc.setEditMode(!DashboardView.this.dbc.isEditMode());
                DashboardView.this.actionEditMode.setChecked(DashboardView.this.dbc.isEditMode());
                if (!DashboardView.this.dbc.isEditMode()) {
                    DashboardView.this.rebuildDashboard(false);
                }
            }
        };
        this.actionEditMode.setImageDescriptor(SharedIcons.EDIT);
        this.actionEditMode.setChecked(this.dbc.isEditMode());
        Messages.get();
        this.actionAddAlarmBrowser = new Action(Messages.DashboardView_AddAlarmBrowser){

            public void run() {
                DashboardView.this.dbc.addAlarmBrowser();
            }
        };
        Messages.get();
        this.actionAddLabel = new Action(Messages.DashboardView_AddLabel){

            public void run() {
                DashboardView.this.dbc.addLabel();
            }
        };
        Messages.get();
        this.actionAddBarChart = new Action(Messages.DashboardView_AddBarChart){

            public void run() {
                DashboardView.this.dbc.addBarChart();
            }
        };
        Messages.get();
        this.actionAddPieChart = new Action(Messages.DashboardView_AddPieChart){

            public void run() {
                DashboardView.this.dbc.addPieChart();
            }
        };
        Messages.get();
        this.actionAddTubeChart = new Action(Messages.DashboardView_AddTubeChart){

            public void run() {
                DashboardView.this.dbc.addTubeChart();
            }
        };
        Messages.get();
        this.actionAddLineChart = new Action(Messages.DashboardView_AddLineChart){

            public void run() {
                DashboardView.this.dbc.addLineChart();
            }
        };
        Messages.get();
        this.actionAddAvailabilityChart = new Action(Messages.DashboardView_AddAvailChart){

            public void run() {
                DashboardView.this.dbc.addAvailabilityChart();
            }
        };
        Messages.get();
        this.actionAddDashboard = new Action(Messages.DashboardView_AddDashboard){

            public void run() {
                DashboardView.this.dbc.addEmbeddedDashboard();
            }
        };
        Messages.get();
        this.actionAddStatusIndicator = new Action(Messages.DashboardView_AddStatusIndicator){

            public void run() {
                DashboardView.this.dbc.addStatusIndicator();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        if (!this.readOnly) {
            manager.add((IAction)this.actionEditMode);
            manager.add((IAction)this.actionSave);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionAddAlarmBrowser);
            manager.add((IAction)this.actionAddLabel);
            manager.add((IAction)this.actionAddLineChart);
            manager.add((IAction)this.actionAddBarChart);
            manager.add((IAction)this.actionAddPieChart);
            manager.add((IAction)this.actionAddTubeChart);
            manager.add((IAction)this.actionAddStatusIndicator);
            manager.add((IAction)this.actionAddAvailabilityChart);
            manager.add((IAction)this.actionAddDashboard);
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)this.actionExportValues);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        if (!this.readOnly) {
            manager.add((IAction)this.actionEditMode);
            manager.add((IAction)this.actionSave);
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)this.actionExportValues);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    public void setFocus() {
        this.dbc.setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
        this.dbc.saveDashboard((IViewPart)this);
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.dbc.isModified() && !this.readOnly;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.dbc.isModified() && !this.readOnly;
    }

    private void rebuildDashboard(boolean reload) {
        if (this.dashboard == null) {
            return;
        }
        if (this.dbc != null) {
            this.dbc.dispose();
        }
        if (reload) {
            this.dashboard = (Dashboard)ConsoleSharedData.getSession().findObjectById(this.dashboard.getObjectId(), Dashboard.class);
            if (this.dashboard != null) {
                this.dbc = new DashboardControl(this.parentComposite, 0, this.dashboard, (IViewPart)this, this.selectionProvider, false);
                this.parentComposite.layout(true, true);
                Messages.get();
                this.setPartName(String.valueOf(Messages.DashboardView_PartNamePrefix) + this.dashboard.getObjectName());
                if (!this.readOnly) {
                    this.dbc.setModifyListener(this.dbcModifyListener);
                }
            } else {
                this.dbc = null;
            }
        } else {
            this.dbc = new DashboardControl(this.parentComposite, 0, this.dashboard, this.dbc.getElements(), (IViewPart)this, this.selectionProvider, this.dbc.isModified());
            this.parentComposite.layout(true, true);
            if (!this.readOnly) {
                this.dbc.setModifyListener(this.dbcModifyListener);
            }
        }
        this.actionSave.setEnabled(this.dbc != null ? this.dbc.isModified() : false);
        this.firePropertyChange(257);
    }

    private void exportLineChartValues() {
        FileDialog fd = new FileDialog(this.getSite().getShell(), 8192);
        fd.setFileName(String.valueOf(this.dashboard.getObjectName()) + ".csv");
        final String fileName = fd.open();
        if (fileName == null) {
            return;
        }
        final ArrayList<LineChartElement.DataCacheElement> data = new ArrayList<LineChartElement.DataCacheElement>();
        for (ElementWidget w : this.dbc.getElementWidgets()) {
            if (!(w instanceof LineChartElement)) continue;
            for (LineChartElement.DataCacheElement d : ((LineChartElement)w).getDataCache()) {
                data.add(d);
            }
        }
        final DateFormat dfDate = RegionalSettings.getDateFormat();
        final DateFormat dfTime = RegionalSettings.getTimeFormat();
        final DateFormat dfDateTime = RegionalSettings.getDateTimeFormat();
        Messages.get();
        new ConsoleJob(Messages.DashboardView_ExportLineChartData, (IWorkbenchPart)this, "org.netxms.ui.eclipse.dashboard", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                boolean doInterpolation = DashboardView.this.session.getPublicServerVariableAsBoolean("DashboardDataExportEnableInterpolation");
                ArrayList<Date> combinedTimeSeries = new ArrayList<Date>();
                for (LineChartElement.DataCacheElement d : data) {
                    DciDataRow[] dciDataRowArray = d.data.getValues();
                    int n = dciDataRowArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DciDataRow r = dciDataRowArray[n2];
                        int i = 0;
                        while (i < combinedTimeSeries.size()) {
                            if (((Date)combinedTimeSeries.get(i)).getTime() == r.getTimestamp().getTime()) break;
                            if (((Date)combinedTimeSeries.get(i)).getTime() < r.getTimestamp().getTime()) {
                                combinedTimeSeries.add(i, r.getTimestamp());
                                break;
                            }
                            ++i;
                        }
                        if (i == combinedTimeSeries.size()) {
                            combinedTimeSeries.add(r.getTimestamp());
                        }
                        ++n2;
                    }
                }
                ArrayList<Double[]> combinedData = new ArrayList<Double[]>(data.size());
                for (LineChartElement.DataCacheElement d : data) {
                    Double[] ySeries = new Double[combinedTimeSeries.size()];
                    int combinedIndex = 0;
                    double lastValue = 0.0;
                    long lastTimestamp = 0L;
                    DciDataRow[] values = d.data.getValues();
                    int i = 0;
                    while (i < values.length) {
                        Date currentTimestamp = values[i].getTimestamp();
                        double currentValue = values[i].getValueAsDouble();
                        long currentCombinedTimestamp = ((Date)combinedTimeSeries.get(combinedIndex)).getTime();
                        while (currentCombinedTimestamp > currentTimestamp.getTime()) {
                            ySeries[combinedIndex] = lastTimestamp != 0L && doInterpolation ? Double.valueOf(lastValue + (currentValue - lastValue) * ((double)(lastTimestamp - currentCombinedTimestamp) / (double)(lastTimestamp - currentTimestamp.getTime()))) : null;
                            currentCombinedTimestamp = ((Date)combinedTimeSeries.get(++combinedIndex)).getTime();
                        }
                        ySeries[combinedIndex++] = currentValue;
                        lastTimestamp = currentTimestamp.getTime();
                        lastValue = currentValue;
                        ++i;
                    }
                    combinedData.add(ySeries);
                }
                BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
                try {
                    writer.write("# " + DashboardView.this.dashboard.getObjectName() + " " + dfDateTime.format(new Date()));
                    writer.newLine();
                    writer.write("DATE,TIME");
                    for (LineChartElement.DataCacheElement d : data) {
                        writer.write(44);
                        writer.write(d.name);
                    }
                    writer.newLine();
                    int i = combinedTimeSeries.size() - 1;
                    while (i >= 0) {
                        Date d = (Date)combinedTimeSeries.get(i);
                        writer.write(dfDate.format(d));
                        writer.write(44);
                        writer.write(dfTime.format(d));
                        for (Double[] values : combinedData) {
                            writer.write(44);
                            if (values[i] == null) continue;
                            double v = values[i];
                            if (Math.abs(v) > 0.001) {
                                writer.write(String.format("%.3f", v));
                                continue;
                            }
                            writer.write(Double.toString(v));
                        }
                        writer.newLine();
                        --i;
                    }
                }
                finally {
                    writer.close();
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.DashboardView_8;
            }
        }.start();
    }
}

