/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.GenericObject;

public class Rack
extends GenericObject {
    private int height;
    private boolean topBottomNumbering;

    public Rack(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.height = msg.getFieldAsInt32(441L);
        this.topBottomNumbering = msg.getFieldAsBoolean(539L);
    }

    @Override
    public String getObjectClassName() {
        return "Rack";
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    @Override
    public boolean isAlarmsVisible() {
        return true;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isTopBottomNumbering() {
        return this.topBottomNumbering;
    }

    public List<AbstractNode> getUnits() {
        ArrayList<AbstractNode> units = new ArrayList<AbstractNode>();
        AbstractObject[] abstractObjectArray = this.getChildsAsArray();
        int n = abstractObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractObject o = abstractObjectArray[n2];
            if (o instanceof AbstractNode) {
                units.add((AbstractNode)o);
            }
            ++n2;
        }
        Collections.sort(units, new Comparator<AbstractNode>(){

            @Override
            public int compare(AbstractNode node1, AbstractNode node2) {
                return node1.getRackPosition() - node2.getRackPosition();
            }
        });
        return units;
    }
}

