/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeNode;
import org.eclipse.birt.core.btree.BTreeValue;
import org.eclipse.birt.core.btree.BTreeValues;
import org.eclipse.birt.core.btree.ExternalValueList;
import org.eclipse.birt.core.btree.IndexEntry;
import org.eclipse.birt.core.btree.InlineValueList;
import org.eclipse.birt.core.btree.LeafEntry;
import org.eclipse.birt.core.btree.SingleValueList;
import org.eclipse.birt.core.btree.ValueNode;
import org.eclipse.birt.core.i18n.CoreMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LeafNode<K, V>
extends BTreeNode<K, V> {
    static final int EMPTY_NODE_SIZE = 16;
    private int prevNodeId = -1;
    private int nextNodeId = -1;
    private int nodeSize = 16;
    private ArrayList<LeafEntry<K, V>> entries = new ArrayList();

    public LeafNode(BTree<K, V> btree, int nodeId) {
        super(btree, 2, nodeId);
    }

    public int getPrevNodeId() {
        return this.prevNodeId;
    }

    public void setPrevNodeId(int prevNodeId) {
        this.prevNodeId = prevNodeId;
    }

    public int getNextNodeId() {
        return this.nextNodeId;
    }

    public void setNextNodeId(int nextNodeId) {
        this.nextNodeId = nextNodeId;
    }

    public int getEntryCount() {
        return this.entries.size();
    }

    public int getNodeSize() {
        return this.nodeSize;
    }

    public LeafEntry<K, V> getFirstEntry() {
        if (this.entries.isEmpty()) {
            return null;
        }
        return this.entries.get(0);
    }

    public LeafEntry<K, V> getLastEntry() {
        if (this.entries.isEmpty()) {
            return null;
        }
        return this.entries.get(this.entries.size() - 1);
    }

    private int search(BTreeValue<K> key) throws IOException {
        return Collections.binarySearch(this.entries, key, new Comparator(){

            public int compare(Object entry, Object key) {
                try {
                    return LeafNode.this.btree.compare(((LeafEntry)entry).getKey(), (BTreeValue)key);
                }
                catch (IOException iOException) {
                    return -1;
                }
            }
        });
    }

    public LeafEntry<K, V> find(BTreeValue<K> key) throws IOException {
        int index = this.search(key);
        if (index >= 0) {
            return this.entries.get(index);
        }
        if ((index = -(index + 1)) > 0) {
            return this.entries.get(index - 1);
        }
        return null;
    }

    public LeafEntry<K, V> insert(BTreeValue<K> key, BTreeValue<V>[] vs) throws IOException {
        assert (vs != null);
        assert (vs.length > 0);
        this.dirty = true;
        int index = this.search(key);
        if (index >= 0) {
            LeafEntry<K, V> insertPoint = this.entries.get(index);
            if (!this.btree.hasValue()) {
                return insertPoint;
            }
            if (!this.btree.allowDuplicate()) {
                BTreeValues<V> values = insertPoint.getValues();
                int valueSize1 = values.getValueSize();
                SingleValueList sv = new SingleValueList(this.btree, vs[0]);
                int valueSize2 = sv.getValueSize();
                insertPoint.setValues(sv);
                this.nodeSize = this.nodeSize + valueSize2 - valueSize1;
                return insertPoint;
            }
            BTreeValues<V> values = insertPoint.getValues();
            int valueSize1 = values.getValueSize();
            BTreeValue<V>[] bTreeValueArray = vs;
            int n = vs.length;
            int n2 = 0;
            while (n2 < n) {
                BTreeValue<V> v = bTreeValueArray[n2];
                values.append(v);
                ++n2;
            }
            int valueSize2 = values.getValueSize();
            if (valueSize2 > 2044) {
                values = this.btree.createExternalValueList(values);
                valueSize2 = values.getValueSize();
                insertPoint.setValues(values);
            }
            this.nodeSize = this.nodeSize - valueSize1 + valueSize2;
            this.btree.increaseTotalValues(vs.length);
            return insertPoint;
        }
        index = -(index + 1);
        BTreeValues<V> values = null;
        if (this.btree.hasValue()) {
            if (this.btree.allowDuplicate()) {
                values = new InlineValueList(this.btree);
                BTreeValue<V>[] bTreeValueArray = vs;
                int n = vs.length;
                int n3 = 0;
                while (n3 < n) {
                    BTreeValue<V> v = bTreeValueArray[n3];
                    values.append(v);
                    ++n3;
                }
                if (values.getValueSize() > 2044) {
                    values = this.btree.createExternalValueList(values);
                }
            } else {
                values = new SingleValueList(this.btree, vs[0]);
            }
        }
        LeafEntry entry = new LeafEntry(this, key, values);
        this.insert(index, entry);
        if (this.btree.hasValue()) {
            this.btree.increaseTotalValues(vs.length);
        }
        this.btree.increaseTotalKeys();
        return entry;
    }

    private void insert(int index, LeafEntry<K, V> entry) throws IOException {
        LeafEntry<K, V> prev = null;
        LeafEntry<K, V> next = null;
        if (index > 0) {
            prev = this.entries.get(index - 1);
        }
        if (index < this.entries.size()) {
            next = this.entries.get(index);
        }
        this.entries.add(index, entry);
        entry.setNode(this);
        entry.setPrev(prev);
        entry.setNext(next);
        if (prev != null) {
            prev.setNext(entry);
        }
        if (next != null) {
            next.setPrev(entry);
        }
        this.nodeSize += this.getEntrySize(entry);
    }

    public boolean needSplit() {
        return this.nodeSize > 4088 && this.entries.size() > 13;
    }

    private void resetNodeSize() throws IOException {
        this.nodeSize = 16;
        for (LeafEntry<K, V> entry : this.entries) {
            this.nodeSize += this.getEntrySize(entry);
        }
    }

    public IndexEntry<K, V> split() throws IOException {
        int splitIndex = this.entries.size() / 2;
        LeafNode newNode = this.btree.createLeafNode();
        try {
            LeafEntry splitEntry = this.entries.get(splitIndex);
            LeafEntry prev = splitEntry.getPrev();
            splitEntry.setPrev(null);
            if (prev != null) {
                prev.setNext(null);
            }
            List<LeafEntry<K, V>> splitEntries = this.entries.subList(splitIndex, this.entries.size());
            for (LeafEntry entry : splitEntries) {
                entry.setNode(newNode);
            }
            newNode.entries.addAll(splitEntries);
            super.resetNodeSize();
            newNode.setNextNodeId(this.nextNodeId);
            newNode.setPrevNodeId(this.nodeId);
            if (this.nextNodeId != -1) {
                LeafNode nextNode = this.btree.loadLeafNode(this.nextNodeId);
                try {
                    nextNode.setPrevNodeId(newNode.getNodeId());
                    nextNode.setDirty(true);
                }
                finally {
                    nextNode.unlock();
                }
            }
            this.nextNodeId = newNode.getNodeId();
            ArrayList<LeafEntry<K, V>> remainEntries = new ArrayList<LeafEntry<K, V>>();
            remainEntries.addAll(this.entries.subList(0, splitIndex));
            this.entries = remainEntries;
            this.resetNodeSize();
            IndexEntry indexEntry = new IndexEntry(null, splitEntry.getKey(), newNode.getNodeId());
            return indexEntry;
        }
        finally {
            newNode.unlock();
        }
    }

    @Override
    void read(DataInput in) throws IOException {
        this.nodeSize = in.readInt();
        this.prevNodeId = in.readInt();
        this.nextNodeId = in.readInt();
        int entryCount = in.readInt();
        LeafEntry<K, V> prev = null;
        int i = 0;
        while (i < entryCount) {
            LeafEntry<K, V> entry = this.readEntry(in);
            entry.setPrev(prev);
            if (prev != null) {
                prev.setNext(entry);
            }
            this.entries.add(entry);
            prev = entry;
            ++i;
        }
    }

    @Override
    protected void write(DataOutput out) throws IOException {
        out.writeInt(this.nodeSize);
        out.writeInt(this.prevNodeId);
        out.writeInt(this.nextNodeId);
        out.writeInt(this.entries.size());
        for (LeafEntry<K, V> entry : this.entries) {
            this.writeEntry(out, entry);
        }
    }

    private int getEntrySize(LeafEntry<K, V> entry) {
        int keySize = this.btree.getKeySize(entry.getKey());
        if (this.btree.hasValue()) {
            BTreeValues<V> values = entry.getValues();
            if (this.btree.allowDuplicate()) {
                return keySize + 4 + values.getValueSize();
            }
            return keySize + values.getValueSize();
        }
        return keySize;
    }

    protected LeafEntry<K, V> readEntry(DataInput in) throws IOException {
        BTreeValue key = this.btree.readKey(in);
        BTreeValues<V> values = this.readValues(in);
        return new LeafEntry(this, key, values);
    }

    private BTreeValues<V> readValues(DataInput in) throws IOException {
        if (this.btree.hasValue()) {
            if (this.btree.allowDuplicate()) {
                int type = in.readInt();
                if (type == 0) {
                    InlineValueList inlineValues = new InlineValueList(this.btree);
                    inlineValues.read(in);
                    return inlineValues;
                }
                if (type == 1) {
                    ExternalValueList externalValues = new ExternalValueList(this.btree);
                    externalValues.read(in);
                    return externalValues;
                }
                throw new IOException(CoreMessages.getFormattedString("error.UnknownValueType", type));
            }
            SingleValueList singleValues = new SingleValueList(this.btree);
            singleValues.read(in);
            return singleValues;
        }
        return null;
    }

    private void writeEntry(DataOutput out, LeafEntry<K, V> entry) throws IOException {
        this.btree.writeKey(out, entry.getKey());
        if (this.btree.hasValue()) {
            BTreeValues<V> values = entry.getValues();
            if (this.btree.allowDuplicate()) {
                out.writeInt(values.getType());
            }
            values.write(out);
        }
    }

    @Override
    public void dumpNode() throws IOException {
        System.out.println("LeafNode:" + this.nodeId);
        System.out.println("nodeSize:" + this.nodeSize);
        System.out.println("prevNodeId:" + this.prevNodeId);
        System.out.println("nextNodeId :" + this.nextNodeId);
        System.out.println("entryCount:" + this.entries.size());
        for (LeafEntry<K, V> entry : this.entries) {
            System.out.print(this.btree.getKey(entry.getKey()) + "\"");
            if (this.btree.hasValue()) {
                System.out.print(" valueCount:" + entry.getValues().getValueCount());
                System.out.print(" valueSize:" + entry.getValues().getValueSize());
            }
            System.out.println();
        }
    }

    @Override
    public void dumpAll() throws IOException {
        this.dumpNode();
        for (LeafEntry<K, V> entry : this.entries) {
            BTreeValues<V> values = entry.getValues();
            if (values == null || values.getType() != 1) continue;
            ExternalValueList extValues = (ExternalValueList)values;
            int nodeId = extValues.getFirstNodeId();
            while (nodeId != -1) {
                ValueNode valueNode = this.btree.loadValueNode(nodeId);
                try {
                    valueNode.dumpAll();
                    nodeId = valueNode.getNextNodeId();
                }
                finally {
                    valueNode.unlock();
                }
            }
        }
    }
}

