/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.certificate.manager;

import org.netxms.certificate.loader.KeyStoreLoader;
import org.netxms.certificate.loader.MSCKeyStoreLoader;
import org.netxms.certificate.loader.PKCS12KeyStoreLoader;
import org.netxms.certificate.manager.CertificateManager;

public class CertificateManagerProvider {
    private static volatile CertificateManager manager;

    private CertificateManagerProvider() {
    }

    public static synchronized CertificateManager provideCertificateManager() {
        if (manager != null) {
            return manager;
        }
        manager = new CertificateManagerProvider().createCertificateManager();
        return manager;
    }

    protected CertificateManager createCertificateManager() {
        String os = System.getProperty("os.name");
        KeyStoreLoader loader = os.startsWith("Windows") ? new MSCKeyStoreLoader() : new PKCS12KeyStoreLoader();
        return new CertificateManager(loader);
    }

    public static synchronized void dispose() {
        if (manager == null) {
            return;
        }
        manager.setEntryListener(null);
        manager = null;
    }
}

