/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import java.util.Arrays;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.api.DataCollectionObjectEditor;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.tools.WidgetFactory;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class InstanceDiscovery
extends PropertyPage {
    private static final String[] DCI_FUNCTIONS = new String[]{"FindDCIByName", "FindDCIByDescription", "GetDCIObject", "GetDCIValue", "GetDCIValueByDescription", "GetDCIValueByName"};
    private static final String[] DCI_VARIABLES = new String[]{"$dci", "$node"};
    private DataCollectionObjectEditor editor;
    private DataCollectionItem dci;
    private Combo discoveryMethod;
    private LabeledText discoveryData;
    private ScriptEditor filterScript;

    protected Control createContents(Composite parent) {
        this.editor = (DataCollectionObjectEditor)this.getElement().getAdapter(DataCollectionObjectEditor.class);
        this.dci = this.editor.getObjectAsItem();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Messages.get();
        this.discoveryMethod = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)Messages.InstanceDiscovery_Method, (Object)"WidgetHelper::default_layout_data");
        Messages.get();
        this.discoveryMethod.add(Messages.InstanceDiscovery_None);
        Messages.get();
        this.discoveryMethod.add(Messages.InstanceDiscovery_AgentList);
        Messages.get();
        this.discoveryMethod.add(Messages.InstanceDiscovery_AgentTable);
        Messages.get();
        this.discoveryMethod.add(Messages.InstanceDiscovery_SnmpWalkValues);
        Messages.get();
        this.discoveryMethod.add(Messages.InstanceDiscovery_SnmpWalkOids);
        Messages.get();
        this.discoveryMethod.add(Messages.InstanceDiscovery_Script);
        this.discoveryMethod.select(this.dci.getInstanceDiscoveryMethod());
        this.discoveryMethod.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int method = InstanceDiscovery.this.discoveryMethod.getSelectionIndex();
                InstanceDiscovery.this.discoveryData.setLabel(InstanceDiscovery.getDataLabel(method));
                InstanceDiscovery.this.discoveryData.setEnabled(method != 0);
                InstanceDiscovery.this.filterScript.setEnabled(method != 0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.discoveryData = new LabeledText(dialogArea, 0);
        this.discoveryData.setLabel(InstanceDiscovery.getDataLabel(this.dci.getInstanceDiscoveryMethod()));
        this.discoveryData.setText(this.dci.getInstanceDiscoveryData());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.discoveryData.setLayoutData((Object)gd);
        this.discoveryData.setEnabled(this.dci.getInstanceDiscoveryMethod() != 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 0;
        gd.heightHint = 0;
        WidgetFactory factory = new WidgetFactory(){

            public Control createControl(Composite parent, int style) {
                return new ScriptEditor(parent, style, 768);
            }
        };
        Messages.get();
        this.filterScript = (ScriptEditor)WidgetHelper.createLabeledControl((Composite)dialogArea, (int)2048, (WidgetFactory)factory, (String)Messages.InstanceDiscovery_FilterScript, (Object)gd);
        this.filterScript.addFunctions(Arrays.asList(DCI_FUNCTIONS));
        this.filterScript.addVariables(Arrays.asList(DCI_VARIABLES));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.filterScript.setLayoutData((Object)gd);
        this.filterScript.setText(this.dci.getInstanceDiscoveryFilter());
        this.filterScript.setEnabled(this.dci.getInstanceDiscoveryMethod() != 0);
        return dialogArea;
    }

    private static String getDataLabel(int method) {
        switch (method) {
            case 0: {
                Messages.get();
                return Messages.InstanceDiscovery_DiscoveryData;
            }
            case 1: {
                Messages.get();
                return Messages.InstanceDiscovery_ListName;
            }
            case 2: {
                Messages.get();
                return Messages.InstanceDiscovery_TableName;
            }
            case 3: 
            case 4: {
                Messages.get();
                return Messages.InstanceDiscovery_BaseOid;
            }
        }
        return "";
    }

    protected void applyChanges(boolean isApply) {
        this.dci.setInstanceDiscoveryMethod(this.discoveryMethod.getSelectionIndex());
        this.dci.setInstanceDiscoveryData(this.discoveryData.getText());
        this.dci.setInstanceDiscoveryFilter(this.filterScript.getText());
        this.editor.modify();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.discoveryMethod.select(0);
        this.discoveryData.setLabel(InstanceDiscovery.getDataLabel(0));
        this.discoveryData.setText("");
        this.discoveryData.setEnabled(false);
        this.filterScript.setText("");
        this.filterScript.setEnabled(false);
    }
}

