/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.SourceProvider;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.Command;
import org.netxms.ui.eclipse.tools.CommandBridge;
import org.netxms.ui.eclipse.tools.FontTools;
import org.netxms.ui.eclipse.tools.IntermediateSelectionProvider;

public class TabbedObjectView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.objectview.view.tabbed_object_view";
    private static final String[] HEADER_FONTS = new String[]{"Verdana", "DejaVu Sans", "Liberation Sans", "Arial"};
    private CLabel header;
    private CTabFolder tabFolder;
    private Font headerFont;
    private List<ObjectTab> tabs;
    private ObjectTab activeTab = null;
    private ISelectionService selectionService = null;
    private ISelectionListener selectionListener = null;
    private IntermediateSelectionProvider selectionProvider;
    private SessionListener sessionListener = null;
    private Action actionRefresh;
    private SourceProvider sourceProvider = null;
    private long objectId = 0L;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.sourceProvider = SourceProvider.getInstance();
        this.selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.headerFont = FontTools.createFont((String[])HEADER_FONTS, (int)3, (int)1);
        this.header = new CLabel(parent, 2048);
        this.header.setLayoutData((Object)new GridData(4, 4, true, false));
        this.header.setFont(this.headerFont);
        this.header.setBackground(SharedColors.getColor((String)"ObjectTab.Header.Background", (Display)parent.getDisplay()));
        this.header.setForeground(SharedColors.getColor((String)"ObjectTab.Header", (Display)parent.getDisplay()));
        this.tabFolder = new CTabFolder(parent, 0x800082);
        this.tabFolder.setUnselectedImageVisible(true);
        this.tabFolder.setSimple(true);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TabbedObjectView.this.onTabSelectionChange(e.item != null ? (ObjectTab)((CTabItem)e.item).getData() : null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.tabs = new ArrayList<ObjectTab>();
        this.addTabs();
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part.getSite().getId().equals("org.netxms.ui.eclipse.view.navigation.objectbrowser") && selection instanceof IStructuredSelection) {
                    if (selection.isEmpty()) {
                        TabbedObjectView.this.setObject(null);
                    } else {
                        Object object = ((IStructuredSelection)selection).getFirstElement();
                        if (object instanceof AbstractObject) {
                            TabbedObjectView.this.setObject((AbstractObject)object);
                        }
                    }
                }
            }
        };
        this.selectionService.addPostSelectionListener(this.selectionListener);
        this.createActions();
        this.contributeToActionBars();
        this.selectionProvider = new IntermediateSelectionProvider();
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        final NXCSession session = ConsoleSharedData.getSession();
        this.sessionListener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 4 && TabbedObjectView.this.objectId == n.getSubCode()) {
                    final AbstractObject object = (AbstractObject)n.getObject();
                    TabbedObjectView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TabbedObjectView.this.onObjectUpdate(object);
                        }
                    });
                }
            }
        };
        session.addListener(this.sessionListener);
        CommandBridge.getInstance().registerCommand("TabbedObjectView/selectTab", new Command(){

            public Object execute(String name, Object arg) {
                if (arg instanceof String) {
                    TabbedObjectView.this.selectTab((String)arg);
                }
                return null;
            }
        });
        CommandBridge.getInstance().registerCommand("TabbedObjectView/changeObject", new Command(){

            public Object execute(String name, Object arg) {
                if (arg instanceof Long) {
                    TabbedObjectView.this.setObject(session.findObjectById(((Long)arg).longValue()));
                }
                return null;
            }
        });
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                TabbedObjectView.this.refreshCurrentTab();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void refreshCurrentTab() {
        CTabItem item = this.tabFolder.getSelection();
        if (item != null) {
            ((ObjectTab)item.getData()).refresh();
        }
    }

    private void onObjectUpdate(AbstractObject object) {
        this.header.setText(object.getObjectName());
        for (ObjectTab tab : this.tabs) {
            if (!tab.isVisible()) continue;
            tab.currentObjectUpdated(object);
        }
    }

    public void setObject(final AbstractObject object) {
        if (this.objectId == TabbedObjectView.getObjectId(object)) {
            return;
        }
        this.objectId = TabbedObjectView.getObjectId(object);
        final Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                while (display.readAndDispatch()) {
                }
                if (TabbedObjectView.this.objectId != TabbedObjectView.getObjectId(object)) {
                    return;
                }
                TabbedObjectView.this.setObjectInternal(object);
            }
        });
    }

    private static long getObjectId(AbstractObject object) {
        return object != null ? object.getObjectId() : 0L;
    }

    private void setObjectInternal(AbstractObject object) {
        Control focusControl = Display.getCurrent().getFocusControl();
        if (object != null) {
            this.header.setText(object.getObjectName());
            for (ObjectTab tab : this.tabs) {
                if (tab.showForObject(object) && !WorkbenchActivityHelper.filterItem((Object)tab)) {
                    tab.show();
                    tab.changeObject(object);
                    continue;
                }
                if (tab == this.activeTab) {
                    tab.unselected();
                }
                tab.hide();
                tab.changeObject(null);
            }
            if (this.objectId == 0L || this.tabFolder.getSelection() == null) {
                try {
                    ObjectTab tab;
                    this.tabFolder.setSelection(0);
                    tab = (ObjectTab)this.tabFolder.getItem(0).getData();
                    this.onTabSelectionChange(tab);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            this.objectId = object != null ? object.getObjectId() : 0L;
        } else {
            for (ObjectTab tab : this.tabs) {
                tab.hide();
                tab.changeObject(null);
            }
            this.objectId = 0L;
            this.header.setText("");
        }
        if (focusControl != null) {
            focusControl.setFocus();
        }
    }

    public void setFocus() {
        this.tabFolder.setFocus();
        CTabItem item = this.tabFolder.getSelection();
        if (item != null) {
            ((ObjectTab)item.getData()).selected();
        }
    }

    private void addTabs() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.objectview.tabs");
        int i = 0;
        while (i < elements.length) {
            try {
                ObjectTab tab = (ObjectTab)elements[i].createExecutableExtension("class");
                tab.configure(elements[i], this);
                this.tabs.add(tab);
            }
            catch (CoreException e) {
                Activator.log("Exception when instantiating object tab", (Exception)((Object)e));
            }
            ++i;
        }
        Collections.sort(this.tabs, new Comparator<ObjectTab>(){

            @Override
            public int compare(ObjectTab arg0, ObjectTab arg1) {
                return arg0.getOrder() - arg1.getOrder();
            }
        });
        for (ObjectTab tab : this.tabs) {
            tab.create(this.tabFolder);
        }
    }

    public void selectTab(String tabId) {
        int i = 0;
        while (i < this.tabFolder.getItemCount()) {
            CTabItem item = this.tabFolder.getItem(i);
            ObjectTab tab = (ObjectTab)item.getData();
            if (tab.getLocalId().equals(tabId)) {
                this.tabFolder.setSelection(i);
                this.onTabSelectionChange(tab);
                break;
            }
            ++i;
        }
    }

    private void onTabSelectionChange(ObjectTab tab) {
        if (this.activeTab == tab) {
            return;
        }
        if (this.activeTab != null) {
            this.activeTab.unselected();
        }
        if (tab != null) {
            tab.selected();
            this.selectionProvider.setSelectionProviderDelegate(tab.getSelectionProvider());
        } else {
            this.selectionProvider.setSelectionProviderDelegate(null);
        }
        this.activeTab = tab;
        if (this.sourceProvider != null) {
            this.sourceProvider.updateProperty("org.netxms.ui.eclipse.objectview.ActiveTab", tab);
        }
    }

    public void dispose() {
        ConsoleSharedData.getSession().removeListener(this.sessionListener);
        CommandBridge.getInstance().unregisterCommand("TabbedObjectView/selectTab");
        CommandBridge.getInstance().unregisterCommand("TabbedObjectView/changeObject");
        ConsoleSharedData.getSession().removeListener(this.sessionListener);
        if (this.sourceProvider != null) {
            this.sourceProvider.updateProperty("org.netxms.ui.eclipse.objectview.ActiveTab", null);
        }
        this.getSite().setSelectionProvider(null);
        if (this.selectionService != null && this.selectionListener != null) {
            this.selectionService.removePostSelectionListener(this.selectionListener);
        }
        for (ObjectTab tab : this.tabs) {
            tab.dispose();
        }
        this.headerFont.dispose();
        super.dispose();
    }
}

