/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintBookmark;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.util.CompositeClassloader;
import net.sf.jasperreports.engine.xml.BaseSaxParserFactory;
import net.sf.jasperreports.engine.xml.JRBoxFactory;
import net.sf.jasperreports.engine.xml.JRGenericElementTypeFactory;
import net.sf.jasperreports.engine.xml.JRGenericPrintElementFactory;
import net.sf.jasperreports.engine.xml.JRGenericPrintElementParameterFactory;
import net.sf.jasperreports.engine.xml.JROriginFactory;
import net.sf.jasperreports.engine.xml.JRParagraphFactory;
import net.sf.jasperreports.engine.xml.JRPenFactory;
import net.sf.jasperreports.engine.xml.JRPrintElementFactory;
import net.sf.jasperreports.engine.xml.JRPrintEllipseFactory;
import net.sf.jasperreports.engine.xml.JRPrintFontFactory;
import net.sf.jasperreports.engine.xml.JRPrintFrameFactory;
import net.sf.jasperreports.engine.xml.JRPrintGraphicElementFactory;
import net.sf.jasperreports.engine.xml.JRPrintHyperlinkParameterFactory;
import net.sf.jasperreports.engine.xml.JRPrintHyperlinkParameterValueFactory;
import net.sf.jasperreports.engine.xml.JRPrintImageFactory;
import net.sf.jasperreports.engine.xml.JRPrintImageSourceFactory;
import net.sf.jasperreports.engine.xml.JRPrintLineFactory;
import net.sf.jasperreports.engine.xml.JRPrintPageFactory;
import net.sf.jasperreports.engine.xml.JRPrintRectangleFactory;
import net.sf.jasperreports.engine.xml.JRPrintStyleFactory;
import net.sf.jasperreports.engine.xml.JRPrintTextFactory;
import net.sf.jasperreports.engine.xml.JRPropertyDigesterRule;
import net.sf.jasperreports.engine.xml.JRSaxParserFactory;
import net.sf.jasperreports.engine.xml.JRStyleFactory;
import net.sf.jasperreports.engine.xml.JRXmlDigester;
import net.sf.jasperreports.engine.xml.JasperPrintFactory;
import net.sf.jasperreports.engine.xml.PrintBookmarkFactory;
import net.sf.jasperreports.engine.xml.PrintPartFactory;
import net.sf.jasperreports.engine.xml.TabStopFactory;
import net.sf.jasperreports.engine.xml.TextLineBreakOffsetsRule;
import net.sf.jasperreports.engine.xml.XmlHandlerNamespace;
import net.sf.jasperreports.engine.xml.XmlValueHandler;
import net.sf.jasperreports.engine.xml.XmlValueHandlerUtils;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.SetNestedPropertiesRule;
import org.apache.commons.digester.SetPropertiesRule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JRPrintXmlLoader
implements ErrorHandler {
    private static final Log log = LogFactory.getLog(JRPrintXmlLoader.class);
    private final JasperReportsContext jasperReportsContext;
    private JasperPrint jasperPrint;
    private List<Exception> errors = new ArrayList<Exception>();

    protected JRPrintXmlLoader() {
        this(DefaultJasperReportsContext.getInstance());
    }

    protected JRPrintXmlLoader(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public JasperReportsContext getJasperReportsContext() {
        return this.jasperReportsContext;
    }

    public void setJasperPrint(JasperPrint jasperPrint) {
        this.jasperPrint = jasperPrint;
    }

    public static JasperPrint loadFromFile(JasperReportsContext jasperReportsContext, String sourceFileName) throws JRException {
        JasperPrint jasperPrint = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(sourceFileName);
            JRPrintXmlLoader printXmlLoader = new JRPrintXmlLoader(jasperReportsContext);
            jasperPrint = printXmlLoader.loadXML(fis);
        }
        catch (IOException e) {
            throw new JRException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return jasperPrint;
    }

    public static JasperPrint loadFromFile(String sourceFileName) throws JRException {
        return JRPrintXmlLoader.loadFromFile(DefaultJasperReportsContext.getInstance(), sourceFileName);
    }

    public static JasperPrint load(String sourceFileName) throws JRException {
        return JRPrintXmlLoader.loadFromFile(sourceFileName);
    }

    public static JasperPrint load(JasperReportsContext jasperReportsContext, InputStream is) throws JRException {
        JasperPrint jasperPrint = null;
        JRPrintXmlLoader printXmlLoader = new JRPrintXmlLoader(jasperReportsContext);
        jasperPrint = printXmlLoader.loadXML(is);
        return jasperPrint;
    }

    public static JasperPrint load(InputStream is) throws JRException {
        return JRPrintXmlLoader.load(DefaultJasperReportsContext.getInstance(), is);
    }

    private JasperPrint loadXML(InputStream is) throws JRException {
        try {
            JRXmlDigester digester = this.prepareDigester();
            digester.parse(is);
        }
        catch (ParserConfigurationException e) {
            throw new JRException(e);
        }
        catch (SAXException e) {
            throw new JRException(e);
        }
        catch (IOException e) {
            throw new JRException(e);
        }
        if (this.errors.size() > 0) {
            Exception e = this.errors.get(0);
            if (e instanceof JRException) {
                throw (JRException)e;
            }
            throw new JRException(e);
        }
        return this.jasperPrint;
    }

    protected JRXmlDigester prepareDigester() throws ParserConfigurationException, SAXException {
        JRXmlDigester digester = new JRXmlDigester(this.createParser());
        CompositeClassloader digesterClassLoader = new CompositeClassloader(JRPrintXmlLoader.class.getClassLoader(), Thread.currentThread().getContextClassLoader());
        digester.setClassLoader(digesterClassLoader);
        digester.setNamespaceAware(true);
        digester.setRuleNamespaceURI("http://jasperreports.sourceforge.net/jasperreports/print");
        digester.push(this);
        digester.setErrorHandler(this);
        digester.setValidating(true);
        digester.addFactoryCreate("jasperPrint", JasperPrintFactory.class.getName());
        digester.addSetNext("jasperPrint", "setJasperPrint", JasperPrint.class.getName());
        digester.addRule("*/property", new JRPropertyDigesterRule());
        digester.addFactoryCreate("jasperPrint/origin", JROriginFactory.class.getName());
        digester.addSetNext("jasperPrint/origin", "addOrigin", JROrigin.class.getName());
        digester.addFactoryCreate("jasperPrint/reportFont", JRStyleFactory.class.getName());
        digester.addSetNext("jasperPrint/reportFont", "addStyle", JRStyle.class.getName());
        digester.addFactoryCreate("jasperPrint/style", JRPrintStyleFactory.class.getName());
        digester.addSetNext("jasperPrint/style", "addStyle", JRStyle.class.getName());
        digester.addFactoryCreate("*/style/pen", JRPenFactory.Style.class.getName());
        digester.addFactoryCreate("*/bookmark", PrintBookmarkFactory.class.getName());
        digester.addSetNext("*/bookmark", "addBookmark", PrintBookmark.class.getName());
        digester.addFactoryCreate("jasperPrint/part", PrintPartFactory.class.getName());
        digester.addFactoryCreate("jasperPrint/page", JRPrintPageFactory.class.getName());
        digester.addSetNext("jasperPrint/page", "addPage", JRPrintPage.class.getName());
        digester.addFactoryCreate("*/line", JRPrintLineFactory.class.getName());
        digester.addSetNext("*/line", "addElement", JRPrintElement.class.getName());
        digester.addFactoryCreate("*/reportElement", JRPrintElementFactory.class.getName());
        digester.addFactoryCreate("*/graphicElement", JRPrintGraphicElementFactory.class.getName());
        digester.addFactoryCreate("*/pen", JRPenFactory.class.getName());
        digester.addFactoryCreate("*/rectangle", JRPrintRectangleFactory.class.getName());
        digester.addSetNext("*/rectangle", "addElement", JRPrintElement.class.getName());
        digester.addFactoryCreate("*/ellipse", JRPrintEllipseFactory.class.getName());
        digester.addSetNext("*/ellipse", "addElement", JRPrintElement.class.getName());
        digester.addFactoryCreate("*/image", JRPrintImageFactory.class.getName());
        digester.addSetNext("*/image", "addElement", JRPrintElement.class.getName());
        digester.addFactoryCreate("*/box", JRBoxFactory.class.getName());
        digester.addFactoryCreate("*/box/pen", JRPenFactory.Box.class.getName());
        digester.addFactoryCreate("*/box/topPen", JRPenFactory.Top.class.getName());
        digester.addFactoryCreate("*/box/leftPen", JRPenFactory.Left.class.getName());
        digester.addFactoryCreate("*/box/bottomPen", JRPenFactory.Bottom.class.getName());
        digester.addFactoryCreate("*/box/rightPen", JRPenFactory.Right.class.getName());
        digester.addFactoryCreate("*/paragraph", JRParagraphFactory.class.getName());
        digester.addFactoryCreate("*/paragraph/tabStop", TabStopFactory.class.getName());
        digester.addSetNext("*/paragraph/tabStop", "addTabStop", TabStop.class.getName());
        digester.addFactoryCreate("*/image/imageSource", JRPrintImageSourceFactory.class.getName());
        digester.addCallMethod("*/image/imageSource", "setImageSource", 0);
        digester.addFactoryCreate("*/text", JRPrintTextFactory.class.getName());
        digester.addSetNext("*/text", "addElement", JRPrintElement.class.getName());
        SetNestedPropertiesRule textRule = new SetNestedPropertiesRule(new String[]{"textContent", "textTruncateSuffix", "reportElement", "box", "font", "lineBreakOffsets"}, new String[]{"text", "textTruncateSuffix"});
        textRule.setTrimData(false);
        textRule.setAllowUnknownChildElements(true);
        digester.addRule("*/text", (Rule)textRule);
        digester.addRule("*/text/textContent", (Rule)new SetPropertiesRule("truncateIndex", "textTruncateIndex"));
        digester.addFactoryCreate("*/text/font", JRPrintFontFactory.class.getName());
        digester.addSetNext("*/text/font", "setFont", JRFont.class.getName());
        digester.addRule("*/text/lineBreakOffsets", new TextLineBreakOffsetsRule());
        this.addFrameRules(digester);
        this.addHyperlinkParameterRules(digester);
        this.addGenericElementRules(digester);
        return digester;
    }

    protected SAXParser createParser() {
        String parserFactoryClass = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty("net.sf.jasperreports.export.xml.parser.factory");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using SAX parser factory class " + parserFactoryClass));
        }
        JRSaxParserFactory factory = BaseSaxParserFactory.getFactory(this.jasperReportsContext, parserFactoryClass);
        return factory.createParser();
    }

    private void addFrameRules(JRXmlDigester digester) {
        digester.addFactoryCreate("*/frame", JRPrintFrameFactory.class.getName());
        digester.addSetNext("*/frame", "addElement", JRPrintElement.class.getName());
    }

    protected void addHyperlinkParameterRules(JRXmlDigester digester) {
        String parameterPattern = "*/hyperlinkParameter";
        digester.addFactoryCreate(parameterPattern, JRPrintHyperlinkParameterFactory.class);
        digester.addSetNext(parameterPattern, "addHyperlinkParameter", JRPrintHyperlinkParameter.class.getName());
        String parameterValuePattern = parameterPattern + "/" + "hyperlinkParameterValue";
        digester.addFactoryCreate(parameterValuePattern, JRPrintHyperlinkParameterValueFactory.class);
        digester.addCallMethod(parameterValuePattern, "setData", 0);
    }

    protected void addGenericElementRules(JRXmlDigester digester) {
        String elementPattern = "*/genericElement";
        digester.addFactoryCreate(elementPattern, JRGenericPrintElementFactory.class);
        digester.addSetNext(elementPattern, "addElement", JRPrintElement.class.getName());
        String elementTypePattern = elementPattern + "/" + "genericElementType";
        digester.addFactoryCreate(elementTypePattern, JRGenericElementTypeFactory.class);
        digester.addSetNext(elementTypePattern, "setGenericType");
        String elementParameterPattern = elementPattern + "/" + "genericElementParameter";
        digester.addFactoryCreate(elementParameterPattern, JRGenericPrintElementParameterFactory.class);
        digester.addCallMethod(elementParameterPattern, "addParameter");
        digester.addRule(elementParameterPattern, new JRGenericPrintElementParameterFactory.ArbitraryValueSetter());
        String elementParameterValuePattern = elementParameterPattern + "/" + "genericElementParameterValue";
        digester.addFactoryCreate(elementParameterValuePattern, JRGenericPrintElementParameterFactory.ParameterValueFactory.class);
        digester.addCallMethod(elementParameterValuePattern, "setData", 0);
        this.addValueHandlerRules(digester, elementParameterPattern);
    }

    protected void addValueHandlerRules(JRXmlDigester digester, String elementParameterPattern) {
        List<XmlValueHandler> handlers = XmlValueHandlerUtils.instance().getHandlers();
        for (XmlValueHandler handler : handlers) {
            XmlHandlerNamespace namespace = handler.getNamespace();
            if (namespace == null) continue;
            String namespaceURI = namespace.getNamespaceURI();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Configuring the digester for handler " + handler + " and namespace " + namespaceURI));
            }
            digester.setRuleNamespaceURI(namespaceURI);
            handler.configureDigester(digester);
            String schemaResource = namespace.getInternalSchemaResource();
            if (schemaResource == null) continue;
            digester.addInternalEntityResource(namespace.getPublicSchemaLocation(), schemaResource);
        }
        digester.setRuleNamespaceURI("http://jasperreports.sourceforge.net/jasperreports/print");
    }

    public void addError(Exception e) {
        this.errors.add(e);
    }

    @Override
    public void error(SAXParseException e) {
        this.errors.add(e);
    }

    @Override
    public void fatalError(SAXParseException e) {
        this.errors.add(e);
    }

    @Override
    public void warning(SAXParseException e) {
        this.errors.add(e);
    }
}

