/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.propertypages;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.client.users.UserGroup;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.usermanager.Messages;
import org.netxms.ui.eclipse.usermanager.dialogs.SelectUserDialog;
import org.netxms.ui.eclipse.usermanager.views.helpers.UserComparator;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class GroupMembership
extends PropertyPage {
    private SortableTableViewer groupList;
    private NXCSession session;
    private User object;
    private HashMap<Long, AbstractUserObject> groups = new HashMap(0);

    protected Control createContents(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        Composite dialogArea = new Composite(parent, 0);
        this.object = (User)this.getElement().getAdapter(User.class);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        String[] stringArray = new String[1];
        Messages.get();
        stringArray[0] = Messages.GroupMembership_ColName;
        String[] columnNames = stringArray;
        int[] columnWidths = new int[]{300};
        this.groupList = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.groupList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.groupList.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.groupList.setComparator((ViewerComparator)new UserComparator());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.groupList.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite(dialogArea, 0);
        FillLayout buttonsLayout = new FillLayout();
        buttonsLayout.spacing = 2;
        buttons.setLayout((Layout)buttonsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.widthHint = 184;
        buttons.setLayoutData((Object)gd);
        Button addButton = new Button(buttons, 8);
        Messages.get();
        addButton.setText(Messages.Members_Add);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                SelectUserDialog dlg = new SelectUserDialog(GroupMembership.this.getShell(), UserGroup.class);
                if (dlg.open() == 0) {
                    AbstractUserObject[] selection;
                    AbstractUserObject[] abstractUserObjectArray = selection = dlg.getSelection();
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractUserObject user = abstractUserObjectArray[n2];
                        GroupMembership.this.groups.put(user.getId(), user);
                        ++n2;
                    }
                    GroupMembership.this.groupList.setInput((Object)GroupMembership.this.groups.values().toArray(new AbstractUserObject[GroupMembership.this.groups.size()]));
                }
            }
        });
        final Button deleteButton = new Button(buttons, 8);
        Messages.get();
        deleteButton.setText(Messages.Members_Delete);
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)GroupMembership.this.groupList.getSelection();
                for (AbstractUserObject element : sel) {
                    GroupMembership.this.groups.remove(element.getId());
                }
                GroupMembership.this.groupList.setInput((Object)GroupMembership.this.groups.values().toArray());
            }
        });
        this.groupList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                deleteButton.setEnabled(!GroupMembership.this.groupList.getSelection().isEmpty());
            }
        });
        long[] lArray = this.object.getGroups();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            AbstractUserObject group = this.session.findUserDBObjectById(groupId);
            if (group != null) {
                this.groups.put(group.getId(), group);
            }
            ++n2;
        }
        this.groupList.setInput((Object)this.groups.values().toArray());
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        long[] groupIds = new long[this.groups.size()];
        int i = 0;
        for (Long id : this.groups.keySet()) {
            groupIds[i++] = id;
        }
        this.object.setGroups(groupIds);
        Messages.get();
        new ConsoleJob(Messages.Members_JobTitle, null, "org.netxms.ui.eclipse.usermanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                GroupMembership.this.session.modifyUserDBObject((AbstractUserObject)GroupMembership.this.object, 4096);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.Members_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            GroupMembership.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

