/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.net.InetAddress;
import java.util.Date;
import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.client.MacAddress;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.Interface;

public abstract class AbstractNode
extends DataCollectionTarget {
    public static final int SNMP_VERSION_1 = 0;
    public static final int SNMP_VERSION_2C = 1;
    public static final int SNMP_VERSION_3 = 3;
    public static final int AGENT_AUTH_NONE = 0;
    public static final int AGENT_AUTH_PLAINTEXT = 1;
    public static final int AGENT_AUTH_MD5 = 2;
    public static final int AGENT_AUTH_SHA1 = 3;
    public static final int NF_IS_SNMP = 1;
    public static final int NF_IS_NATIVE_AGENT = 2;
    public static final int NF_IS_BRIDGE = 4;
    public static final int NF_IS_ROUTER = 8;
    public static final int NF_IS_LOCAL_MGMT = 16;
    public static final int NF_IS_PRINTER = 32;
    public static final int NF_IS_OSPF = 64;
    public static final int NF_REMOTE_AGENT = 128;
    public static final int NF_IS_CPSNMP = 256;
    public static final int NF_IS_CDP = 512;
    public static final int NF_IS_SONMP = 1024;
    public static final int NF_IS_LLDP = 2048;
    public static final int NF_IS_VRRP = 4096;
    public static final int NF_HAS_VLANS = 8192;
    public static final int NF_IS_8021X = 16384;
    public static final int NF_IS_STP = 32768;
    public static final int NF_HAS_ENTITY_MIB = 65536;
    public static final int NF_HAS_IFXTABLE = 131072;
    public static final int NF_HAS_AGENT_IFXCOUNTERS = 262144;
    public static final int NF_HAS_WINPDH = 524288;
    public static final int NF_IS_WIFI_CONTROLLER = 0x100000;
    public static final int NF_IS_SMCLP = 0x200000;
    public static final int NF_DISABLE_DISCOVERY_POLL = 0x400000;
    public static final int NF_DISABLE_TOPOLOGY_POLL = 0x800000;
    public static final int NF_DISABLE_SNMP = 0x1000000;
    public static final int NF_DISABLE_NXCP = 0x2000000;
    public static final int NF_DISABLE_ICMP = 0x4000000;
    public static final int NF_FORCE_ENCRYPTION = 0x8000000;
    public static final int NF_DISABLE_STATUS_POLL = 0x10000000;
    public static final int NF_DISABLE_CONF_POLL = 0x20000000;
    public static final int NF_DISABLE_ROUTE_POLL = 0x40000000;
    public static final int NF_DISABLE_DATA_COLLECT = Integer.MIN_VALUE;
    public static final int NDF_UNREACHABLE = 4;
    public static final int NDF_AGENT_UNREACHABLE = 8;
    public static final int NDF_SNMP_UNREACHABLE = 16;
    public static final int NDF_CPSNMP_UNREACHABLE = 512;
    public static final int NDF_POLLING_DISABLED = 2048;
    public static final int IFXTABLE_DEFAULT = 0;
    public static final int IFXTABLE_ENABLED = 1;
    public static final int IFXTABLE_DISABLED = 2;
    protected InetAddress primaryIP;
    protected String primaryName;
    protected int flags;
    protected int runtimeFlags;
    protected int nodeType;
    protected int requredPollCount;
    protected long pollerNodeId;
    protected long agentProxyId;
    protected long snmpProxyId;
    protected long icmpProxyId;
    protected int agentPort;
    protected int agentAuthMethod;
    protected AgentCacheMode agentCacheMode;
    protected String agentSharedSecret;
    protected String agentVersion;
    protected String platformName;
    protected String snmpAuthName;
    protected String snmpAuthPassword;
    protected String snmpPrivPassword;
    protected int snmpAuthMethod;
    protected int snmpPrivMethod;
    protected String snmpOID;
    protected int snmpVersion;
    protected int snmpPort;
    protected String snmpSysName;
    protected String snmpSysContact;
    protected String snmpSysLocation;
    protected String systemDescription;
    protected String lldpNodeId;
    protected int vrrpVersion;
    protected String driverName;
    protected String driverVersion;
    protected long zoneId;
    protected MacAddress bridgeBaseAddress;
    protected int ifXTablePolicy;
    protected Date bootTime;
    protected Date lastAgentCommTime;
    protected long rackId;
    protected UUID rackImage;
    protected short rackPosition;
    protected short rackHeight;

    public AbstractNode(long id, NXCSession session) {
        super(id, session);
    }

    public AbstractNode(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.primaryIP = msg.getFieldAsInetAddress(8L);
        this.primaryName = msg.getFieldAsString(397L);
        this.flags = msg.getFieldAsInt32(13L);
        this.runtimeFlags = msg.getFieldAsInt32(355L);
        this.nodeType = msg.getFieldAsInt32(115L);
        this.requredPollCount = msg.getFieldAsInt32(299L);
        this.pollerNodeId = msg.getFieldAsInt64(135L);
        this.agentProxyId = msg.getFieldAsInt64(195L);
        this.snmpProxyId = msg.getFieldAsInt64(267L);
        this.icmpProxyId = msg.getFieldAsInt64(149L);
        this.agentPort = msg.getFieldAsInt32(15L);
        this.agentAuthMethod = msg.getFieldAsInt32(16L);
        this.agentSharedSecret = msg.getFieldAsString(17L);
        this.agentCacheMode = AgentCacheMode.getByValue(msg.getFieldAsInt32(503L));
        this.agentVersion = msg.getFieldAsString(124L);
        this.platformName = msg.getFieldAsString(128L);
        this.snmpAuthName = msg.getFieldAsString(18L);
        this.snmpAuthPassword = msg.getFieldAsString(89L);
        this.snmpPrivPassword = msg.getFieldAsString(91L);
        int methods = msg.getFieldAsInt32(84L);
        this.snmpAuthMethod = methods & 0xFF;
        this.snmpPrivMethod = methods >> 8;
        this.snmpOID = msg.getFieldAsString(19L);
        this.snmpPort = msg.getFieldAsInt32(80L);
        this.snmpVersion = msg.getFieldAsInt32(6L);
        this.systemDescription = msg.getFieldAsString(300L);
        this.snmpSysName = msg.getFieldAsString(365L);
        this.snmpSysContact = msg.getFieldAsString(515L);
        this.snmpSysLocation = msg.getFieldAsString(516L);
        this.lldpNodeId = msg.getFieldAsString(366L);
        this.vrrpVersion = msg.getFieldAsInt32(375L);
        this.driverName = msg.getFieldAsString(380L);
        this.driverVersion = msg.getFieldAsString(381L);
        this.zoneId = msg.getFieldAsInt64(147L);
        this.bridgeBaseAddress = new MacAddress(msg.getFieldAsBinary(388L));
        this.ifXTablePolicy = msg.getFieldAsInt32(318L);
        this.rackId = msg.getFieldAsInt64(517L);
        this.rackImage = msg.getFieldAsUUID(518L);
        this.rackPosition = msg.getFieldAsInt16(519L);
        this.rackHeight = msg.getFieldAsInt16(520L);
        long bootTimeSeconds = msg.getFieldAsInt64(454L);
        this.bootTime = bootTimeSeconds > 0L ? new Date(bootTimeSeconds * 1000L) : null;
        long commTimeSeconds = msg.getFieldAsInt64(532L);
        this.lastAgentCommTime = commTimeSeconds > 0L ? new Date(commTimeSeconds * 1000L) : null;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getRuntimeFlags() {
        return this.runtimeFlags;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public int getRequredPollCount() {
        return this.requredPollCount;
    }

    public long getPollerNodeId() {
        return this.pollerNodeId;
    }

    public long getAgentProxyId() {
        return this.agentProxyId;
    }

    public long getSnmpProxyId() {
        return this.snmpProxyId;
    }

    public long getIcmpProxyId() {
        return this.icmpProxyId;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public int getAgentAuthMethod() {
        return this.agentAuthMethod;
    }

    public String getAgentSharedSecret() {
        return this.agentSharedSecret;
    }

    public AgentCacheMode getAgentCacheMode() {
        return this.agentCacheMode;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public String getSnmpAuthName() {
        return this.snmpAuthName;
    }

    public String getSnmpOID() {
        return this.snmpOID;
    }

    public int getSnmpVersion() {
        return this.snmpVersion;
    }

    public String getSystemDescription() {
        return this.systemDescription;
    }

    public String getSnmpAuthPassword() {
        return this.snmpAuthPassword;
    }

    public String getSnmpPrivPassword() {
        return this.snmpPrivPassword;
    }

    public int getSnmpAuthMethod() {
        return this.snmpAuthMethod;
    }

    public int getSnmpPrivMethod() {
        return this.snmpPrivMethod;
    }

    public boolean hasAgent() {
        return (this.flags & 2) != 0;
    }

    public boolean hasSnmpAgent() {
        return (this.flags & 1) != 0;
    }

    public boolean isManagementServer() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isVrrpSupported() {
        return (this.flags & 0x1000) != 0;
    }

    public boolean is8021xSupported() {
        return (this.flags & 0x4000) != 0;
    }

    public boolean isSpanningTreeSupported() {
        return (this.flags & 0x8000) != 0;
    }

    public boolean isEntityMibSupported() {
        return (this.flags & 0x10000) != 0;
    }

    public boolean isIfXTableSupported() {
        return (this.flags & 0x20000) != 0;
    }

    public boolean isAgentIfXCountersSupported() {
        return (this.flags & 0x40000) != 0;
    }

    public boolean isWirelessController() {
        return (this.flags & 0x100000) != 0;
    }

    public int getSnmpPort() {
        return this.snmpPort;
    }

    public String getSnmpSysName() {
        return this.snmpSysName;
    }

    public String getSnmpSysContact() {
        return this.snmpSysContact;
    }

    public String getSnmpSysLocation() {
        return this.snmpSysLocation;
    }

    public String getLldpNodeId() {
        return this.lldpNodeId;
    }

    protected int getVrrpVersion() {
        return this.vrrpVersion;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public MacAddress getBridgeBaseAddress() {
        return this.bridgeBaseAddress;
    }

    public int getIfXTablePolicy() {
        return this.ifXTablePolicy;
    }

    public String getPrimaryName() {
        return this.primaryName;
    }

    public MacAddress getPrimaryMAC() {
        for (AbstractObject o : this.getAllChilds(3)) {
            Interface iface = (Interface)o;
            if (iface.isLoopback() || iface.getMacAddress() == null || !iface.hasAddress(this.primaryIP)) continue;
            return iface.getMacAddress();
        }
        return null;
    }

    public Date getBootTime() {
        return this.bootTime;
    }

    public InetAddress getPrimaryIP() {
        return this.primaryIP;
    }

    public long getRackId() {
        return this.rackId;
    }

    public UUID getRackImage() {
        return this.rackImage;
    }

    public short getRackPosition() {
        return this.rackPosition;
    }

    public short getRackHeight() {
        return this.rackHeight;
    }

    public Date getLastAgentCommTime() {
        return this.lastAgentCommTime;
    }
}

