/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.views;

import java.io.IOException;
import java.io.InputStream;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.ActionHandler;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.agentmanager.Messages;
import org.netxms.ui.eclipse.agentmanager.dialogs.SaveConfigDialog;
import org.netxms.ui.eclipse.agentmanager.widgets.AgentConfigEditor;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class AgentConfigEditorView
extends ViewPart
implements ISaveablePart2 {
    public static final String ID = "org.netxms.ui.eclipse.agentmanager.views.AgentConfigEditorView";
    private NXCSession session;
    private long nodeId;
    private AgentConfigEditor editor;
    private boolean modified = false;
    private boolean dirty = false;
    private boolean saveAndApply = false;
    private String saveData;
    private RefreshAction actionRefresh;
    private Action actionSave;
    private FindReplaceAction actionFindReplace;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
        this.nodeId = Long.parseLong(site.getSecondaryId());
        AbstractObject object = this.session.findObjectById(this.nodeId);
        Messages.get();
        this.setPartName(String.valueOf(Messages.AgentConfigEditorView_PartName) + (object != null ? object.getObjectName() : Long.toString(this.nodeId)));
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.editor = new AgentConfigEditor(parent, 0, 768);
        this.editor.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!AgentConfigEditorView.this.dirty) {
                    AgentConfigEditorView.this.modified = true;
                    AgentConfigEditorView.this.dirty = true;
                    AgentConfigEditorView.this.firePropertyChange(257);
                    AgentConfigEditorView.this.actionSave.setEnabled(true);
                    AgentConfigEditorView.this.actionFindReplace.update();
                }
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.actionSave.setEnabled(false);
    }

    public void setFocus() {
        this.editor.setFocus();
    }

    public void setConfig(String config) {
        this.editor.setText(config);
    }

    private void createActions() {
        try {
            this.actionFindReplace = new FindReplaceAction(this.getResourceBundle(), "actions.find_and_replace.", (IWorkbenchPart)this);
            IHandlerService hs = (IHandlerService)this.getSite().getService(IHandlerService.class);
            hs.activateHandler("org.eclipse.ui.edit.findReplace", (IHandler)new ActionHandler((IAction)this.actionFindReplace));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.actionRefresh = new RefreshAction(){

            public void run() {
            }
        };
        this.actionSave = new Action(){

            public void run() {
                AgentConfigEditorView.this.saveAndApply = false;
                AgentConfigEditorView.this.doSave(null);
                AgentConfigEditorView.this.actionSave.setEnabled(false);
                AgentConfigEditorView.this.dirty = false;
            }
        };
        Messages.get();
        this.actionSave.setText(Messages.AgentConfigEditorView_Save);
        this.actionSave.setImageDescriptor(SharedIcons.SAVE);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionFindReplace);
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.saveData = this.editor.getText();
            this.session.updateAgentConfig(this.nodeId, this.saveData, this.saveAndApply);
        }
        catch (Exception e) {
            Shell shell = this.getViewSite().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.AgentConfigEditorView_Error, (String)(String.valueOf(Messages.AgentConfigEditorView_SaveError) + e.getMessage()));
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.dirty || this.modified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }

    private ResourceBundle getResourceBundle() throws IOException {
        InputStream in = null;
        String resource = "resource.properties";
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        in = loader != null ? loader.getResourceAsStream(resource) : ClassLoader.getSystemResourceAsStream(resource);
        return new PropertyResourceBundle(in);
    }

    public int promptToSaveOnClose() {
        SaveConfigDialog dlg = new SaveConfigDialog(this.getSite().getShell());
        int rc = dlg.open();
        boolean bl = this.saveAndApply = rc == 101;
        return rc == 1 ? 2 : (rc == 102 ? 1 : 0);
    }
}

