/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.reporting;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.client.reporting.ReportRenderFormat;

public class ReportingJob {
    public static final int TYPE_ONCE = 0;
    public static final int TYPE_DAILY = 1;
    public static final int TYPE_WEEKLY = 2;
    public static final int TYPE_MONTHLY = 3;
    private UUID reportId;
    private UUID jobId;
    private int daysOfWeek;
    private int daysOfMonth;
    private int userId;
    private int type = 0;
    private Date startTime;
    private String comments;
    private boolean notifyOnCompletion = false;
    private ReportRenderFormat renderFormat = ReportRenderFormat.NONE;
    private List<String> emailRecipients = new ArrayList<String>(0);

    public ReportingJob(UUID reportId) {
        this.jobId = UUID.randomUUID();
        this.reportId = reportId;
        this.startTime = new Date();
        this.daysOfWeek = 0;
        this.daysOfMonth = 0;
        this.type = 0;
    }

    public ReportingJob(NXCPMessage msg, long varId) {
        this.jobId = msg.getFieldAsUUID(varId);
        this.reportId = msg.getFieldAsUUID(varId + 1L);
        this.userId = msg.getFieldAsInt32(varId + 2L);
        this.startTime = msg.getFieldAsDate(varId + 3L);
        this.daysOfWeek = msg.getFieldAsInt32(varId + 4L);
        this.daysOfMonth = msg.getFieldAsInt32(varId + 5L);
        this.type = msg.getFieldAsInt32(varId + 6L);
        this.comments = msg.getFieldAsString(varId + 7L);
    }

    public ReportRenderFormat getRenderFormat() {
        return this.renderFormat;
    }

    public void setRenderFormat(ReportRenderFormat renderFormat) {
        this.renderFormat = renderFormat;
    }

    public List<String> getEmailRecipients() {
        return this.emailRecipients;
    }

    public void setEmailRecipients(List<String> emailRecipients) {
        this.emailRecipients = emailRecipients;
    }

    public UUID getReportId() {
        return this.reportId;
    }

    public void setReportId(UUID reportId) {
        this.reportId = reportId;
    }

    public UUID getJobId() {
        return this.jobId;
    }

    public void setJobId(UUID jobId) {
        this.jobId = jobId;
    }

    public int getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public void setDaysOfWeek(int daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
    }

    public int getDaysOfMonth() {
        return this.daysOfMonth;
    }

    public void setDaysOfMonth(int daysOfMonth) {
        this.daysOfMonth = daysOfMonth;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public String getComments() {
        return this.comments == null ? "" : this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public boolean isNotifyOnCompletion() {
        return this.notifyOnCompletion;
    }

    public void setNotifyOnCompletion(boolean notifyOnCompletion) {
        this.notifyOnCompletion = notifyOnCompletion;
    }

    public String toString() {
        return "ReportingJob [reportId=" + this.reportId + ", jobId=" + this.jobId + ", daysOfWeek=" + this.daysOfWeek + ", daysOfMonth=" + this.daysOfMonth + ", userId=" + this.userId + ", type=" + this.type + ", startTime=" + this.startTime + ", comments=" + this.comments + "]";
    }
}

