/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.mobile.agent;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.concurrent.atomic.AtomicLong;
import org.netxms.base.EncryptionContext;
import org.netxms.base.GeoLocation;
import org.netxms.base.Logger;
import org.netxms.base.NXCPException;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCPMessageReceiver;
import org.netxms.base.NXCPMsgWaitQueue;
import org.netxms.mobile.agent.DciPushData;
import org.netxms.mobile.agent.MobileAgentException;

public class Session {
    public static final int DEFAULT_CONN_PORT = 4747;
    public static final int PROTOCOL_VERSION = 1;
    private String connAddress;
    private int connPort;
    private String connDeviceId;
    private String connLoginName;
    private String connPassword;
    private boolean connUseEncryption;
    private Socket connSocket = null;
    private NXCPMsgWaitQueue msgWaitQueue = null;
    private ReceiverThread recvThread = null;
    private AtomicLong requestId = new AtomicLong(1L);
    private boolean isConnected = false;
    private EncryptionContext encryptionContext = null;
    private int defaultRecvBufferSize = 65536;
    private int maxRecvBufferSize = 262144;
    private int commandTimeout = 30000;

    private void setupEncryption(NXCPMessage msg) throws IOException, MobileAgentException {
        NXCPMessage response = new NXCPMessage(132, msg.getMessageId());
        response.setEncryptionDisabled(true);
        try {
            this.encryptionContext = EncryptionContext.createInstance((NXCPMessage)msg);
            response.setField(155L, this.encryptionContext.getEncryptedSessionKey(msg));
            response.setField(158L, this.encryptionContext.getEncryptedIv(msg));
            response.setFieldInt16(156L, this.encryptionContext.getCipher());
            response.setFieldInt16(157L, this.encryptionContext.getKeyLength());
            response.setFieldInt16(238L, this.encryptionContext.getIvLength());
            response.setFieldInt32(28L, 0);
            Logger.debug((String)"Session.setupEncryption", (String)("Cipher selected: " + EncryptionContext.getCipherName((int)this.encryptionContext.getCipher())));
        }
        catch (Exception e) {
            response.setFieldInt32(28L, 42);
        }
        this.sendMessage(response);
    }

    public Session(String address, String deviceId, String loginName, String password) {
        this.connAddress = address;
        this.connPort = 4747;
        this.connDeviceId = deviceId;
        this.connLoginName = loginName;
        this.connPassword = password;
        this.connUseEncryption = false;
    }

    public Session(String address, int port, String deviceId, String loginName, String password) {
        this.connAddress = address;
        this.connPort = port;
        this.connDeviceId = deviceId;
        this.connLoginName = loginName;
        this.connPassword = password;
        this.connUseEncryption = false;
    }

    public Session(String address, int port, String deviceId, String loginName, String password, boolean useEncryption) {
        this.connAddress = address;
        this.connPort = port;
        this.connDeviceId = deviceId;
        this.connLoginName = loginName;
        this.connPassword = password;
        this.connUseEncryption = useEncryption;
    }

    protected void finalize() {
        this.disconnect();
    }

    public synchronized void sendMessage(NXCPMessage msg) throws IOException, MobileAgentException {
        byte[] message;
        if (this.connSocket == null) {
            throw new IllegalStateException("Not connected to the server. Did you forgot to call connect() first?");
        }
        OutputStream outputStream = this.connSocket.getOutputStream();
        if (this.encryptionContext != null && !msg.isEncryptionDisabled()) {
            try {
                message = this.encryptionContext.encryptMessage(msg);
            }
            catch (GeneralSecurityException e) {
                throw new MobileAgentException(98);
            }
        } else {
            message = msg.createNXCPMessage();
        }
        outputStream.write(message);
    }

    public NXCPMessage waitForMessage(int code, long id, int timeout) throws MobileAgentException {
        NXCPMessage msg = this.msgWaitQueue.waitForMessage(code, id, timeout);
        if (msg == null) {
            throw new MobileAgentException(4);
        }
        return msg;
    }

    public NXCPMessage waitForMessage(int code, long id) throws MobileAgentException {
        NXCPMessage msg = this.msgWaitQueue.waitForMessage(code, id);
        if (msg == null) {
            throw new MobileAgentException(4);
        }
        return msg;
    }

    public NXCPMessage waitForRCC(long id) throws MobileAgentException {
        return this.waitForRCC(id, this.msgWaitQueue.getDefaultTimeout());
    }

    public NXCPMessage waitForRCC(long id, int timeout) throws MobileAgentException {
        NXCPMessage msg = this.waitForMessage(29, id, timeout);
        int rcc = msg.getFieldAsInt32(28L);
        if (rcc != 0) {
            throw new MobileAgentException(rcc);
        }
        return msg;
    }

    public final NXCPMessage newMessage(int code) {
        return new NXCPMessage(code, this.requestId.getAndIncrement());
    }

    protected void executeSimpleCommand(int command) throws IOException, MobileAgentException {
        NXCPMessage msg = this.newMessage(command);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException, UnknownHostException, MobileAgentException {
        Logger.info((String)"Session.connect", (String)("Connecting to " + this.connAddress + ":" + this.connPort));
        try {
            this.connSocket = new Socket(this.connAddress, this.connPort);
            this.msgWaitQueue = new NXCPMsgWaitQueue(this.commandTimeout);
            this.recvThread = new ReceiverThread();
            Logger.debug((String)"Session.connect", (String)"connection established, retrieving server info");
            NXCPMessage request = this.newMessage(103);
            this.sendMessage(request);
            NXCPMessage response = this.waitForMessage(29, request.getMessageId());
            if (response.getFieldAsInt32(146L) != 1) {
                Logger.warning((String)"Session.connect", (String)("connection failed, server protocol version is " + response.getFieldAsInt32(146L)));
                throw new MobileAgentException(40);
            }
            String serverVersion = response.getFieldAsString(121L);
            if (this.connUseEncryption) {
                request = this.newMessage(133);
                request.setFieldInt16(319L, 1);
                this.sendMessage(request);
                this.waitForRCC(request.getMessageId());
            }
            Logger.debug((String)"Session.connect", (String)("Connected to server version " + serverVersion + ", trying to login"));
            request = this.newMessage(1);
            request.setField(433L, this.connDeviceId);
            request.setField(1L, this.connLoginName);
            request.setField(2L, this.connPassword);
            request.setField(177L, "2.0.8");
            request.setField(176L, System.getProperty("os.name") + " " + System.getProperty("os.version"));
            this.sendMessage(request);
            response = this.waitForMessage(2, request.getMessageId());
            int rcc = response.getFieldAsInt32(28L);
            Logger.debug((String)"Session.connect", (String)("CMD_LOGIN_RESP received, RCC=" + rcc));
            if (rcc != 0) {
                Logger.warning((String)"NXCSession.connect", (String)("Login failed, RCC=" + rcc));
                throw new MobileAgentException(rcc);
            }
            Logger.info((String)"Session.connect", (String)"succesfully connected and logged in");
            this.isConnected = true;
        }
        finally {
            if (!this.isConnected) {
                this.disconnect();
            }
        }
    }

    public void disconnect() {
        if (this.connSocket != null) {
            try {
                this.connSocket.shutdownInput();
                this.connSocket.shutdownOutput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.connSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.recvThread != null) {
            while (this.recvThread.isAlive()) {
                try {
                    this.recvThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.recvThread = null;
        }
        this.connSocket = null;
        if (this.msgWaitQueue != null) {
            this.msgWaitQueue.shutdown();
            this.msgWaitQueue = null;
        }
        this.isConnected = false;
    }

    public void setCommandTimeout(int commandTimeout) {
        this.commandTimeout = commandTimeout;
    }

    public void pushDciData(DciPushData[] data) throws IOException, MobileAgentException {
        NXCPMessage msg = this.newMessage(187);
        msg.setFieldInt32(111L, data.length);
        long varId = 0x10000000L;
        for (DciPushData d : data) {
            msg.setFieldInt32(varId++, (int)d.nodeId);
            if (d.nodeId == 0L) {
                msg.setField(varId++, d.nodeName);
            }
            msg.setFieldInt32(varId++, (int)d.dciId);
            if (d.dciId == 0L) {
                msg.setField(varId++, d.dciName);
            }
            msg.setField(varId++, d.value);
        }
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void pushDciData(long nodeId, long dciId, String value) throws IOException, MobileAgentException {
        this.pushDciData(new DciPushData[]{new DciPushData(nodeId, dciId, value)});
    }

    public void pushDciData(String nodeName, String dciName, String value) throws IOException, MobileAgentException {
        this.pushDciData(new DciPushData[]{new DciPushData(nodeName, dciName, value)});
    }

    public void reportDeviceSystemInfo(String vendor, String model, String osName, String osVersion, String serialNumber, String userId) throws IOException, MobileAgentException {
        NXCPMessage msg = this.newMessage(266);
        msg.setField(428L, vendor);
        msg.setField(429L, model);
        msg.setField(430L, osName);
        msg.setField(431L, osVersion);
        msg.setField(432L, serialNumber);
        if (userId != null) {
            msg.setField(34L, userId);
        }
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void reportDeviceStatus(InetAddress address, GeoLocation location, int flags, int batteryLevel) throws IOException, MobileAgentException {
        NXCPMessage msg = this.newMessage(265);
        if (address != null) {
            msg.setField(8L, address);
        } else {
            msg.setFieldInt32(8L, 0);
        }
        if (location != null) {
            msg.setField(343L, Double.valueOf(location.getLatitude()));
            msg.setField(344L, Double.valueOf(location.getLongitude()));
            msg.setFieldInt16(342L, location.getType());
            msg.setFieldInt16(438L, location.getAccuracy());
            msg.setFieldInt64(439L, location.getTimestamp() != null ? location.getTimestamp().getTime() / 1000L : 0L);
        } else {
            msg.setFieldInt16(342L, 0);
        }
        msg.setFieldInt32(13L, flags);
        msg.setFieldInt32(427L, batteryLevel);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    private class ReceiverThread
    extends Thread {
        ReceiverThread() {
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            InputStream in;
            NXCPMessageReceiver receiver = new NXCPMessageReceiver(Session.this.defaultRecvBufferSize, Session.this.maxRecvBufferSize);
            try {
                in = Session.this.connSocket.getInputStream();
            }
            catch (IOException e) {
                return;
            }
            block9: while (Session.this.connSocket.isConnected()) {
                try {
                    NXCPMessage msg = receiver.receiveMessage(in, Session.this.encryptionContext);
                    switch (msg.getMessageCode()) {
                        case 130: {
                            Session.this.setupEncryption(msg);
                            continue block9;
                        }
                    }
                    Session.this.msgWaitQueue.putMessage(msg);
                }
                catch (IOException e) {
                    break;
                }
                catch (NXCPException e) {
                    if (e.getErrorCode() != 2) continue;
                    break;
                }
                catch (MobileAgentException e) {
                    if (e.getErrorCode() != 98) continue;
                    break;
                }
            }
        }
    }
}

