/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxBorderInfo;
import net.sf.jasperreports.engine.export.ooxml.XlsxBorderInfo;
import net.sf.jasperreports.export.XlsReportConfiguration;

public class XlsxBorderHelper
extends BaseHelper {
    private Map<String, Integer> borderCache = new HashMap<String, Integer>();
    private XlsReportConfiguration configuration;

    public XlsxBorderHelper(JasperReportsContext jasperReportsContext, Writer writer) {
        super(jasperReportsContext, writer);
    }

    public void setConfiguration(XlsReportConfiguration configuration) {
        this.configuration = configuration;
    }

    public int getBorder(JRExporterGridCell gridCell) {
        if (this.configuration.isIgnoreCellBorder().booleanValue() || gridCell.getBox() == null) {
            return -1;
        }
        XlsxBorderInfo borderInfo = new XlsxBorderInfo(gridCell.getBox());
        Integer borderIndex = this.borderCache.get(borderInfo.getId());
        if (borderIndex == null) {
            borderIndex = this.borderCache.size();
            this.export(borderInfo);
            this.borderCache.put(borderInfo.getId(), borderIndex);
        }
        return borderIndex;
    }

    public void export(JRLineBox box) {
        if (box != null) {
            this.export(new XlsxBorderInfo(box));
        }
    }

    public void export(JRPen pen) {
        if (pen != null) {
            this.export(new XlsxBorderInfo(pen));
        }
    }

    private void export(XlsxBorderInfo info) {
        this.write("<border>");
        this.exportBorder(info, 1);
        this.exportBorder(info, 3);
        this.exportBorder(info, 0);
        this.exportBorder(info, 2);
        this.write("<diagonal/></border>\n");
    }

    private void exportBorder(XlsxBorderInfo info, int side) {
        this.write("<" + DocxBorderInfo.BORDER[side]);
        if (info.borderStyle[side] != null) {
            this.write(" style=\"" + info.borderStyle[side] + "\"");
        }
        this.write(">");
        if (info.borderColor[side] != null) {
            this.write("<color rgb=\"" + info.borderColor[side] + "\"/>");
        }
        this.write("</" + DocxBorderInfo.BORDER[side] + ">");
    }
}

