/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting.job;

import com.radensolutions.reporting.service.ReportManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GeneratorJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(GeneratorJob.class);
    @Autowired
    private ReportManager reportManager;
    private UUID jobId;
    private UUID reportId;
    private Map<String, String> parameters = new HashMap<String, String>();
    private String userName;
    private int userId;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            this.reportManager.execute(this.userId, this.reportId, this.jobId, this.parameters, Locale.US);
        }
        catch (Exception e) {
            log.error("Failed to execute report, job terminating", (Throwable)e);
        }
    }

    public UUID getJobId() {
        return this.jobId;
    }

    public void setJobId(UUID jobId) {
        this.jobId = jobId;
    }

    public UUID getReportId() {
        return this.reportId;
    }

    public void setReportId(UUID reportId) {
        this.reportId = reportId;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public String toString() {
        return "GeneratorJob{reportManager=" + this.reportManager + ", jobId=" + this.jobId + ", reportId=" + this.reportId + ", parameters=" + this.parameters + ", userName='" + this.userName + '\'' + ", userId='" + this.userId;
    }
}

