/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting.service.impl;

import com.radensolutions.reporting.service.Connector;
import com.radensolutions.reporting.service.impl.SessionWorker;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class TcpConnector
implements Connector {
    public static final int PORT = 4710;
    private static final Logger logger = LoggerFactory.getLogger(TcpConnector.class);
    private final List<SessionWorker> workers = new ArrayList<SessionWorker>();
    private ServerSocket serverSocket;
    private Thread listenerThread;
    @Autowired
    private ApplicationContext context;

    @Override
    public void start() throws IOException {
        this.serverSocket = new ServerSocket(4710);
        this.listenerThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Socket socket = TcpConnector.this.serverSocket.accept();
                        SessionWorker worker = (SessionWorker)TcpConnector.this.context.getBean(SessionWorker.class, new Object[]{socket});
                        List list = TcpConnector.this.workers;
                        synchronized (list) {
                            TcpConnector.this.workers.add(worker);
                        }
                        new Thread(worker).start();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.listenerThread.start();
    }

    @Override
    public void stop() {
        this.listenerThread.interrupt();
        for (SessionWorker worker : this.workers) {
            worker.stop();
        }
        try {
            this.listenerThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendBroadcast(NXCPMessage message) {
        List<SessionWorker> list = this.workers;
        synchronized (list) {
            Iterator<SessionWorker> iterator = this.workers.iterator();
            while (iterator.hasNext()) {
                SessionWorker worker = iterator.next();
                if (worker.isActive()) {
                    worker.sendMessage(message);
                    continue;
                }
                iterator.remove();
            }
        }
    }

    public String toString() {
        return "TcpConnector{serverSocket=" + this.serverSocket + '}';
    }
}

