/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.actionmanager.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.ServerAction;
import org.netxms.ui.eclipse.actionmanager.Messages;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class EditActionDlg
extends Dialog {
    private ServerAction action;
    private boolean createNew;
    private Text name;
    private LabeledText recipient;
    private LabeledText subject;
    private LabeledText data;
    private Button typeLocalExec;
    private Button typeRemoteExec;
    private Button typeExecScript;
    private Button typeEMail;
    private Button typeSMS;
    private Button typeXMPP;
    private Button typeForward;
    private Button markDisabled;

    public EditActionDlg(Shell parentShell, ServerAction action, boolean createNew) {
        super(parentShell);
        this.action = action;
        this.createNew = createNew;
    }

    protected void configureShell(Shell newShell) {
        String string;
        super.configureShell(newShell);
        if (this.createNew) {
            Messages.get();
            string = Messages.EditActionDlg_CreateAction;
        } else {
            Messages.get();
            string = Messages.EditActionDlg_EditAction;
        }
        newShell.setText(string);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        Messages.get();
        this.name = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)300, (String)Messages.EditActionDlg_Name, (String)this.action.getName(), (Object)"WidgetHelper::default_layout_data");
        Group typeGroup = new Group(dialogArea, 0);
        Messages.get();
        typeGroup.setText(Messages.EditActionDlg_Type);
        typeGroup.setLayout((Layout)new RowLayout(512));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        typeGroup.setLayoutData((Object)gd);
        this.typeLocalExec = new Button((Composite)typeGroup, 16);
        Messages.get();
        this.typeLocalExec.setText(Messages.EditActionDlg_ExecCommandOnServer);
        this.typeLocalExec.setSelection(this.action.getType() == 0);
        this.typeLocalExec.addSelectionListener((SelectionListener)new TypeButtonSelectionListener());
        this.typeRemoteExec = new Button((Composite)typeGroup, 16);
        Messages.get();
        this.typeRemoteExec.setText(Messages.EditActionDlg_ExecCommandOnNode);
        this.typeRemoteExec.setSelection(this.action.getType() == 1);
        this.typeRemoteExec.addSelectionListener((SelectionListener)new TypeButtonSelectionListener());
        this.typeExecScript = new Button((Composite)typeGroup, 16);
        Messages.get();
        this.typeExecScript.setText(Messages.EditActionDlg_ExecuteScript);
        this.typeExecScript.setSelection(this.action.getType() == 5);
        this.typeExecScript.addSelectionListener((SelectionListener)new TypeButtonSelectionListener());
        this.typeEMail = new Button((Composite)typeGroup, 16);
        Messages.get();
        this.typeEMail.setText(Messages.EditActionDlg_SenMail);
        this.typeEMail.setSelection(this.action.getType() == 2);
        this.typeEMail.addSelectionListener((SelectionListener)new TypeButtonSelectionListener());
        this.typeSMS = new Button((Composite)typeGroup, 16);
        Messages.get();
        this.typeSMS.setText(Messages.EditActionDlg_SendSMS);
        this.typeSMS.setSelection(this.action.getType() == 3);
        this.typeSMS.addSelectionListener((SelectionListener)new TypeButtonSelectionListener());
        this.typeXMPP = new Button((Composite)typeGroup, 16);
        Messages.get();
        this.typeXMPP.setText(Messages.EditActionDlg_SendXMPPMessage);
        this.typeXMPP.setSelection(this.action.getType() == 6);
        this.typeXMPP.addSelectionListener((SelectionListener)new TypeButtonSelectionListener());
        this.typeForward = new Button((Composite)typeGroup, 16);
        Messages.get();
        this.typeForward.setText(Messages.EditActionDlg_ForwardEvent);
        this.typeForward.setSelection(this.action.getType() == 4);
        this.typeForward.addSelectionListener((SelectionListener)new TypeButtonSelectionListener());
        Group optionsGroup = new Group(dialogArea, 0);
        Messages.get();
        optionsGroup.setText(Messages.EditActionDlg_Options);
        optionsGroup.setLayout((Layout)new RowLayout(512));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        this.markDisabled = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.markDisabled.setText(Messages.EditActionDlg_ActionDisabled);
        this.markDisabled.setSelection(this.action.isDisabled());
        this.recipient = new LabeledText(dialogArea, 0);
        this.recipient.setLabel(this.getRcptLabel(this.action.getType()));
        this.recipient.setText(this.action.getRecipientAddress());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.recipient.setLayoutData((Object)gd);
        this.subject = new LabeledText(dialogArea, 0);
        Messages.get();
        this.subject.setLabel(Messages.EditActionDlg_MailSubject);
        this.subject.setText(this.action.getEmailSubject());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.subject.setLayoutData((Object)gd);
        this.data = new LabeledText(dialogArea, 0);
        this.data.setLabel(this.getDataLabel(this.action.getType()));
        this.data.setText(this.action.getData());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.data.setLayoutData((Object)gd);
        this.onTypeChange();
        return dialogArea;
    }

    private String getRcptLabel(int type) {
        switch (type) {
            case 1: {
                Messages.get();
                return Messages.EditActionDlg_RemoteHost;
            }
            case 3: {
                Messages.get();
                return Messages.EditActionDlg_PhoneNumber;
            }
            case 6: {
                Messages.get();
                return Messages.EditActionDlg_XMPPID;
            }
            case 4: {
                Messages.get();
                return Messages.EditActionDlg_RemoteServer;
            }
            case 5: {
                Messages.get();
                return Messages.EditActionDlg_ScriptName;
            }
        }
        Messages.get();
        return Messages.EditActionDlg_Recipient;
    }

    private String getDataLabel(int type) {
        switch (type) {
            case 0: {
                Messages.get();
                return Messages.EditActionDlg_Command;
            }
            case 1: {
                Messages.get();
                return Messages.EditActionDlg_Action;
            }
        }
        Messages.get();
        return Messages.EditActionDlg_MessageText;
    }

    protected void okPressed() {
        if (this.typeLocalExec.getSelection()) {
            this.action.setType(0);
        } else if (this.typeRemoteExec.getSelection()) {
            this.action.setType(1);
        } else if (this.typeExecScript.getSelection()) {
            this.action.setType(5);
        } else if (this.typeEMail.getSelection()) {
            this.action.setType(2);
        } else if (this.typeSMS.getSelection()) {
            this.action.setType(3);
        } else if (this.typeXMPP.getSelection()) {
            this.action.setType(6);
        } else if (this.typeForward.getSelection()) {
            this.action.setType(4);
        }
        this.action.setName(this.name.getText());
        this.action.setRecipientAddress(this.recipient.getText());
        this.action.setEmailSubject(this.subject.getText());
        this.action.setData(this.data.getText());
        this.action.setDisabled(this.markDisabled.getSelection());
        super.okPressed();
    }

    private void onTypeChange() {
        int type = -1;
        if (this.typeLocalExec.getSelection()) {
            type = 0;
        } else if (this.typeRemoteExec.getSelection()) {
            type = 1;
        } else if (this.typeExecScript.getSelection()) {
            type = 5;
        } else if (this.typeEMail.getSelection()) {
            type = 2;
        } else if (this.typeSMS.getSelection()) {
            type = 3;
        } else if (this.typeXMPP.getSelection()) {
            type = 6;
        } else if (this.typeForward.getSelection()) {
            type = 4;
        }
        switch (type) {
            case 0: {
                this.recipient.setEnabled(false);
                this.subject.setEnabled(false);
                this.data.setEnabled(true);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                this.recipient.setEnabled(true);
                this.subject.setEnabled(false);
                this.data.setEnabled(true);
                break;
            }
            case 2: {
                this.recipient.setEnabled(true);
                this.subject.setEnabled(true);
                this.data.setEnabled(true);
                break;
            }
            case 4: 
            case 5: {
                this.recipient.setEnabled(true);
                this.subject.setEnabled(false);
                this.data.setEnabled(false);
            }
        }
        this.recipient.setLabel(this.getRcptLabel(type));
        this.data.setLabel(this.getDataLabel(type));
    }

    class TypeButtonSelectionListener
    implements SelectionListener {
        TypeButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            EditActionDlg.this.onTypeChange();
        }
    }
}

