/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.ui.eclipse.objectbrowser.Activator;
import org.netxms.ui.eclipse.objectbrowser.Messages;

public class ObjectDecorator
extends BaseLabelProvider
implements ILightweightLabelDecorator {
    private ImageDescriptor[] statusImages = new ImageDescriptor[9];
    private ImageDescriptor maintModeImage;
    private Color maintColor;

    public ObjectDecorator() {
        this.statusImages[1] = Activator.getImageDescriptor("icons/status/warning.png");
        this.statusImages[2] = Activator.getImageDescriptor("icons/status/minor.png");
        this.statusImages[3] = Activator.getImageDescriptor("icons/status/major.png");
        this.statusImages[4] = Activator.getImageDescriptor("icons/status/critical.png");
        this.statusImages[5] = Activator.getImageDescriptor("icons/status/unknown.gif");
        this.statusImages[6] = Activator.getImageDescriptor("icons/status/unmanaged.gif");
        this.statusImages[7] = Activator.getImageDescriptor("icons/status/disabled.gif");
        this.statusImages[8] = Activator.getImageDescriptor("icons/status/testing.png");
        this.maintModeImage = Activator.getImageDescriptor("icons/maint_mode.png");
        this.maintColor = new Color((Device)Display.getDefault(), 96, 96, 144);
    }

    public void dispose() {
        this.maintColor.dispose();
        super.dispose();
    }

    public void decorate(Object element, IDecoration decoration) {
        ObjectStatus status = ((AbstractObject)element).getStatus();
        decoration.addOverlay(this.statusImages[status.getValue()], 3);
        if (((AbstractObject)element).isInMaintenanceMode()) {
            decoration.addOverlay(this.maintModeImage, 1);
            Messages.get();
            decoration.addSuffix(Messages.ObjectDecorator_MaintenanceSuffix);
            decoration.setForegroundColor(this.maintColor);
        }
        if (element instanceof Interface && ((Interface)element).getOperState() == 2 && ((Interface)element).getAdminState() == 1 && ((Interface)element).getExpectedState() == 2) {
            decoration.addOverlay(this.statusImages[ObjectStatus.CRITICAL.getValue()], 0);
        }
    }
}

