/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.netxms.ui.eclipse.widgets.helpers.TableSortingListener;

public class SortableTableViewer
extends TableViewer {
    public static final int DEFAULT_STYLE = -1;
    private boolean initialized = false;
    private TableColumn[] columns;
    private TableSortingListener sortingListener;

    public SortableTableViewer(Composite parent, String[] names, int[] widths, int defaultSortingColumn, int defaultSortDir, int style) {
        super(new Table(parent, style == -1 ? 65538 : style));
        this.getTable().setLinesVisible(true);
        this.getTable().setHeaderVisible(true);
        this.createColumns(names, widths, defaultSortingColumn, defaultSortDir);
    }

    public SortableTableViewer(Composite parent, int style) {
        super(new Table(parent, style == -1 ? 65538 : style));
        this.getTable().setLinesVisible(true);
        this.getTable().setHeaderVisible(true);
    }

    public void createColumns(String[] names, int[] widths, int defaultSortingColumn, int defaultSortDir) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.sortingListener = new TableSortingListener(this);
        this.columns = new TableColumn[names.length];
        int i = 0;
        while (i < names.length) {
            this.columns[i] = new TableColumn(this.getTable(), 16384);
            this.columns[i].setText(names[i]);
            if (widths != null) {
                this.columns[i].setWidth(widths[i]);
            }
            this.columns[i].setData("ID", (Object)new Integer(i));
            this.columns[i].addSelectionListener((SelectionListener)this.sortingListener);
            ++i;
        }
        if (defaultSortingColumn >= 0 && defaultSortingColumn < names.length) {
            this.getTable().setSortColumn(this.columns[defaultSortingColumn]);
        }
        this.getTable().setSortDirection(defaultSortDir);
    }

    public TableColumn getColumnById(int id) {
        int i = 0;
        while (i < this.columns.length) {
            if ((Integer)this.columns[i].getData("ID") == id) {
                return this.columns[i];
            }
            ++i;
        }
        return null;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void disableSorting() {
        int i = 0;
        while (i < this.columns.length) {
            this.columns[i].removeSelectionListener((SelectionListener)this.sortingListener);
            ++i;
        }
        this.getTable().setSortColumn(null);
    }

    public TableColumn getColumnAtPoint(Point p) {
        TableItem item = this.getTable().getItem(p);
        if (item == null) {
            return null;
        }
        int columnCount = this.getTable().getColumnCount();
        int i = 0;
        while (i < columnCount) {
            Rectangle rect = item.getBounds(i);
            if (rect.contains(p)) {
                return this.getTable().getColumn(i);
            }
            ++i;
        }
        return null;
    }

    public ViewerRow getViewerRowFromItem(Widget item) {
        return super.getViewerRowFromItem(item);
    }
}

