/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.Date;
import org.netxms.base.NXCPMessage;

public class ScheduledTask {
    private long id;
    private String scheduledTaskId;
    private String schedule;
    private String parameters;
    private Date executionTime;
    private Date lastExecutionTime;
    private int flags;
    private long owner;
    private long objectId;
    public static final int DISABLED = 1;
    public static final int EXECUTED = 2;
    public static final int IN_PROGRES = 4;
    public static final int INTERNAL = 8;
    private static final String[] statusDescription = new String[]{"Disabled", "Completed", "Running"};

    public ScheduledTask() {
        this.id = 0L;
        this.scheduledTaskId = "";
        this.schedule = "";
        this.parameters = "";
        this.executionTime = new Date();
        this.lastExecutionTime = new Date();
        this.flags = 0;
        this.owner = 0L;
        this.objectId = 0L;
    }

    public ScheduledTask(NXCPMessage msg, long base) {
        this.id = msg.getFieldAsInt64(base);
        this.scheduledTaskId = msg.getFieldAsString(base + 1L);
        this.schedule = msg.getFieldAsString(base + 2L);
        this.parameters = msg.getFieldAsString(base + 3L);
        this.executionTime = msg.getFieldAsDate(base + 4L);
        this.lastExecutionTime = msg.getFieldAsDate(base + 5L);
        this.flags = msg.getFieldAsInt32(base + 6L);
        this.owner = msg.getFieldAsInt64(base + 7L);
        this.objectId = msg.getFieldAsInt64(base + 8L);
    }

    public ScheduledTask(String scheduledTaskId, String schedule, String parameters, Date executionTime, int flags, long objectId) {
        this.id = 0L;
        this.scheduledTaskId = scheduledTaskId;
        this.schedule = schedule;
        this.parameters = parameters;
        this.executionTime = executionTime;
        this.lastExecutionTime = new Date(0L);
        this.flags = flags;
        this.owner = 0L;
        this.objectId = objectId;
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setFieldInt32(522L, (int)this.id);
        msg.setField(523L, this.scheduledTaskId);
        if (this.schedule.isEmpty()) {
            msg.setField(525L, this.executionTime);
        } else {
            msg.setField(524L, this.schedule);
        }
        msg.setField(85L, this.parameters);
        msg.setField(526L, this.lastExecutionTime);
        msg.setFieldInt32(13L, this.flags);
        msg.setFieldInt32(3L, (int)this.objectId);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getScheduledTaskId() {
        return this.scheduledTaskId;
    }

    public void setScheduledTaskId(String scheduledTaskId) {
        this.scheduledTaskId = scheduledTaskId;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public Date getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(Date executionTime) {
        this.executionTime = executionTime;
    }

    public Date getLastExecutionTime() {
        return this.lastExecutionTime;
    }

    public void setLastExecutionTime(Date lastExecutionTime) {
        this.lastExecutionTime = lastExecutionTime;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public long getOwner() {
        return this.owner;
    }

    public void setOwner(long owner) {
        this.owner = owner;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }

    public String getStatus() {
        if ((this.flags & 4) > 0) {
            return statusDescription[2];
        }
        if ((this.flags & 2) > 0) {
            return statusDescription[1];
        }
        if ((this.flags & 1) > 0) {
            return statusDescription[0];
        }
        return "";
    }

    public boolean isDisbaled() {
        return (this.flags & 1) > 0;
    }

    public void setEnabed(boolean enabled) {
        this.flags = enabled ? (this.flags &= 0xFFFFFFFE) : (this.flags |= 1);
    }
}

