/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.netxms.base.InetAddressEx;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.GenericObject;

public class VPNConnector
extends GenericObject {
    private long peerGatewayId;
    private List<InetAddressEx> localSubnets;
    private List<InetAddressEx> remoteSubnets;

    public VPNConnector(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.peerGatewayId = msg.getFieldAsInt64(22L);
        long fieldId = 0x10000000L;
        int count = msg.getFieldAsInt32(161L);
        this.localSubnets = new ArrayList<InetAddressEx>(count);
        int i = 0;
        while (i < count) {
            this.localSubnets.add(msg.getFieldAsInetAddressEx(fieldId++));
            ++i;
        }
        count = msg.getFieldAsInt32(162L);
        this.remoteSubnets = new ArrayList<InetAddressEx>(count);
        i = 0;
        while (i < count) {
            this.remoteSubnets.add(msg.getFieldAsInetAddressEx(fieldId++));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractNode getParentNode() {
        AbstractNode node = null;
        HashSet hashSet = this.parents;
        synchronized (hashSet) {
            for (Long id : this.parents) {
                AbstractObject object = this.session.findObjectById(id);
                if (!(object instanceof AbstractNode)) continue;
                node = (AbstractNode)object;
                break;
            }
        }
        return node;
    }

    @Override
    public String getObjectClassName() {
        return "VPNConnector";
    }

    public long getPeerGatewayId() {
        return this.peerGatewayId;
    }

    public List<InetAddressEx> getLocalSubnets() {
        return this.localSubnets;
    }

    public List<InetAddressEx> getRemoteSubnets() {
        return this.remoteSubnets;
    }
}

