/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objecttools;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.netxms.base.Glob;
import org.netxms.base.Logger;
import org.netxms.base.NXCPMessage;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objecttools.InputField;
import org.netxms.client.objecttools.ObjectToolFilter;

public class ObjectTool {
    public static final int TYPE_INTERNAL = 0;
    public static final int TYPE_ACTION = 1;
    public static final int TYPE_TABLE_SNMP = 2;
    public static final int TYPE_TABLE_AGENT = 3;
    public static final int TYPE_URL = 4;
    public static final int TYPE_LOCAL_COMMAND = 5;
    public static final int TYPE_SERVER_COMMAND = 6;
    public static final int TYPE_FILE_DOWNLOAD = 7;
    public static final int TYPE_SERVER_SCRIPT = 8;
    public static final int REQUIRES_SNMP = 1;
    public static final int REQUIRES_AGENT = 2;
    public static final int REQUIRES_OID_MATCH = 4;
    public static final int ASK_CONFIRMATION = 8;
    public static final int GENERATES_OUTPUT = 16;
    public static final int DISABLED = 32;
    public static final int SHOW_IN_COMMANDS = 64;
    public static final int REQUIRES_NODE_OS_MATCH = 128;
    public static final int REQUIRES_TEMPLATE_MATCH = 256;
    public static final int SNMP_INDEXED_BY_VALUE = 65536;
    public static final int REQUIRES_WORKSTATION_OS_MATCH = 131072;
    protected long id;
    protected String name;
    protected String displayName;
    protected int type;
    protected int flags;
    protected String description;
    protected String data;
    protected String confirmationText;
    protected String commandName;
    protected String commandShortName;
    protected ObjectToolFilter filter;
    protected byte[] imageData;
    protected Map<String, InputField> inputFields;

    protected ObjectTool() {
        this.filter = new ObjectToolFilter();
        this.inputFields = new HashMap<String, InputField>(0);
    }

    public ObjectTool(NXCPMessage msg, long baseId) {
        block4: {
            this.id = msg.getFieldAsInt64(baseId);
            this.name = msg.getFieldAsString(baseId + 1L);
            this.type = msg.getFieldAsInt32(baseId + 2L);
            this.data = msg.getFieldAsString(baseId + 3L);
            this.flags = msg.getFieldAsInt32(baseId + 4L);
            String filterData = msg.getFieldAsString(baseId + 6L);
            this.description = msg.getFieldAsString(baseId + 5L);
            this.confirmationText = msg.getFieldAsString(baseId + 7L);
            this.commandName = msg.getFieldAsString(baseId + 8L);
            this.commandShortName = msg.getFieldAsString(baseId + 9L);
            this.imageData = msg.getFieldAsBinary(baseId + 10L);
            try {
                this.filter = ObjectToolFilter.createFromXml(filterData);
            }
            catch (Exception e) {
                this.filter = new ObjectToolFilter();
                if (filterData.isEmpty()) break block4;
                Logger.debug((String)"ObjectTool.ObjectTool", (String)"Failed to create object tool filter from XML");
            }
        }
        int count = msg.getFieldAsInt32(baseId + 11L);
        this.inputFields = new HashMap<String, InputField>(count);
        long fieldId = baseId + 20L;
        for (int i = 0; i < count; ++i) {
            InputField f = new InputField(msg, fieldId);
            this.inputFields.put(f.getName(), f);
            fieldId += 10L;
        }
        if (this.type == 1 || this.type == 7 || this.type == 5 || this.type == 6 || this.type == 4) {
            this.validateInputFields();
        }
        this.createDisplayName();
    }

    protected void validateInputFields() {
        HashSet<String> names = new HashSet<String>();
        char[] in = this.data.toCharArray();
        int br = 0;
        int start = 0;
        for (int i = 0; i < in.length; ++i) {
            if (in[i] == br) {
                if (br == 41) {
                    names.add(new String(Arrays.copyOfRange(in, start, i)));
                }
                br = 0;
                continue;
            }
            if (in[i] != '%' || br != 0) continue;
            if (++i == in.length) break;
            switch (in[i]) {
                case '(': {
                    br = 41;
                    break;
                }
                case '[': {
                    br = 93;
                    break;
                }
                case '{': {
                    br = 125;
                    break;
                }
                case '<': {
                    br = 62;
                    break;
                }
            }
            start = i + 1;
        }
        for (String n : names) {
            if (this.inputFields.containsKey(n)) continue;
            this.inputFields.put(n, new InputField(n));
        }
    }

    protected void createDisplayName() {
        String[] parts = this.name.split("->");
        this.displayName = parts.length > 0 ? parts[parts.length - 1].replace("&", "").trim() : this.name.replace("&", "").trim();
    }

    public boolean isApplicableForNode(AbstractNode node) {
        int i;
        String[] substrings;
        boolean match;
        if ((this.flags & 1) != 0 && (node.getFlags() & 1) == 0) {
            return false;
        }
        if ((this.flags & 2) != 0 && (node.getFlags() & 2) == 0) {
            return false;
        }
        if ((this.flags & 4) != 0 && !Glob.matchIgnoreCase((String)this.filter.snmpOid, (String)node.getSnmpOID())) {
            return false;
        }
        if ((this.flags & 0x80) != 0) {
            match = false;
            substrings = this.filter.toolNodeOS.split(",");
            for (i = 0; i < substrings.length; ++i) {
                if (!Pattern.matches(substrings[i], node.getPlatformName())) continue;
                match = true;
            }
            if (!match) {
                return false;
            }
        }
        if ((this.flags & 0x20000) != 0) {
            match = false;
            substrings = this.filter.toolWorkstationOS.split(",");
            for (i = 0; i < substrings.length; ++i) {
                if (!Pattern.matches(substrings[i], System.getProperty("os.name"))) continue;
                match = true;
            }
            if (!match) {
                return false;
            }
        }
        if ((this.flags & 0x100) != 0) {
            match = false;
            substrings = this.filter.toolTemplate.split(",");
            Set<AbstractObject> parents = node.getAllParents(8);
            for (AbstractObject parent : parents) {
                for (int i2 = 0; i2 < substrings.length; ++i2) {
                    if (!Pattern.matches(substrings[i2], parent.getObjectName())) continue;
                    match = true;
                }
            }
            if (!match) {
                return false;
            }
        }
        return true;
    }

    public InputField getInputField(String name) {
        return this.inputFields.get(name);
    }

    public InputField[] getInputFields() {
        return this.inputFields.values().toArray(new InputField[this.inputFields.size()]);
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isVisibleInCommands() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isEnabled() {
        return (this.flags & 0x20) == 0;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSnmpOid() {
        return this.filter.snmpOid;
    }

    public String getData() {
        return this.data;
    }

    public String getConfirmationText() {
        return this.confirmationText;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getCommandDisplayName() {
        if (this.commandName != null && !this.commandName.isEmpty()) {
            return this.commandName;
        }
        return this.displayName;
    }

    public String getCommandShortName() {
        return this.commandShortName;
    }

    public String getCommandShortDisplayName() {
        if (this.commandShortName != null && !this.commandShortName.isEmpty()) {
            return this.commandShortName;
        }
        return this.getCommandDisplayName();
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public String getToolNodeOS() {
        return this.filter.toolNodeOS;
    }

    public String getToolWorkstationOS() {
        return this.filter.toolWorkstationOS;
    }

    public String getToolTemplate() {
        return this.filter.toolTemplate;
    }
}

