/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum ConnectionPointType {
    INDIRECT(0),
    DIRECT(1),
    WIRELESS(2);

    private int value;
    private static Map<Integer, ConnectionPointType> lookupTable;

    private ConnectionPointType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ConnectionPointType getByValue(int value) {
        ConnectionPointType element = lookupTable.get(value);
        if (element == null) {
            Logger.warning((String)ConnectionPointType.class.getName(), (String)("Unknown element " + value));
            return INDIRECT;
        }
        return element;
    }

    static {
        lookupTable = new HashMap<Integer, ConnectionPointType>();
        for (ConnectionPointType element : ConnectionPointType.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

