/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.fill.JRFillCategorySeries;
import net.sf.jasperreports.charts.util.CategoryLabelGenerator;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;

public class JRFillCategoryDataset
extends JRFillChartDataset
implements JRCategoryDataset {
    public static final String EXCEPTION_MESSAGE_KEY_SERIES_NULL_NAME = "charts.category.dataset.series.null.name";
    protected JRFillCategorySeries[] categorySeries;
    private DefaultCategoryDataset dataset;
    private Map<Comparable<?>, Map<Comparable<?>, String>> labelsMap;
    private Map<Comparable<?>, Map<Comparable<?>, JRPrintHyperlink>> itemHyperlinks;

    public JRFillCategoryDataset(JRCategoryDataset categoryDataset, JRFillObjectFactory factory) {
        super(categoryDataset, factory);
        JRCategorySeries[] srcCategorySeries = categoryDataset.getSeries();
        if (srcCategorySeries != null && srcCategorySeries.length > 0) {
            this.categorySeries = new JRFillCategorySeries[srcCategorySeries.length];
            for (int i = 0; i < this.categorySeries.length; ++i) {
                this.categorySeries[i] = (JRFillCategorySeries)factory.getCategorySeries(srcCategorySeries[i]);
            }
        }
    }

    @Override
    public JRCategorySeries[] getSeries() {
        return this.categorySeries;
    }

    @Override
    protected void customInitialize() {
        this.dataset = null;
        this.labelsMap = null;
        this.itemHyperlinks = null;
    }

    @Override
    protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
        if (this.categorySeries != null && this.categorySeries.length > 0) {
            for (int i = 0; i < this.categorySeries.length; ++i) {
                this.categorySeries[i].evaluate(calculator);
            }
        }
    }

    @Override
    protected void customIncrement() {
        if (this.categorySeries != null && this.categorySeries.length > 0) {
            if (this.dataset == null) {
                this.dataset = new DefaultCategoryDataset();
                this.labelsMap = new HashMap();
                this.itemHyperlinks = new HashMap();
            }
            for (int i = 0; i < this.categorySeries.length; ++i) {
                JRFillCategorySeries crtCategorySeries = this.categorySeries[i];
                Comparable<?> seriesName = crtCategorySeries.getSeries();
                if (seriesName == null) {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_SERIES_NULL_NAME, (Object[])null);
                }
                this.dataset.addValue(crtCategorySeries.getValue(), crtCategorySeries.getSeries(), crtCategorySeries.getCategory());
                if (crtCategorySeries.getLabelExpression() != null) {
                    Map<Comparable<?>, String> seriesLabels = this.labelsMap.get(seriesName);
                    if (seriesLabels == null) {
                        seriesLabels = new HashMap();
                        this.labelsMap.put(seriesName, seriesLabels);
                    }
                    seriesLabels.put(crtCategorySeries.getCategory(), crtCategorySeries.getLabel());
                }
                if (!crtCategorySeries.hasItemHyperlinks()) continue;
                Map<Comparable<?>, JRPrintHyperlink> seriesLinks = this.itemHyperlinks.get(seriesName);
                if (seriesLinks == null) {
                    seriesLinks = new HashMap();
                    this.itemHyperlinks.put(seriesName, seriesLinks);
                }
                seriesLinks.put(crtCategorySeries.getCategory(), crtCategorySeries.getPrintItemHyperlink());
            }
        }
    }

    @Override
    public Dataset getCustomDataset() {
        return this.dataset;
    }

    @Override
    public byte getDatasetType() {
        return 2;
    }

    @Override
    public Object getLabelGenerator() {
        return new CategoryLabelGenerator(this.labelsMap);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public Map<Comparable<?>, Map<Comparable<?>, JRPrintHyperlink>> getItemHyperlinks() {
        return this.itemHyperlinks;
    }

    public boolean hasItemHyperlinks() {
        boolean foundLinks = false;
        if (this.categorySeries != null && this.categorySeries.length > 0) {
            for (int i = 0; i < this.categorySeries.length && !foundLinks; ++i) {
                JRFillCategorySeries serie = this.categorySeries[i];
                foundLinks = serie.hasItemHyperlinks();
            }
        }
        return foundLinks;
    }

    @Override
    public void validate(JRVerifier verifier) {
        verifier.verify(this);
    }
}

