/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class Agent
extends PropertyPage {
    private AbstractNode node;
    private LabeledText agentPort;
    private LabeledText agentSharedSecret;
    private Combo agentAuthMethod;
    private Button agentForceEncryption;
    private ObjectSelector agentProxy;

    protected Control createContents(Composite parent) {
        this.node = (AbstractNode)this.getElement().getAdapter(AbstractNode.class);
        Composite dialogArea = new Composite(parent, 0);
        FormLayout dialogLayout = new FormLayout();
        dialogLayout.marginWidth = 0;
        dialogLayout.marginHeight = 0;
        dialogLayout.spacing = 5;
        dialogArea.setLayout((Layout)dialogLayout);
        this.agentPort = new LabeledText(dialogArea, 0);
        Messages.get();
        this.agentPort.setLabel(Messages.Communication_TCPPort);
        this.agentPort.setText(Integer.toString(this.node.getAgentPort()));
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        this.agentPort.setLayoutData((Object)fd);
        this.agentProxy = new ObjectSelector(dialogArea, 0, true);
        Messages.get();
        this.agentProxy.setLabel(Messages.Communication_Proxy);
        this.agentProxy.setObjectId(this.node.getAgentProxyId());
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.agentPort, 0, 131072);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, 0);
        this.agentProxy.setLayoutData((Object)fd);
        this.agentForceEncryption = new Button(dialogArea, 32);
        Messages.get();
        this.agentForceEncryption.setText(Messages.Communication_ForceEncryption);
        this.agentForceEncryption.setSelection((this.node.getFlags() & 0x8000000) != 0);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.agentPort, 0, 1024);
        this.agentForceEncryption.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.agentForceEncryption, 0, 1024);
        Messages.get();
        this.agentAuthMethod = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)Messages.Communication_AuthMethod, (Object)fd);
        Messages.get();
        this.agentAuthMethod.add(Messages.Communication_AuthNone);
        Messages.get();
        this.agentAuthMethod.add(Messages.Communication_AuthPlain);
        Messages.get();
        this.agentAuthMethod.add(Messages.Communication_AuthMD5);
        Messages.get();
        this.agentAuthMethod.add(Messages.Communication_AuthSHA1);
        this.agentAuthMethod.select(this.node.getAgentAuthMethod());
        this.agentAuthMethod.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Agent.this.agentSharedSecret.getTextControl().setEnabled(Agent.this.agentAuthMethod.getSelectionIndex() != 0);
            }
        });
        this.agentSharedSecret = new LabeledText(dialogArea, 0);
        Messages.get();
        this.agentSharedSecret.setLabel(Messages.Communication_SharedSecret);
        this.agentSharedSecret.setText(this.node.getAgentSharedSecret());
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.agentAuthMethod.getParent(), 0, 131072);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.agentForceEncryption, 0, 1024);
        this.agentSharedSecret.setLayoutData((Object)fd);
        this.agentSharedSecret.getTextControl().setEnabled(this.node.getAgentAuthMethod() != 0);
        return dialogArea;
    }

    protected boolean applyChanges(final boolean isApply) {
        final NXCObjectModificationData md = new NXCObjectModificationData(this.node.getObjectId());
        if (isApply) {
            this.setValid(false);
        }
        try {
            md.setAgentPort(Integer.parseInt(this.agentPort.getText(), 10));
        }
        catch (NumberFormatException numberFormatException) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialog.openWarning((Shell)shell, (String)Messages.Communication_Warning, (String)Messages.Communication_WarningInvalidAgentPort);
            if (isApply) {
                this.setValid(true);
            }
            return false;
        }
        md.setAgentProxy(this.agentProxy.getObjectId());
        md.setAgentAuthMethod(this.agentAuthMethod.getSelectionIndex());
        md.setAgentSecret(this.agentSharedSecret.getText());
        int flags = this.node.getFlags();
        flags = this.agentForceEncryption.getSelection() ? (flags |= 0x8000000) : (flags &= 0xF7FFFFFF);
        md.setObjectFlags(flags);
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob(String.format("Updating agent communication settings for node %s", this.node.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                return String.format("Cannot update communication settings for node %s", Agent.this.node.getObjectName());
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Agent.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.agentPort.setText("4700");
        this.agentForceEncryption.setSelection(false);
        this.agentAuthMethod.select(0);
        this.agentProxy.setObjectId(0L);
        this.agentSharedSecret.setText("");
        this.agentSharedSecret.getTextControl().setEnabled(false);
    }
}

