/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.base.NXCommon;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.RackElement;
import org.netxms.ui.eclipse.imagelibrary.widgets.ImageSelector;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;

public class RackPlacement
extends PropertyPage {
    private RackElement object;
    private ObjectSelector rackSelector;
    private ImageSelector rackImageSelector;
    private LabeledSpinner rackHeight;
    private LabeledSpinner rackPosition;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (RackElement)this.getElement().getAdapter(RackElement.class);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.rackSelector = new ObjectSelector(dialogArea, 0, true);
        Messages.get();
        this.rackSelector.setLabel(Messages.RackPlacement_Rack);
        this.rackSelector.setObjectClass(Rack.class);
        this.rackSelector.setObjectId(this.object.getRackId());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.rackSelector.setLayoutData((Object)gd);
        this.rackImageSelector = new ImageSelector(dialogArea, 0);
        Messages.get();
        this.rackImageSelector.setLabel(Messages.RackPlacement_RackImage);
        this.rackImageSelector.setImageGuid(this.object.getRackImage(), false);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.rackImageSelector.setLayoutData((Object)gd);
        this.rackPosition = new LabeledSpinner(dialogArea, 0);
        Messages.get();
        this.rackPosition.setLabel(Messages.RackPlacement_Position);
        this.rackPosition.setRange(1, 50);
        this.rackPosition.setSelection((int)this.object.getRackPosition());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.rackPosition.setLayoutData((Object)gd);
        this.rackHeight = new LabeledSpinner(dialogArea, 0);
        Messages.get();
        this.rackHeight.setLabel(Messages.RackPlacement_Height);
        this.rackHeight.setRange(1, 50);
        this.rackHeight.setSelection((int)this.object.getRackHeight());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.rackHeight.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setRackPlacement(this.rackSelector.getObjectId(), this.rackImageSelector.getImageGuid(), (short)this.rackPosition.getSelection(), (short)this.rackHeight.getSelection());
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(String.format(Messages.RackPlacement_UpdatingRackPlacement, this.object.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.Comments_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            RackPlacement.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.rackSelector.setObjectId(0L);
        this.rackImageSelector.setImageGuid(NXCommon.EMPTY_GUID, true);
        this.rackPosition.setSelection(1);
        this.rackHeight.setSelection(1);
    }
}

