/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.gef4.zest.layouts.LayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.netxms.base.NXCommon;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.maps.MapLayoutAlgorithm;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.configs.DCIImageConfiguration;
import org.netxms.client.maps.configs.SingleDciConfig;
import org.netxms.client.maps.elements.NetworkMapDCIContainer;
import org.netxms.client.maps.elements.NetworkMapDCIImage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.NetworkMap;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageProvider;
import org.netxms.ui.eclipse.networkmaps.Activator;
import org.netxms.ui.eclipse.networkmaps.algorithms.ManualLayout;
import org.netxms.ui.eclipse.networkmaps.algorithms.SparseTree;
import org.netxms.ui.eclipse.networkmaps.api.ObjectDoubleClickHandler;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ExtendedGraphViewer;
import org.netxms.ui.eclipse.networkmaps.views.helpers.LinkDciValueProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapContentProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ColorConverter;

public class NetworkMapWidget
extends Composite {
    protected ExtendedGraphViewer viewer;
    protected MapLabelProvider labelProvider;
    private Color defaultLinkColor = null;
    private boolean disableGeolocationBackground = false;
    private NXCSession session = ConsoleSharedData.getSession();
    private SessionListener sessionListener;
    private NetworkMapPage mapPage = null;
    private List<DoubleClickHandlerData> doubleClickHandlers = new ArrayList<DoubleClickHandlerData>(0);
    private Stack<Long> history = new Stack();
    private long currentMapId = 0L;
    private LinkDciValueProvider dciValueProvider = LinkDciValueProvider.getInstance();

    public NetworkMapWidget(Composite parent, int style) {
        super(parent, style);
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        this.disableGeolocationBackground = ps.getBoolean("DISABLE_GEOLOCATION_BACKGROUND");
        this.setLayout((Layout)new FillLayout());
        this.viewer = new ExtendedGraphViewer(this, 0);
        this.viewer.setContentProvider((IContentProvider)new MapContentProvider(this.viewer));
        this.labelProvider = new MapLabelProvider(this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (NetworkMapWidget.this.defaultLinkColor != null) {
                    NetworkMapWidget.this.defaultLinkColor.dispose();
                }
                if (NetworkMapWidget.this.sessionListener != null) {
                    NetworkMapWidget.this.session.removeListener(NetworkMapWidget.this.sessionListener);
                }
            }
        });
        this.sessionListener = new SessionListener(){

            public void notificationHandler(final SessionNotification n) {
                if (n.getCode() == 4) {
                    NetworkMapWidget.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            NetworkMapWidget.this.onObjectChange((AbstractObject)n.getObject());
                        }
                    });
                }
            }
        };
        this.session.addListener(this.sessionListener);
    }

    public void enableObjectDoubleClick() {
        this.registerDoubleClickHandlers();
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)NetworkMapWidget.this.viewer.getSelection();
                if (selection.isEmpty() || !(selection.getFirstElement() instanceof NetworkMapObject)) {
                    return;
                }
                AbstractObject object = ConsoleSharedData.getSession().findObjectById(((NetworkMapObject)selection.getFirstElement()).getObjectId());
                if (object == null) {
                    return;
                }
                for (DoubleClickHandlerData h : NetworkMapWidget.this.doubleClickHandlers) {
                    if (h.enabledFor != null && !h.enabledFor.isInstance(object) || !h.handler.onDoubleClick(object)) continue;
                    return;
                }
                NetworkMapWidget.this.openSubmap(object);
            }
        });
    }

    private void openSubmap(AbstractObject object) {
        long submapId;
        long l = submapId = object instanceof NetworkMap ? object.getObjectId() : object.getSubmapId();
        if (submapId == 0L) {
            return;
        }
        NetworkMap map = (NetworkMap)ConsoleSharedData.getSession().findObjectById(submapId, NetworkMap.class);
        if (map != null) {
            this.history.push(this.currentMapId);
            this.setContent(map, false);
            this.viewer.showBackButton(new Runnable(){

                @Override
                public void run() {
                    NetworkMapWidget.this.goBack();
                }
            });
        }
    }

    private void goBack() {
        if (this.history.isEmpty()) {
            return;
        }
        long submapId = this.history.pop();
        NetworkMap map = (NetworkMap)ConsoleSharedData.getSession().findObjectById(submapId, NetworkMap.class);
        if (map != null) {
            this.setContent(map, false);
        }
        if (this.history.isEmpty()) {
            this.viewer.hideBackButton();
        }
    }

    private void onObjectChange(AbstractObject object) {
        List links;
        if (this.mapPage == null) {
            return;
        }
        NetworkMapObject element = this.mapPage.findObjectElement(object.getObjectId());
        if (element != null) {
            this.viewer.refresh(element, true);
        }
        if ((links = this.mapPage.findLinksWithStatusObject(object.getObjectId())) != null) {
            for (NetworkMapLink l : links) {
                this.viewer.refresh(l);
            }
        }
    }

    public void setContent(NetworkMapPage page) {
        this.mapPage = page;
        this.addDciToRequestList();
        this.viewer.setInput(page);
    }

    public void setContent(NetworkMap mapObject) {
        this.setContent(mapObject, true);
    }

    private void setContent(NetworkMap mapObject, boolean resetHistory) {
        this.currentMapId = mapObject.getObjectId();
        this.setMapLayout(mapObject.getLayout());
        if (mapObject.getBackground() != null && mapObject.getBackground().compareTo(NXCommon.EMPTY_GUID) != 0) {
            if (mapObject.getBackground().equals(NetworkMap.GEOMAP_BACKGROUND)) {
                if (!this.disableGeolocationBackground) {
                    this.viewer.setBackgroundImage(mapObject.getBackgroundLocation(), mapObject.getBackgroundZoom());
                }
            } else {
                this.viewer.setBackgroundImage(ImageProvider.getInstance().getImage(mapObject.getBackground()));
            }
        }
        this.setConnectionRouter(mapObject.getDefaultLinkRouting());
        this.viewer.setBackgroundColor(ColorConverter.rgbFromInt((int)mapObject.getBackgroundColor()));
        if (mapObject.getDefaultLinkColor() >= 0) {
            if (this.defaultLinkColor != null) {
                this.defaultLinkColor.dispose();
            }
            this.defaultLinkColor = new Color((Device)this.viewer.getControl().getDisplay(), ColorConverter.rgbFromInt((int)mapObject.getDefaultLinkColor()));
            this.labelProvider.setDefaultLinkColor(this.defaultLinkColor);
        }
        this.labelProvider.setObjectFigureType(mapObject.getObjectDisplayMode());
        this.labelProvider.setShowStatusBackground((mapObject.getFlags() & 4) > 0);
        this.labelProvider.setShowStatusFrame((mapObject.getFlags() & 2) > 0);
        this.labelProvider.setShowStatusIcons((mapObject.getFlags() & 1) > 0);
        this.mapPage = mapObject.createMapPage();
        this.addDciToRequestList();
        this.viewer.setInput(this.mapPage);
        if (resetHistory) {
            this.history.clear();
        }
    }

    public void setMapLayout(MapLayoutAlgorithm layout) {
        if (layout == MapLayoutAlgorithm.MANUAL) {
            this.viewer.setLayoutAlgorithm(new ManualLayout());
        } else {
            this.setLayoutAlgorithm(layout);
        }
    }

    private void setLayoutAlgorithm(MapLayoutAlgorithm alg) {
        SpringLayoutAlgorithm algorithm;
        switch (alg) {
            case SPRING: {
                algorithm = new SpringLayoutAlgorithm();
                break;
            }
            case RADIAL: {
                algorithm = new RadialLayoutAlgorithm();
                break;
            }
            case HTREE: {
                algorithm = new TreeLayoutAlgorithm(3);
                break;
            }
            case VTREE: {
                algorithm = new TreeLayoutAlgorithm(1);
                break;
            }
            case SPARSE_VTREE: {
                TreeLayoutAlgorithm mainLayoutAlgorithm = new TreeLayoutAlgorithm(1);
                this.viewer.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        return e1.toString().compareToIgnoreCase(e2.toString());
                    }
                });
                algorithm = new CompositeLayoutAlgorithm(new LayoutAlgorithm[]{mainLayoutAlgorithm, new SparseTree()});
                break;
            }
            default: {
                algorithm = new GridLayoutAlgorithm();
            }
        }
        this.viewer.setLayoutAlgorithm((LayoutAlgorithm)algorithm);
    }

    public void setConnectionRouter(int routingAlgorithm) {
        switch (routingAlgorithm) {
            case 2: {
                this.viewer.getGraphControl().setRouter((ConnectionRouter)new ManhattanConnectionRouter());
                break;
            }
            default: {
                this.viewer.getGraphControl().setRouter(null);
            }
        }
        this.viewer.refresh();
    }

    public void zoomTo(double zoomLevel) {
        this.viewer.zoomTo(zoomLevel);
    }

    private void registerDoubleClickHandlers() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.networkmaps.objectDoubleClickHandlers");
        int i = 0;
        while (i < elements.length) {
            try {
                DoubleClickHandlerData h = new DoubleClickHandlerData();
                h.handler = (ObjectDoubleClickHandler)elements[i].createExecutableExtension("class");
                h.priority = NetworkMapWidget.safeParseInt(elements[i].getAttribute("priority"));
                String className = elements[i].getAttribute("enabledFor");
                try {
                    h.enabledFor = className != null ? Class.forName(className) : null;
                }
                catch (Exception exception) {
                    h.enabledFor = null;
                }
                this.doubleClickHandlers.add(h);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
        Collections.sort(this.doubleClickHandlers, new Comparator<DoubleClickHandlerData>(){

            @Override
            public int compare(DoubleClickHandlerData arg0, DoubleClickHandlerData arg1) {
                return arg0.priority - arg1.priority;
            }
        });
    }

    private static int safeParseInt(String string) {
        if (string == null) {
            return 65535;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 65535;
        }
    }

    protected void addDciToRequestList() {
        Collection linkList = this.mapPage.getLinks();
        for (NetworkMapLink item : linkList) {
            if (!item.hasDciData()) continue;
            for (SingleDciConfig value : item.getDciAsList()) {
                if (value.type == 1) {
                    this.dciValueProvider.addDci(value.getNodeId(), value.dciId, this.mapPage);
                    continue;
                }
                this.dciValueProvider.addDci(value.getNodeId(), value.dciId, value.column, value.instance, this.mapPage);
            }
        }
        Collection mapElements = this.mapPage.getElements();
        for (NetworkMapElement element : mapElements) {
            NetworkMapDCIContainer item;
            if (element instanceof NetworkMapDCIContainer && (item = (NetworkMapDCIContainer)element).hasDciData()) {
                SingleDciConfig[] singleDciConfigArray = item.getObjectDCIArray();
                int n = singleDciConfigArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SingleDciConfig value = singleDciConfigArray[n2];
                    if (value.type == 1) {
                        this.dciValueProvider.addDci(value.getNodeId(), value.dciId, this.mapPage);
                    } else {
                        this.dciValueProvider.addDci(value.getNodeId(), value.dciId, value.column, value.instance, this.mapPage);
                    }
                    ++n2;
                }
            }
            if (!(element instanceof NetworkMapDCIImage)) continue;
            item = (NetworkMapDCIImage)element;
            DCIImageConfiguration config = item.getImageOptions();
            SingleDciConfig value = config.getDci();
            if (value.type == 1) {
                this.dciValueProvider.addDci(value.getNodeId(), value.dciId, this.mapPage);
                continue;
            }
            this.dciValueProvider.addDci(value.getNodeId(), value.dciId, value.column, value.instance, this.mapPage);
        }
    }

    private class DoubleClickHandlerData {
        ObjectDoubleClickHandler handler;
        int priority;
        Class<?> enabledFor;

        private DoubleClickHandlerData() {
        }
    }
}

