/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.tools;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.netxms.ui.eclipse.tools.ColorCache;

public class ColorConverter {
    public static int rgbToInt(RGB rgb) {
        return rgb.red | rgb.green << 8 | rgb.blue << 16;
    }

    public static RGB rgbFromInt(int color) {
        return new RGB(color & 0xFF, color >> 8 & 0xFF, color >> 16 & 0xFF);
    }

    public static Color colorFromInt(int rgb, ColorCache cache) {
        return cache.create(rgb & 0xFF, rgb >> 8 & 0xFF, rgb >> 16 & 0xFF);
    }

    public static Color getColorFromPreferences(IPreferenceStore store, String name, ColorCache cache) {
        return cache.create(PreferenceConverter.getColor((IPreferenceStore)store, (String)name));
    }

    public static int getColorFromPreferencesAsInt(IPreferenceStore store, String name) {
        return ColorConverter.rgbToInt(PreferenceConverter.getColor((IPreferenceStore)store, (String)name));
    }

    private static float lerp(float start, float end, float amount) {
        float difference = end - start;
        float adjusted = difference * amount;
        return start + adjusted;
    }

    public static Color adjustColor(Color color, RGB direction, float amount, ColorCache cache) {
        float sr = color.getRed();
        float sg = color.getGreen();
        float sb = color.getBlue();
        float dr = direction.red;
        float dg = direction.green;
        float db = direction.blue;
        return cache.create((int)ColorConverter.lerp(sr, dr, amount), (int)ColorConverter.lerp(sg, dg, amount), (int)ColorConverter.lerp(sb, db, amount));
    }
}

