/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;

public class DateTimeSelector
extends Composite {
    private DateTime datePicker;
    private DateTime timePicker;

    public DateTimeSelector(Composite parent, int style) {
        super(parent, style);
        RowLayout layout = new RowLayout();
        layout.type = 256;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.spacing = 2;
        this.setLayout((Layout)layout);
        this.datePicker = new DateTime((Composite)this, 36);
        this.timePicker = new DateTime((Composite)this, 128);
    }

    public Date getValue() {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(this.datePicker.getYear(), this.datePicker.getMonth(), this.datePicker.getDay(), this.timePicker.getHours(), this.timePicker.getMinutes(), this.timePicker.getSeconds());
        return c.getTime();
    }

    public void setValue(Date date) {
        if (date == null) {
            return;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        this.datePicker.setDate(c.get(1), c.get(2), c.get(5));
        this.timePicker.setTime(c.get(11), c.get(12), c.get(13));
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.datePicker.setEnabled(enabled);
        this.timePicker.setEnabled(enabled);
    }
}

