/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.propertypages;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.objecttools.Activator;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class General
extends PropertyPage {
    private ObjectToolDetails objectTool;
    private LabeledText textName;
    private LabeledText textDescription;
    private LabeledText textData;
    private LabeledSpinner maxFileSize;
    private LabeledText textParameter;
    private LabeledText textRegexp;
    private Button checkOutput;
    private Button checkConfirmation;
    private LabeledText textConfirmation;
    private Button checkDisable;
    private Button checkFollow;
    private Button checkCommand;
    private LabeledText textCommandName;
    private LabeledText textCommandShortName;
    private Button radioIndexOID;
    private Button radioIndexValue;
    private Label iconLabel;
    private Image icon;

    public void createControl(Composite parent) {
        this.noDefaultAndApplyButton();
        super.createControl(parent);
    }

    protected Control createContents(Composite parent) {
        this.objectTool = (ObjectToolDetails)this.getElement().getAdapter(ObjectToolDetails.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.textName = new LabeledText(dialogArea, 0);
        Messages.get();
        this.textName.setLabel(Messages.General_Name);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textName.setLayoutData((Object)gd);
        this.textName.setText(this.objectTool.getName());
        this.createIcon();
        this.createIconSelector(dialogArea);
        this.textDescription = new LabeledText(dialogArea, 0);
        Messages.get();
        this.textDescription.setLabel(Messages.General_Description);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.textDescription.setLayoutData((Object)gd);
        this.textDescription.setText(this.objectTool.getDescription());
        this.textData = new LabeledText(dialogArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.textData.setLayoutData((Object)gd);
        this.textData.setText(this.objectTool.getData());
        switch (this.objectTool.getType()) {
            case 0: {
                Messages.get();
                this.textData.setLabel(Messages.General_Operation);
                break;
            }
            case 5: 
            case 6: {
                Messages.get();
                this.textData.setLabel(Messages.General_Command);
                this.createOutputGroup(dialogArea);
                break;
            }
            case 8: {
                Messages.get();
                this.textData.setLabel(Messages.General_Script);
                this.createOutputGroup(dialogArea);
                break;
            }
            case 1: {
                Messages.get();
                this.textData.setLabel(Messages.General_AgentCommand);
                this.createOutputGroup(dialogArea);
                break;
            }
            case 4: {
                Messages.get();
                this.textData.setLabel(Messages.General_URL);
                break;
            }
            case 7: {
                String[] parameters = this.objectTool.getData().split("\u007f");
                Messages.get();
                this.textData.setLabel(Messages.General_RemoteFileName);
                this.textData.setText(parameters.length > 0 ? parameters[0] : "");
                Group fileOptionsGoup = new Group(dialogArea, 0);
                Messages.get();
                fileOptionsGoup.setText(Messages.General_FileOptions);
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalSpan = 2;
                fileOptionsGoup.setLayoutData((Object)gd);
                GridLayout fileGroupLayout = new GridLayout();
                fileGroupLayout.verticalSpacing = 4;
                fileGroupLayout.numColumns = 1;
                fileOptionsGoup.setLayout((Layout)fileGroupLayout);
                this.maxFileSize = new LabeledSpinner((Composite)fileOptionsGoup, 0);
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                this.maxFileSize.setLayoutData((Object)gd);
                Messages.get();
                this.maxFileSize.setLabel(Messages.General_LimitDownloadFileSizeLable);
                this.maxFileSize.setRange(0, Integer.MAX_VALUE);
                try {
                    this.maxFileSize.setSelection(parameters.length > 1 ? Integer.parseInt(parameters[1]) : 0);
                }
                catch (NumberFormatException numberFormatException) {
                    this.maxFileSize.setSelection(0);
                }
                this.checkFollow = new Button((Composite)fileOptionsGoup, 32);
                Messages.get();
                this.checkFollow.setText(Messages.General_FollowFileChanges);
                if (parameters.length <= 2) break;
                this.checkFollow.setSelection(parameters[2].equals("true"));
                break;
            }
            case 2: {
                Messages.get();
                this.textData.setLabel(Messages.General_Title);
                Group snmpOptGroup = new Group(dialogArea, 0);
                Messages.get();
                snmpOptGroup.setText(Messages.General_SNMPListOptions);
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalSpan = 2;
                snmpOptGroup.setLayoutData((Object)gd);
                layout = new GridLayout();
                snmpOptGroup.setLayout((Layout)layout);
                Label label = new Label((Composite)snmpOptGroup, 0);
                Messages.get();
                label.setText(Messages.General_UseAsIndex);
                this.radioIndexOID = new Button((Composite)snmpOptGroup, 16);
                Messages.get();
                this.radioIndexOID.setText(Messages.General_OIDSuffix);
                this.radioIndexOID.setSelection((this.objectTool.getFlags() & 0x10000) == 0);
                this.radioIndexValue = new Button((Composite)snmpOptGroup, 16);
                Messages.get();
                this.radioIndexValue.setText(Messages.General_FirstColumnValue);
                this.radioIndexValue.setSelection(!this.radioIndexOID.getSelection());
                break;
            }
            case 3: {
                Messages.get();
                this.textData.setLabel(Messages.General_Title);
                String[] parts = this.objectTool.getData().split("\u007f");
                this.textData.setText(parts.length > 0 ? parts[0] : "");
                this.textParameter = new LabeledText(dialogArea, 0);
                Messages.get();
                this.textParameter.setLabel(Messages.General_Parameter);
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalSpan = 2;
                this.textParameter.setLayoutData((Object)gd);
                this.textParameter.setText(parts.length > 1 ? parts[1] : "");
                this.textRegexp = new LabeledText(dialogArea, 0);
                Messages.get();
                this.textRegexp.setLabel(Messages.General_RegExp);
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalSpan = 2;
                this.textRegexp.setLayoutData((Object)gd);
                this.textRegexp.setText(parts.length > 2 ? parts[2] : "");
            }
        }
        Group confirmationGroup = new Group(dialogArea, 0);
        Messages.get();
        confirmationGroup.setText(Messages.General_Confirmation);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        confirmationGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        confirmationGroup.setLayout((Layout)layout);
        this.checkConfirmation = new Button((Composite)confirmationGroup, 32);
        Messages.get();
        this.checkConfirmation.setText(Messages.General_RequiresConfirmation);
        this.checkConfirmation.setSelection((this.objectTool.getFlags() & 8) != 0);
        this.checkConfirmation.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                General.this.textConfirmation.setEnabled(General.this.checkConfirmation.getSelection());
                if (General.this.checkConfirmation.getSelection()) {
                    General.this.textConfirmation.setFocus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.textConfirmation = new LabeledText((Composite)confirmationGroup, 0);
        Messages.get();
        this.textConfirmation.setLabel(Messages.General_ConfirmationMessage);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textConfirmation.setLayoutData((Object)gd);
        this.textConfirmation.setText(this.objectTool.getConfirmationText());
        this.textConfirmation.setEnabled(this.checkConfirmation.getSelection());
        Group commandGroup = new Group(dialogArea, 0);
        Messages.get();
        commandGroup.setText(Messages.General_ShowInCommands);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        commandGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        commandGroup.setLayout((Layout)layout);
        this.checkCommand = new Button((Composite)commandGroup, 32);
        Messages.get();
        this.checkCommand.setText(Messages.General_ShowInCommandsTooltip);
        this.checkCommand.setSelection((this.objectTool.getFlags() & 0x40) != 0);
        this.checkCommand.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                General.this.textCommandName.setEnabled(General.this.checkCommand.getSelection());
                General.this.textCommandShortName.setEnabled(General.this.checkCommand.getSelection());
                if (General.this.checkCommand.getSelection()) {
                    General.this.textCommandName.setFocus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkCommand.setLayoutData((Object)gd);
        this.textCommandName = new LabeledText((Composite)commandGroup, 0);
        Messages.get();
        this.textCommandName.setLabel(Messages.General_CommandName);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textCommandName.setLayoutData((Object)gd);
        this.textCommandName.setText(this.objectTool.getCommandName());
        this.textCommandName.setEnabled(this.checkCommand.getSelection());
        this.textCommandShortName = new LabeledText((Composite)commandGroup, 0);
        Messages.get();
        this.textCommandShortName.setLabel(Messages.General_CommandShortName);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textCommandShortName.setLayoutData((Object)gd);
        this.textCommandShortName.setText(this.objectTool.getCommandShortName());
        this.textCommandShortName.setEnabled(this.checkCommand.getSelection());
        this.checkDisable = new Button(dialogArea, 32);
        Messages.get();
        this.checkDisable.setText(Messages.General_DisableObjectToll);
        this.checkDisable.setSelection((this.objectTool.getFlags() & 0x20) > 0);
        return dialogArea;
    }

    private void createOutputGroup(Composite parent) {
        Group outputGroup = new Group(parent, 0);
        Messages.get();
        outputGroup.setText(Messages.General_ExecOptions);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        outputGroup.setLayoutData((Object)gd);
        outputGroup.setLayout((Layout)new GridLayout());
        this.checkOutput = new Button((Composite)outputGroup, 32);
        Messages.get();
        this.checkOutput.setText(Messages.General_GeneratesOutput);
        this.checkOutput.setSelection((this.objectTool.getFlags() & 0x10) != 0);
    }

    private void createIcon() {
        byte[] imageBytes;
        if (this.icon != null) {
            this.icon.dispose();
            this.icon = null;
        }
        if ((imageBytes = this.objectTool.getImageData()) == null || imageBytes.length == 0) {
            return;
        }
        ByteArrayInputStream input = new ByteArrayInputStream(imageBytes);
        try {
            ImageDescriptor d = ImageDescriptor.createFromImageData((ImageData)new ImageData((InputStream)input));
            this.icon = d.createImage();
        }
        catch (Exception e) {
            Activator.logError("Exception in General.createIcon()", e);
        }
    }

    private void createIconSelector(Composite parent) {
        Group group = new Group(parent, 0);
        Messages.get();
        group.setText(Messages.General_Icon);
        group.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        group.setLayout((Layout)layout);
        this.iconLabel = new Label((Composite)group, 0);
        this.iconLabel.setImage(this.icon != null ? this.icon : SharedIcons.IMG_EMPTY);
        this.iconLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, true));
        Label dummy = new Label((Composite)group, 0);
        GridData gd = new GridData();
        gd.widthHint = 8;
        dummy.setLayoutData((Object)gd);
        Button link = new Button((Composite)group, 8);
        link.setImage(SharedIcons.IMG_FIND);
        Messages.get();
        link.setToolTipText(Messages.General_Select);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                General.this.selectIcon();
            }
        });
        link = new Button((Composite)group, 8);
        link.setImage(SharedIcons.IMG_CLEAR);
        Messages.get();
        link.setToolTipText(Messages.General_Clear);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                General.this.iconLabel.setImage(SharedIcons.IMG_EMPTY);
                if (General.this.icon != null) {
                    General.this.icon.dispose();
                    General.this.icon = null;
                }
            }
        });
    }

    private void selectIcon() {
        FileDialog dlg = new FileDialog(this.getShell(), 4096);
        dlg.setFilterExtensions(new String[]{"*.gif;*.jpg;*.png", "*.*"});
        String[] stringArray = new String[2];
        Messages.get();
        stringArray[0] = Messages.General_ImageFiles;
        Messages.get();
        stringArray[1] = Messages.General_AllFiles;
        dlg.setFilterNames(stringArray);
        String fileName = dlg.open();
        if (fileName == null) {
            return;
        }
        try {
            Image image = new Image((Device)this.getShell().getDisplay(), (InputStream)new FileInputStream(new File(fileName)));
            if (image.getImageData().width <= 16 && image.getImageData().height <= 16) {
                if (this.icon != null) {
                    this.icon.dispose();
                }
                this.icon = image;
                this.iconLabel.setImage(this.icon);
            } else {
                image.dispose();
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openError((Shell)shell, (String)Messages.General_Error, (String)Messages.General_ImageTooLarge);
            }
        }
        catch (Exception e) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.General_Error, (String)String.format(Messages.General_CannotLoadImage, e.getLocalizedMessage()));
        }
    }

    protected void applyChanges(boolean isApply) {
        this.objectTool.setName(this.textName.getText());
        this.objectTool.setDescription(this.textDescription.getText());
        if (this.objectTool.getType() == 3) {
            this.objectTool.setData(String.valueOf(this.textData.getText()) + "\u007f" + this.textParameter.getText() + "\u007f" + this.textRegexp.getText());
        } else if (this.objectTool.getType() == 7) {
            this.objectTool.setData(String.valueOf(this.textData.getText()) + "\u007f" + this.maxFileSize.getSelection() + "\u007f" + this.checkFollow.getSelection());
        } else {
            this.objectTool.setData(this.textData.getText());
        }
        if (this.checkConfirmation.getSelection()) {
            this.objectTool.setFlags(this.objectTool.getFlags() | 8);
        } else {
            this.objectTool.setFlags(this.objectTool.getFlags() & 0xFFFFFFF7);
        }
        this.objectTool.setConfirmationText(this.textConfirmation.getText());
        if (this.checkCommand.getSelection()) {
            this.objectTool.setFlags(this.objectTool.getFlags() | 0x40);
        } else {
            this.objectTool.setFlags(this.objectTool.getFlags() & 0xFFFFFFBF);
        }
        this.objectTool.setCommandName(this.textCommandName.getText());
        this.objectTool.setCommandShortName(this.textCommandShortName.getText());
        if (this.checkDisable.getSelection()) {
            this.objectTool.setFlags(this.objectTool.getFlags() | 0x20);
        } else {
            this.objectTool.setFlags(this.objectTool.getFlags() & 0xFFFFFFDF);
        }
        if (this.objectTool.getType() == 2) {
            if (this.radioIndexValue.getSelection()) {
                this.objectTool.setFlags(this.objectTool.getFlags() | 0x10000);
            } else {
                this.objectTool.setFlags(this.objectTool.getFlags() & 0xFFFEFFFF);
            }
        }
        if (this.objectTool.getType() == 5 || this.objectTool.getType() == 6 || this.objectTool.getType() == 8 || this.objectTool.getType() == 1) {
            if (this.checkOutput.getSelection()) {
                this.objectTool.setFlags(this.objectTool.getFlags() | 0x10);
            } else {
                this.objectTool.setFlags(this.objectTool.getFlags() & 0xFFFFFFEF);
            }
        }
        if (this.icon != null) {
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{this.icon.getImageData()};
            ByteArrayOutputStream stream = new ByteArrayOutputStream(1024);
            loader.save((OutputStream)stream, 5);
            this.objectTool.setImageData(stream.toByteArray());
        } else {
            this.objectTool.setImageData(null);
        }
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }
}

