/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.elements;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.OverviewPageElement;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class Connection
extends OverviewPageElement {
    private NXCSession session = ConsoleSharedData.getSession();
    private CLabel nodeLabel;
    private CLabel interfaceLabel;
    private CLabel protocolLabel;
    private WorkbenchLabelProvider labelProvider;

    public Connection(Composite parent, OverviewPageElement anchor, ObjectTab objectTab) {
        super(parent, anchor, objectTab);
    }

    @Override
    protected Control createClientArea(Composite parent) {
        this.labelProvider = new WorkbenchLabelProvider();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Connection.this.labelProvider.dispose();
            }
        });
        Composite area = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        area.setLayout((Layout)layout);
        area.setBackground(SharedColors.getColor((String)"ObjectTab.Background", (Display)parent.getDisplay()));
        this.nodeLabel = new CLabel(area, 0);
        this.nodeLabel.setBackground(area.getBackground());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.nodeLabel.setLayoutData((Object)gd);
        this.interfaceLabel = new CLabel(area, 0);
        this.interfaceLabel.setBackground(area.getBackground());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalIndent = 15;
        this.interfaceLabel.setLayoutData((Object)gd);
        this.protocolLabel = new CLabel(area, 0);
        this.protocolLabel.setBackground(area.getBackground());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalIndent = 15;
        this.protocolLabel.setLayoutData((Object)gd);
        return area;
    }

    @Override
    protected String getTitle() {
        Messages.get();
        return Messages.Connection_Title;
    }

    @Override
    protected void onObjectChange() {
        if (this.getObject() == null || !(this.getObject() instanceof Interface)) {
            return;
        }
        Interface iface = (Interface)this.getObject();
        long peerNodeId = iface.getPeerNodeId();
        if (peerNodeId != 0L) {
            AbstractObject node = this.session.findObjectById(peerNodeId);
            this.nodeLabel.setText(node != null ? node.getObjectName() : "<" + peerNodeId + ">");
            this.nodeLabel.setImage(this.labelProvider.getImage((Object)node));
        } else {
            Messages.get();
            this.nodeLabel.setText(Messages.Connection_NA);
        }
        long peerInterfaceId = iface.getPeerInterfaceId();
        if (peerInterfaceId != 0L) {
            AbstractObject peerIface = this.session.findObjectById(peerInterfaceId);
            this.interfaceLabel.setText(peerIface != null ? peerIface.getObjectName() : "<" + peerInterfaceId + ">");
            this.interfaceLabel.setImage(this.labelProvider.getImage((Object)peerIface));
            this.protocolLabel.setText(iface.getPeerDiscoveryProtocol().toString());
        } else {
            Messages.get();
            this.interfaceLabel.setText(Messages.Connection_NA);
            this.protocolLabel.setText("");
        }
    }

    @Override
    public boolean isApplicableForObject(AbstractObject object) {
        return object instanceof Interface && ((Interface)object).getPeerNodeId() != 0L;
    }
}

