/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps.configs;

import org.netxms.client.datacollection.DciValue;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="dci")
public class SingleDciConfig {
    public static final int ITEM = 1;
    public static final int TABLE = 2;
    @Attribute
    public long nodeId;
    @Attribute
    public long dciId;
    @Element(required=false)
    public int type;
    @Element(required=false)
    public String name;
    @Element(required=false)
    public String instance;
    @Element(required=false)
    public String column;
    @Element(required=false)
    public String formatString;

    public SingleDciConfig() {
        this.nodeId = 0L;
        this.dciId = 0L;
        this.setType(1);
        this.name = "";
        this.setInstance("");
        this.setColumn("");
        this.setFormatString("");
    }

    public SingleDciConfig(SingleDciConfig src) {
        this.nodeId = src.nodeId;
        this.dciId = src.dciId;
        this.setType(src.getType());
        this.name = src.name;
        this.formatString = src.formatString;
        this.setInstance(src.getInstance());
        this.setColumn(src.getColumn());
    }

    public SingleDciConfig(DciValue dci) {
        this.nodeId = dci.getNodeId();
        this.dciId = dci.getId();
        this.setType(dci.getDcObjectType());
        this.name = dci.getDescription();
        this.formatString = "";
        this.setInstance("");
        this.setColumn("");
    }

    public String getName() {
        return this.name != null && !this.name.isEmpty() ? this.name : "[" + Long.toString(this.dciId) + "]";
    }

    public String getFormatString() {
        return this.formatString == null ? "" : this.formatString;
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public long getDciId() {
        return this.dciId;
    }

    public void setDciId(long dciId) {
        this.dciId = dciId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }
}

