/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.epp.widgets;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.situations.Situation;
import org.netxms.ui.eclipse.epp.Messages;
import org.netxms.ui.eclipse.epp.SituationCache;
import org.netxms.ui.eclipse.epp.dialogs.SituationSelectionDialog;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class SituationSelector
extends AbstractSelector {
    private long situationId = 0L;

    public SituationSelector(Composite parent, int style) {
        super(parent, style, 12);
        Messages.get();
        this.setText(Messages.SituationSelector_None);
    }

    protected void selectionButtonHandler() {
        SituationSelectionDialog dlg = new SituationSelectionDialog(this.getShell());
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            Situation[] situations = dlg.getSelectedSituations();
            if (situations.length > 0) {
                this.situationId = situations[0].getId();
                this.setText(situations[0].getName());
                this.getTextControl().setToolTipText(situations[0].getComments());
            } else {
                this.situationId = 0L;
                Messages.get();
                this.setText(Messages.SituationSelector_None);
                this.getTextControl().setToolTipText(null);
            }
        }
    }

    protected void clearButtonHandler() {
        this.situationId = 0L;
        Messages.get();
        this.setText(Messages.SituationSelector_None);
        this.getTextControl().setToolTipText(null);
    }

    public void setSituationId(long situationId) {
        this.situationId = situationId;
        if (situationId != 0L) {
            Situation s = SituationCache.findSituation(situationId);
            if (s != null) {
                this.setText(s.getName());
                this.getTextControl().setToolTipText(s.getComments());
            } else {
                Messages.get();
                this.setText(Messages.SituationSelector_Unknown);
                this.getTextControl().setToolTipText(null);
            }
        } else {
            Messages.get();
            this.setText(Messages.SituationSelector_None);
            this.getTextControl().setToolTipText(null);
        }
    }

    protected String getSelectionButtonToolTip() {
        Messages.get();
        return Messages.SituationSelector_Tooltip;
    }

    public long getSituationId() {
        return this.situationId;
    }
}

