/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.widgets;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.serverconfig.Messages;
import org.netxms.ui.eclipse.serverconfig.dialogs.LogMacroEditDialog;
import org.netxms.ui.eclipse.serverconfig.widgets.helpers.LogParser;
import org.netxms.ui.eclipse.serverconfig.widgets.helpers.LogParserModifyListener;
import org.netxms.ui.eclipse.serverconfig.widgets.helpers.LogParserRule;
import org.netxms.ui.eclipse.serverconfig.widgets.helpers.LogParserRuleEditor;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetFactory;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class LogParserEditor
extends Composite {
    private static final int TAB_NONE = 0;
    private static final int TAB_BUILDER = 1;
    private static final int TAB_XML = 2;
    private CTabFolder tabFolder;
    private int currentTab = 0;
    private Text xmlEditor;
    private FormToolkit toolkit;
    private ScrolledForm form;
    private Set<LogParserModifyListener> listeners = new HashSet<LogParserModifyListener>();
    private LogParser parser = new LogParser();
    private Composite rulesArea;
    private ImageHyperlink addColumnLink;
    private TableViewer macroList;
    private boolean isSyslogParser;
    private LabeledText labelFileName;
    private Spinner spinerTrace;
    private Button checkProcessAll;

    public LogParserEditor(Composite parent, int style, boolean isSyslogParser) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.isSyslogParser = isSyslogParser;
        this.tabFolder = new CTabFolder((Composite)this, 8389634);
        this.tabFolder.setUnselectedImageVisible(true);
        this.tabFolder.setSimple(true);
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String xml;
                switch (LogParserEditor.this.currentTab) {
                    case 1: {
                        xml = LogParserEditor.this.buildParserXml();
                        break;
                    }
                    case 2: {
                        xml = LogParserEditor.this.xmlEditor.getText();
                        break;
                    }
                    default: {
                        xml = null;
                    }
                }
                CTabItem tab = LogParserEditor.this.tabFolder.getSelection();
                LogParserEditor.this.currentTab = tab != null ? (Integer)tab.getData() : 0;
                if (xml != null) {
                    switch (LogParserEditor.this.currentTab) {
                        case 1: {
                            LogParserEditor.this.updateBuilderFromXml(LogParserEditor.this.xmlEditor.getText());
                            break;
                        }
                        case 2: {
                            LogParserEditor.this.xmlEditor.setText(LogParserEditor.this.buildParserXml());
                            break;
                        }
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.createForm();
        this.createTextEditor();
    }

    private void createForm() {
        this.toolkit = new FormToolkit(this.getDisplay());
        this.form = this.toolkit.createScrolledForm((Composite)this.tabFolder);
        Messages.get();
        this.form.setText(Messages.LogParserEditor_LogParser);
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        Messages.get();
        tabItem.setText(Messages.LogParserEditor_Editor);
        tabItem.setImage(SharedIcons.IMG_EDIT);
        tabItem.setControl((Control)this.form);
        tabItem.setData((Object)1);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        this.form.getBody().setLayout((Layout)layout);
        Section section = this.toolkit.createSection(this.form.getBody(), 256);
        section.setText("General");
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        td.colspan = 2;
        section.setLayoutData((Object)td);
        Composite generalArea = this.toolkit.createComposite((Composite)section);
        this.createGeneralArea(generalArea);
        section.setClient((Control)generalArea);
        section = this.toolkit.createSection(this.form.getBody(), 354);
        Messages.get();
        section.setText(Messages.LogParserEditor_Rules);
        td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        this.rulesArea = this.toolkit.createComposite((Composite)section);
        GridLayout rulesAreaLayout = new GridLayout();
        rulesAreaLayout.marginHeight = 0;
        rulesAreaLayout.marginWidth = 0;
        rulesAreaLayout.verticalSpacing = 1;
        this.rulesArea.setLayout((Layout)rulesAreaLayout);
        section.setClient((Control)this.rulesArea);
        this.addColumnLink = this.toolkit.createImageHyperlink(this.rulesArea, 0);
        Messages.get();
        this.addColumnLink.setText(Messages.LogParserEditor_AddRule);
        this.addColumnLink.setImage(SharedIcons.IMG_ADD_OBJECT);
        this.addColumnLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogParserEditor.this.addRule();
            }
        });
        section = this.toolkit.createSection(this.form.getBody(), 290);
        Messages.get();
        section.setText(Messages.LogParserEditor_Macros);
        td = new TableWrapData();
        td.align = 128;
        section.setLayoutData((Object)td);
        Composite macroArea = this.toolkit.createComposite((Composite)section);
        this.createMacroSection(macroArea);
        section.setClient((Control)macroArea);
        this.form.reflow(true);
    }

    private void createGeneralArea(Composite generalArea) {
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 3;
        generalArea.setLayout((Layout)layout);
        if (!this.isSyslogParser) {
            this.labelFileName = new LabeledText(generalArea, 0);
            this.labelFileName.setLabel("Parsing file path");
            this.labelFileName.setText(this.parser.getFile() != null ? this.parser.getFile() : "");
            GridData gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            this.labelFileName.setLayoutData((Object)gd);
            this.labelFileName.setText(this.parser.getFile());
            this.labelFileName.getTextControl().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LogParserEditor.this.fireModifyListeners();
                    for (LogParserRule rule : LogParserEditor.this.parser.getRules()) {
                        if (rule.getEditor() == null) continue;
                        rule.getEditor().updateWindowsEventLogFields();
                    }
                }
            });
        }
        WidgetFactory factory = new WidgetFactory(){

            public Control createControl(Composite parent, int style) {
                return new Spinner(parent, style);
            }
        };
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        this.spinerTrace = (Spinner)WidgetHelper.createLabeledControl((Composite)generalArea, (int)2048, (WidgetFactory)factory, (String)"Trace level", (Object)gd);
        this.spinerTrace.setMinimum(0);
        this.spinerTrace.setMaximum(9);
        this.spinerTrace.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LogParserEditor.this.fireModifyListeners();
            }
        });
        this.spinerTrace.setSelection(this.parser.getTrace() != null ? this.parser.getTrace() : 0);
        this.checkProcessAll = this.toolkit.createButton(generalArea, "Process all", 32);
        this.checkProcessAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogParserEditor.this.fireModifyListeners();
            }
        });
    }

    private void createTextEditor() {
        this.xmlEditor = new Text((Composite)this.tabFolder, 770);
        this.xmlEditor.setFont(JFaceResources.getTextFont());
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        Messages.get();
        tabItem.setText(Messages.LogParserEditor_XML);
        tabItem.setImage(SharedIcons.IMG_XML);
        tabItem.setControl((Control)this.xmlEditor);
        tabItem.setData((Object)2);
        this.xmlEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LogParserEditor.this.fireModifyListeners();
            }
        });
    }

    private void createMacroSection(Composite macroArea) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        macroArea.setLayout((Layout)layout);
        this.macroList = new TableViewer(macroArea, 2048);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 3;
        Table table = this.macroList.getTable();
        table.setLayoutData((Object)gd);
        TableColumn tc = new TableColumn(table, 16384);
        Messages.get();
        tc.setText(Messages.LogParserEditor_Name);
        tc.setWidth(100);
        tc = new TableColumn(table, 16384);
        Messages.get();
        tc.setText(Messages.LogParserEditor_Value);
        tc.setWidth(200);
        this.macroList.setContentProvider((IContentProvider)new ArrayContentProvider());
        ImageHyperlink link = this.toolkit.createImageHyperlink(macroArea, 0);
        link.setImage(SharedIcons.IMG_ADD_OBJECT);
        Messages.get();
        link.setText(Messages.LogParserEditor_Add);
        gd = new GridData();
        gd.verticalAlignment = 128;
        link.setLayoutData((Object)gd);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogParserEditor.this.addMacro();
            }
        });
        link = this.toolkit.createImageHyperlink(macroArea, 0);
        link.setImage(SharedIcons.IMG_EDIT);
        Messages.get();
        link.setText(Messages.LogParserEditor_Edit);
        gd = new GridData();
        gd.verticalAlignment = 128;
        link.setLayoutData((Object)gd);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogParserEditor.this.editMacro();
            }
        });
        link = this.toolkit.createImageHyperlink(macroArea, 0);
        link.setImage(SharedIcons.IMG_DELETE_OBJECT);
        Messages.get();
        link.setText(Messages.LogParserEditor_Delete);
        gd = new GridData();
        gd.verticalAlignment = 128;
        link.setLayoutData((Object)gd);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogParserEditor.this.deleteMacro();
            }
        });
    }

    public void addModifyListener(LogParserModifyListener modifyListener) {
        this.listeners.add(modifyListener);
    }

    public void removeModifyListener(LogParserModifyListener modifyListener) {
        this.listeners.remove(modifyListener);
    }

    public void fireModifyListeners() {
        for (LogParserModifyListener l : this.listeners) {
            l.modifyParser();
        }
    }

    public String getParserXml() {
        switch (this.currentTab) {
            case 1: {
                return this.buildParserXml();
            }
            case 2: {
                return this.xmlEditor.getText();
            }
        }
        return "<parser></parser>";
    }

    private String buildParserXml() {
        if (!this.isSyslogParser) {
            this.parser.setFile(this.labelFileName.getText());
        }
        this.parser.setProcessALL(this.checkProcessAll.getSelection());
        this.parser.setTrace(this.spinerTrace.getSelection());
        for (LogParserRule rule : this.parser.getRules()) {
            rule.getEditor().save();
        }
        try {
            return this.parser.createXml();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "<parser>\n</parser>";
        }
    }

    public void setParserXml(String xml) {
        this.updateBuilderFromXml(xml);
        this.xmlEditor.setText(xml);
    }

    private void updateBuilderFromXml(String xml) {
        if (this.parser != null) {
            for (LogParserRule rule : this.parser.getRules()) {
                rule.getEditor().dispose();
            }
        }
        try {
            this.parser = LogParser.createFromXml(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.LogParserEditor_Error, (String)Messages.LogParserEditor_InvalidDefinition);
            this.parser = new LogParser();
        }
        this.parser.setSyslogParser(this.isSyslogParser);
        if (!this.isSyslogParser) {
            this.labelFileName.setText(this.parser.getFile());
        }
        this.spinerTrace.setSelection(this.parser.getTrace() != null ? this.parser.getTrace() : 0);
        this.checkProcessAll.setSelection(this.parser.getProcessALL());
        for (LogParserRule rule : this.parser.getRules()) {
            this.createRuleEditor(rule).moveAbove((Control)this.addColumnLink);
        }
        this.macroList.setInput((Object)this.parser.getMacros().entrySet().toArray());
        this.form.reflow(true);
        this.form.getParent().layout(true, true);
    }

    private LogParserRuleEditor createRuleEditor(LogParserRule rule) {
        LogParserRuleEditor editor = new LogParserRuleEditor(this.rulesArea, this.toolkit, rule, this);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        editor.setLayoutData(gd);
        rule.setEditor(editor);
        return editor;
    }

    private void addRule() {
        LogParserRule rule = new LogParserRule();
        LogParserRuleEditor editor = this.createRuleEditor(rule);
        editor.moveAbove((Control)this.addColumnLink);
        this.parser.getRules().add(rule);
        this.form.reflow(true);
        this.fireModifyListeners();
    }

    private void addMacro() {
        LogMacroEditDialog dlg = new LogMacroEditDialog(this.getShell(), null, null);
        if (dlg.open() == 0) {
            this.parser.getMacros().put(dlg.getName(), dlg.getValue());
            this.macroList.setInput((Object)this.parser.getMacros().entrySet().toArray());
            this.fireModifyListeners();
        }
    }

    private void editMacro() {
        IStructuredSelection selection = (IStructuredSelection)this.macroList.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Map.Entry e = (Map.Entry)selection.getFirstElement();
        LogMacroEditDialog dlg = new LogMacroEditDialog(this.getShell(), (String)e.getKey(), (String)e.getValue());
        if (dlg.open() == 0) {
            this.parser.getMacros().put(dlg.getName(), dlg.getValue());
            this.macroList.setInput((Object)this.parser.getMacros().entrySet().toArray());
            this.fireModifyListeners();
        }
    }

    private void deleteMacro() {
        IStructuredSelection selection = (IStructuredSelection)this.macroList.getSelection();
        if (selection.size() == 0) {
            return;
        }
        Map<String, String> macros = this.parser.getMacros();
        for (Object o : selection.toList()) {
            macros.remove(((Map.Entry)o).getKey());
        }
        this.macroList.setInput((Object)macros.entrySet().toArray());
        this.fireModifyListeners();
    }

    public void deleteRule(LogParserRule rule) {
        this.parser.getRules().remove(rule);
        rule.getEditor().dispose();
        this.form.reflow(true);
        this.getParent().layout(true, true);
        this.fireModifyListeners();
    }

    public void moveRuleUp(LogParserRule rule) {
        int index = this.parser.getRules().indexOf(rule);
        if (index < 1) {
            return;
        }
        rule.getEditor().moveAbove((Control)this.parser.getRules().get(index - 1).getEditor());
        Collections.swap(this.parser.getRules(), index - 1, index);
        this.form.reflow(true);
        this.getParent().layout(true, true);
        this.fireModifyListeners();
    }

    public void moveRuleDown(LogParserRule rule) {
        int index = this.parser.getRules().indexOf(rule);
        if (index < 0 || index >= this.parser.getRules().size() - 1) {
            return;
        }
        rule.getEditor().moveBelow((Control)this.parser.getRules().get(index + 1).getEditor());
        Collections.swap(this.parser.getRules(), index + 1, index);
        this.form.reflow(true);
        this.getParent().layout(true, true);
        this.fireModifyListeners();
    }

    public boolean isSyslogParser() {
        return this.isSyslogParser;
    }

    public boolean isWindowsEventLogParser() {
        return this.labelFileName.getText().startsWith("*");
    }
}

