/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.widgets.helpers;

import org.netxms.ui.eclipse.serverconfig.widgets.helpers.LogParser;
import org.netxms.ui.eclipse.serverconfig.widgets.helpers.LogParserContext;
import org.netxms.ui.eclipse.serverconfig.widgets.helpers.LogParserEvent;
import org.netxms.ui.eclipse.serverconfig.widgets.helpers.LogParserMatch;
import org.netxms.ui.eclipse.serverconfig.widgets.helpers.LogParserRuleEditor;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="rule", strict=false)
public class LogParserRule {
    @Attribute(required=false)
    private String context = null;
    @Attribute(name="break", required=false)
    private String breakProcessing = null;
    @Element(required=true)
    private LogParserMatch match = new LogParserMatch();
    @Element(required=false)
    private LogParserEvent event = null;
    @Element(required=false)
    private Integer severity = null;
    @Element(required=false)
    private Integer level = null;
    @Element(required=false)
    private Integer facility = null;
    @Element(required=false)
    private Integer id = null;
    @Element(required=false)
    private String source = null;
    @Element(required=false)
    private String tag = null;
    @Element(required=false)
    private String description = null;
    @Element(name="context", required=false)
    private LogParserContext contextDefinition = null;
    private LogParserRuleEditor editor;

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public boolean isBreakProcessing() {
        return LogParser.stringToBoolean(this.breakProcessing);
    }

    public void setBreakProcessing(boolean breakProcessing) {
        this.breakProcessing = LogParser.booleanToString(breakProcessing);
    }

    public LogParserMatch getMatch() {
        return this.match;
    }

    public void setMatch(LogParserMatch matcher) {
        this.match = matcher;
    }

    public LogParserEvent getEvent() {
        return this.event;
    }

    public void setEvent(LogParserEvent event) {
        this.event = event;
    }

    public String getSeverityOrLevel(boolean isSyslogParser) {
        if (isSyslogParser) {
            return LogParser.integerToString(this.severity);
        }
        return LogParser.integerToString(this.level);
    }

    public void setSeverityOrLevel(Integer severity) {
        if (this.editor.isSyslogParser()) {
            this.severity = severity;
            this.level = null;
        } else {
            this.level = severity;
            this.severity = null;
        }
    }

    public String getFacilityOrId(boolean isSyslogParser) {
        if (isSyslogParser) {
            return LogParser.integerToString(this.facility);
        }
        return LogParser.integerToString(this.id);
    }

    public void setFacilityOrId(Integer facility) {
        if (this.editor.isSyslogParser()) {
            this.facility = facility;
            this.id = null;
        } else {
            this.id = facility;
            this.facility = null;
        }
    }

    public String getTagOrSource(boolean isSyslogParser) {
        if (isSyslogParser) {
            return this.tag == null ? "" : this.tag;
        }
        return this.source == null ? "" : this.source;
    }

    public void setTagOrSource(String tag) {
        if (this.editor.isSyslogParser()) {
            this.tag = tag;
            this.source = null;
        } else {
            this.tag = null;
            this.source = tag;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description == null || description.trim().isEmpty() ? null : description;
    }

    public LogParserContext getContextDefinition() {
        return this.contextDefinition;
    }

    public void setContextDefinition(LogParserContext contextDefinition) {
        this.contextDefinition = contextDefinition;
    }

    public LogParserRuleEditor getEditor() {
        return this.editor;
    }

    public void setEditor(LogParserRuleEditor editor) {
        this.editor = editor;
    }

    public void updateFieldsCorrectly(boolean isSyslogParser) {
        if (isSyslogParser) {
            if (this.facility == null || this.facility == 0) {
                this.facility = this.id;
            }
            if (this.tag == null || this.tag.isEmpty()) {
                this.tag = this.source;
            }
            if (this.severity == null || this.severity == 0) {
                this.severity = this.level;
            }
        } else {
            if (this.id == null || this.id == 0) {
                this.id = this.facility;
            }
            if (this.source == null || this.source.isEmpty()) {
                this.source = this.tag;
            }
            if (this.level == null || this.level == 0) {
                this.level = this.severity;
            }
        }
    }
}

