/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.Arrays;
import org.netxms.base.NXCPMessage;

public final class ProtocolVersion {
    public static final int BASE = 47;
    public static final int ALARMS = 1;
    public static final int PUSH = 1;
    public static final int TRAP = 1;
    public static final int MOBILE = 1;
    public static final int FULL = 5;
    public static final int INDEX_BASE = 0;
    public static final int INDEX_ALARMS = 1;
    public static final int INDEX_PUSH = 2;
    public static final int INDEX_TRAP = 3;
    public static final int INDEX_MOBILE = 4;
    public static final int INDEX_FULL = 5;
    private static final int[] CURRENT_VERSION = new int[]{47, 1, 1, 1, 1, 5};
    private long[] versions;

    protected ProtocolVersion(NXCPMessage msg) {
        this.versions = msg.getFieldAsUInt32Array(496L);
        if (this.versions == null) {
            this.versions = new long[1];
            this.versions[0] = msg.getFieldAsInt32(146L);
        }
    }

    public int getVersion(int index) {
        return index >= 0 && index < this.versions.length ? (int)this.versions[index] : 0;
    }

    public boolean isCorrectVersion(int index) {
        if (index < 0 || index >= CURRENT_VERSION.length) {
            return false;
        }
        return this.getVersion(index) == CURRENT_VERSION[index];
    }

    public String toString() {
        return "ProtocolVersion [versions=" + Arrays.toString(this.versions) + "]";
    }
}

