/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netxms.base.NXCPMessage;
import org.netxms.client.AccessListElement;
import org.netxms.client.datacollection.GraphSettingsChangeListener;

public class GraphSettings {
    public static final int MAX_GRAPH_ITEM_COUNT = 16;
    public static final int TIME_FRAME_FIXED = 0;
    public static final int TIME_FRAME_BACK_FROM_NOW = 1;
    public static final int TIME_FRAME_CURRENT = 2;
    public static final int TIME_UNIT_MINUTE = 0;
    public static final int TIME_UNIT_HOUR = 1;
    public static final int TIME_UNIT_DAY = 2;
    public static final int GF_AUTO_UPDATE = 1;
    public static final int GF_AUTO_SCALE = 256;
    public static final int GF_SHOW_GRID = 512;
    public static final int GF_SHOW_LEGEND = 1024;
    public static final int GF_SHOW_RULER = 2048;
    public static final int GF_SHOW_HOST_NAMES = 4096;
    public static final int GF_LOG_SCALE = 8192;
    public static final int GF_SHOW_TOOLTIPS = 16384;
    public static final int GF_ENABLE_ZOOM = 32768;
    public static final int POSITION_LEFT = 1;
    public static final int POSITION_RIGHT = 2;
    public static final int POSITION_TOP = 4;
    public static final int POSITION_BOTTOM = 8;
    public static final int ACCESS_READ = 1;
    public static final int ACCESS_WRITE = 2;
    public static final int GRAPH_FLAG_TEMPLATE = 1;
    private long id;
    private long ownerId;
    private int flags;
    private String name;
    private String shortName;
    private List<AccessListElement> accessList;
    private String config;
    private Set<GraphSettingsChangeListener> changeListeners = new HashSet<GraphSettingsChangeListener>(0);
    private String filters;

    public GraphSettings() {
        this.id = 0L;
        this.ownerId = 0L;
        this.flags = 0;
        this.name = "noname";
        this.shortName = "noname";
        this.accessList = new ArrayList<AccessListElement>(0);
        this.config = "<chart></chart>";
        this.filters = "<objectToolFilter></objectToolFilter>";
    }

    public GraphSettings(long id, long ownerId, int flags, Collection<AccessListElement> accessList) {
        this.id = id;
        this.ownerId = ownerId;
        this.name = "noname";
        this.shortName = "noname";
        this.flags = flags;
        this.accessList = new ArrayList<AccessListElement>(accessList.size());
        this.accessList.addAll(accessList);
        this.config = "<chart></chart>";
        this.filters = "<objectToolFilter></objectToolFilter>";
    }

    public GraphSettings(NXCPMessage msg, long baseId) {
        this.id = msg.getFieldAsInt64(baseId);
        this.ownerId = msg.getFieldAsInt64(baseId + 1L);
        this.flags = (int)msg.getFieldAsInt64(baseId + 2L);
        this.name = msg.getFieldAsString(baseId + 3L);
        this.config = msg.getFieldAsString(baseId + 4L);
        this.filters = msg.getFieldAsString(baseId + 5L);
        String[] parts = this.name.split("->");
        this.shortName = parts.length > 1 ? parts[parts.length - 1] : this.name;
        int count = msg.getFieldAsInt32(baseId + 6L);
        long[] users = msg.getFieldAsUInt32Array(baseId + 7L);
        long[] rights = msg.getFieldAsUInt32Array(baseId + 8L);
        this.accessList = new ArrayList<AccessListElement>(count);
        int i = 0;
        while (i < count) {
            this.accessList.add(new AccessListElement(users[i], (int)rights[i]));
            ++i;
        }
    }

    public long getId() {
        return this.id;
    }

    public long getOwnerId() {
        return this.ownerId;
    }

    public String getName() {
        return this.name;
    }

    public List<AccessListElement> getAccessList() {
        return this.accessList;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setName(String name) {
        this.name = name;
        String[] parts = name.split("->");
        this.shortName = parts.length > 1 ? parts[parts.length - 1] : name;
    }

    public void addChangeListener(GraphSettingsChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(GraphSettingsChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void fireChangeNotification() {
        for (GraphSettingsChangeListener l : this.changeListeners) {
            l.onGraphSettingsChange(this);
        }
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getFilters() {
        return this.filters;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }
}

